/* $Id: sampleio.c,v 2.23 1996/03/21 16:38:08 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:56 EST 1991
 *
 * Revision History: $Log: sampleio.c,v $
 * Revision 2.23  1996/03/21  16:38:08  bst
 * Added include of server.h and data.h for NADIRECT.
 *
 * Revision 2.22  1994/08/30  18:59:04  bst
 * Handle underrun errors under NADIRECT
 *
 * Revision 2.21  1994/03/07  18:35:12  bst
 * Handle EDLOVOVERRUN errors properly with NADIRECT.
 *
 * Revision 2.20  1993/11/19  03:19:55  bst
 * Don't use autoStatus under NADIRECT (buffer may be too small).
 *
 * Revision 2.19  1993/11/01  21:49:05  bst
 * Removed parse of status after each read that was added in previous rev.
 *
 * Revision 2.18  1993/10/30  20:26:37  bst
 * Modified debug message.
 * Parse status after reads in NADIRECT.
 *
 * Revision 2.17  1993/10/26  16:15:37  bst
 * Added coercions for GCC 2.5.0
 *
 * Revision 2.16  1993/09/29  03:03:24  bst
 * *** empty log message ***
 *
 * Revision 2.15  1993/09/11  14:13:55  bst
 * Retrieve status with reads when using NADIRECT.
 *
 * Revision 2.14  1993/08/10  02:17:30  bst
 * Coerce %l args to long.
 *
 * Revision 2.13  1993/06/23  20:37:06  bst
 * Changed 'long' to 'int32'
 *
 * Revision 2.12  1993/06/07  14:22:16  bst
 * Keep count of port->bytesSent.
 *
 * Revision 2.11  1993/05/21  17:27:25  bst
 * Added 4th arg to dat_read() call.
 *
 * Revision 2.10  1993/05/18  19:42:01  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 2.9  1993/04/12  02:27:39  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.8  1993/03/01  16:46:02  bst
 * Added some coercions for THINK-C
 *
 * Revision 2.7  1993/02/18  21:37:05  bst
 * Added include of dat_errno.h
 *
 * Revision 2.6  1993/02/08  19:47:13  bst
 * Don't print out error message for overrun here.
 *
 * Revision 2.5  1993/02/04  23:12:20  bst
 * NADIRECT support.
 * Check for EPIPE before using.
 *
 * Revision 2.4  1992/05/25  17:13:54  bst
 * Allow NARead() to return a partial buffer.
 *
 * Revision 2.3  1992/03/06  00:30:53  bst
 * Poll for more events if writing to server gave an error.
 *
 * Revision 2.2  1992/02/12  04:32:26  bst
 * Remove include of errno.h, it's in sysdefs.h now.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include "NAlibint.h"
#ifdef NADIRECT
#include "datlink.h"
#include "dat_errno.h"
#include "server.h"
#include "data.h"
#endif
#include "support.h"

/* Write samples - same as write(2), but using int32s */
int32 NAWrite(port,buffer,buflen)
NAport *port;
const char *buffer;
int32 buflen;
{
    int32 nremain = buflen;

    if (port->data == -1) {
	NALog(LOG_ERR,
	      "Attempt to write samples without opening data channel\n");
	errno = EBADF;
	return -1;
    }
    if ((port->playrec & NA_PLAY) == 0) {
	NALog(LOG_ERR,
	      "Attempt to write samples on data channel not open for writing\n");
	errno = EBADF;
	return -1;
    }
#ifndef NADIRECT
    /* Check if any events have come in */
    _NAPollEvents(port);
#endif

#ifdef NADIRECT
    while (nremain >= BLOCK_LENGTH) {
	int32 nxfr = dat_write(port->data,(const byte *)buffer,
			       (nremain/BLOCK_LENGTH)*BLOCK_LENGTH);
#else	
    while (nremain > 0) {
	int32 nxfr = longwrite(port->data,(char *)buffer,
			       (unsigned int32)nremain);
#endif
	Debug("NAWrite",3,"Wrote %ld/%ld to server\n",(long)nxfr,(long)nremain);
	if (nxfr <= 0) {
#ifndef NADIRECT
	    /* Maybe an error message has been sent - better poll */
	    _NAPollEvents(port);
#endif
	    if ((nxfr == 0)
#ifdef EPIPE
		&& (errno != EPIPE)
#endif
		)
#ifdef NADIRECT
		dat_perror("write");
#else
		NALog(LOG_ERR,"write failed: %s\n",NAsyserr());
#endif
#ifdef NADIRECT
	    if (nxfr < 0) {
		PlaybackError(NA_XFRERR_UNDERRUN);
		nxfr = 0;
		return buflen-nremain;
	    }
#endif
	    if (nremain == buflen)
		return nxfr;
	    else
		return buflen-nremain;
	}
	port->bytesSent += nxfr;
	buffer += nxfr;
	nremain -= nxfr;
    }
    return buflen;
}

/* Read samples - same as read(2) but using int32s */
int32 NARead(port,buffer,buflen)
NAport *port;
char *buffer;
int32 buflen;
{
    int32 nxfr;

    if (port->data == -1) {
	NALog(LOG_ERR,
	      "Attempt to read samples without opening data channel\n");
	errno = EBADF;
	return -1;
    }
    if ((port->playrec & NA_RECORD) == 0) {
	NALog(LOG_ERR,
	      "Attempt to read samples on data channel not open for reading\n");
	errno = EBADF;
	return -1;
    }
#ifdef NADIRECT
    {
	double t1,t2;
	t1 = mtime();
	nxfr = dat_read(port->data,(byte *)buffer,buflen,0);
	t2 = mtime();
	Debug("NARead",1,"Read %ld/%ld bytes in %.0f ms.\n",
	      (long)nxfr,(long)buflen,(t2-t1)*1000.0);
  }
#else
    /* Check if any events have come in */
    _NAPollEvents(port);

    nxfr = longread(port->data,buffer,(unsigned int32)buflen);
#endif
    Debug("NARead",2,"Read %ld/%ld from server\n",(long)nxfr,(long)buflen);
#ifdef NADIRECT
    if (nxfr <= 0) {
	/* Maybe an error message has been sent - better poll */
	_NAPollEvents(port);
	if (nxfr < 0) {
	    if (dat_errno == EDLOVERRUN)
		nxfr = 0;
	    else
		dat_perror("read");
	}
    }
#else /* NADIRECT */
    if (nxfr <= 0) {
	/* Maybe an error message has been sent - better poll */
	_NAPollEvents(port);
	if ((nxfr < 0)
#ifdef EPIPE
	    && (errno != EPIPE)
#endif
	    )
	    NALog(LOG_ERR,"read failed: %s\n",NAsyserr());
    }
#endif /* !NADIRECT */
    return nxfr;
}
