/* $Id: pause_server.c,v 1.4 1993/05/18 19:41:54 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sat Feb 15 13:51:37 EST 1992
 *
 * Revision History: $Log: pause_server.c,v $
 * Revision 1.4  1993/05/18  19:41:54  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.3  1992/12/17  04:46:55  bst
 * Print "Pausing.." on stderr instead of stdou.
 *
 * Revision 1.2  1992/07/15  23:47:11  bst
 * Added NAResumeServer()
 * Handle pause of multiple DAT_Link units.
 *
 * Revision 1.1  1992/03/06  01:25:29  bst
 * Initial revision
 *
 */
#include "NAlibint.h"

/* Pause the NetAudio server on the local host at unit */
/* Used by programs that talk directly to the DAT-Link so the server will
   release the DAT-Link device file */
/* When the calling program exits, the server will resume */
#define MAXUNITS 100
static NAport *ps_port[MAXUNITS] = { 0 };

int NAPauseServer(unit)
int unit;
{
    char server[4];

    if (unit < 0)
	unit = 0;
	
    if (unit >= MAXUNITS)
	NALog(LOG_ERR,"NAPauseServer: Bad unit: %d\n", unit);
    else
	sprintf(server,":%d",unit);

    _NAquiet = 1;
    ps_port[unit] = NAOpen(server);
    if (ps_port[unit] == 0) {
	Debug("NAPauseServer",1,"Unable to connect to NetAudio server (%s)\n",
	      server);
	return -1;
    }
    else {
	fprintf(stderr,"Pausing NetAudio server (%s)\n",server);
	if (NAServer(ps_port[unit],NA_PAUSESERVER) < 0) {
	    NALog(LOG_ERR,"Unable to pause NetAudio server\n");
	    return -1;
	}
	sleep(2);
    }
    return 0;
}

int NAResumeServer(unit)
int unit;
{
    if (unit < 0)
	unit = 0;
    if (unit >= MAXUNITS)
	NALog(LOG_ERR,"NAPauseServer: Bad unit: %d\n", unit);
    else if (ps_port[unit]) {
	NAServer(ps_port[unit],NA_RESUMESERVER);
	NAClose(ps_port[unit]);
    }
    return 0;
}
