/* $Id: naremote.c,v 2.10 1993/10/05 00:58:37 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:54 EST 1991
 *
 * Revision History: $Log: naremote.c,v $
 * Revision 2.10  1993/10/05  00:58:37  bst
 * Coercion change.
 *
 * Revision 2.9  1993/06/01  02:48:30  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 2.8  1993/05/18  19:41:57  bst
 * *** empty log message ***
 *
 * Revision 2.7  1993/04/22  03:20:29  bst
 * Added include of string.h
 *
 * Revision 2.6  1992/10/25  18:31:14  bst
 * Copy lists to newly malloced areas.
 * Use _NAFreeReply() to free reply.
 *
 * Revision 2.5  1992/05/01  19:51:25  bst
 * Added coercion to remove warning.
 *
 * Revision 2.4  1992/05/01  17:06:45  bst
 * Added NASerialRead(), NASerialWrite().
 *
 * Revision 2.3  1992/02/12  04:32:19  bst
 * Remove include of errno.h, it's in sysdefs.h now.
 *
 * Revision 2.2  1992/01/17  04:18:23  bst
 * Made device, operation strings const.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include <string.h>
#include "NAlibint.h"

/* Execute 'operation' on 'device' */
int NARemote(port,device,operation)
NAport *port;
const char *device, *operation;
{
    NArequest request;

    request.request = NA_REMOTEEXEC;
    request.NArequest_u.cmd.device = (char *)device;
    request.NArequest_u.cmd.operation = (char *)operation;
    if (_NASendRequest(port,&request) < 0)
	exit(1);
    return 0;
}

/* Return list of devices */
char **NAListDevices(port,ndevices)
NAport *port;
int *ndevices;
{
    NArequest request;
    NAreply *reply;
    char **result;
    int i;

    request.request = NA_LISTREMOTEDEVICES;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    reply = _NAReply(port);
    if (reply->reply != NA_REMOTEDEVICELIST) {
	NALog(LOG_ERR,"Bad reply for open data request: Expected %d, got %d\n",
	      NA_REMOTEDEVICELIST, reply->reply);
	_NAIOError(port);
	errno = EIO;
	_NAFreeReply(reply);
	return 0;
    }
    *ndevices = reply->NAreply_u.dvlist.dvlist_len;
    result = (char **)malloc(sizeof(char*)*(*ndevices+1));
    for (i=0;i<*ndevices;i++) {
	result[i] = (char *)malloc(
	    strlen(reply->NAreply_u.dvlist.dvlist_val[i].name)+1);
	strcpy(result[i],reply->NAreply_u.dvlist.dvlist_val[i].name);
    }
    result[i] = 0;
    _NAFreeReply(reply);
    return result;
}

/* Return list of operations */
char **NAListOperations(port,device,noperations)
NAport *port;
const char *device;
int *noperations;
{
    NArequest request;
    NAreply *reply;
    char **result;
    int i;

    request.request = NA_LISTREMOTEOPS;
    request.NArequest_u.device = (char *)device;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    reply = _NAReply(port);
    if (reply->reply != NA_REMOTEOPSLIST) {
	NALog(LOG_ERR,"Bad reply for open data request: Expected %d, got %d\n",
	      NA_REMOTEOPSLIST, reply->reply);
	_NAIOError(port);
	errno = EIO;
	_NAFreeReply(reply);
	return 0;
    }
    *noperations = reply->NAreply_u.oplist.oplist_len;
    result = (char **)malloc(sizeof(char*)*(*noperations+1));
    for (i=0;i<*noperations;i++) {
	result[i] = (char *)malloc(
	    strlen(reply->NAreply_u.oplist.oplist_val[i].name)+1);
	strcpy(result[i],reply->NAreply_u.oplist.oplist_val[i].name);
    }
    result[i] = 0;
    _NAFreeReply(reply);
    return result;
}

/* Free a list returned by above routines */
void NAFreeList(list)
char **list;
{
    char **p;
    for (p = list;*p;p++)
	free(*p);
    free(list);
}

int NASerialRead(port,unit,buf,nbytes)
NAport *port;
int unit;
char *buf;
int nbytes;
{
    NArequest request;
    NAreply *reply;

    request.request = NA_SERIALREAD;
    request.NArequest_u.rdinfo.port = unit;
    request.NArequest_u.rdinfo.nbytes = nbytes;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    reply = _NAReply(port);
    if (reply->reply != NA_SERIALREADREPLY) {
	NALog(LOG_ERR,
	      "Bad reply for serial read request: Expected %d, got %d\n",
	      NA_SERIALREADREPLY, reply->reply);
	_NAIOError(port);
	errno = EIO;
	_NAFreeReply(reply);
	return 0;
    }
    nbytes = reply->NAreply_u.data.data_len;
    if (nbytes)
	memcpy(buf,reply->NAreply_u.data.data_val,(size_t)nbytes);
    _NAFreeReply(reply);
    return nbytes;
}

int NASerialWrite(port,unit,buf,nbytes)
NAport *port;
int unit;
const char *buf;
int nbytes;
{
    NArequest request;

    request.request = NA_SERIALWRITE;
    request.NArequest_u.sdata.port = unit;
    request.NArequest_u.sdata.data.data_len = nbytes;
    request.NArequest_u.sdata.data.data_val = (char *)buf;
    if (_NASendRequest(port,&request) < 0)
	exit(1);
    return nbytes;
}

