/* $Id: naopen.c,v 2.41 1995/07/06 17:28:26 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:52 EST 1991
 *
 * Revision History: $Log: naopen.c,v $
 * Revision 2.41  1995/07/06  17:28:26  bst
 * Added include of netinet/in_systm.h
 *
 * Revision 2.40  1994/11/17  01:16:08  bst
 * Moved gethostbyname() declaration to sysdefs.h
 *
 * Revision 2.39  1994/08/30  18:58:49  bst
 * Removed redundant word "warning"
 *
 * Revision 2.38  1994/04/25  20:28:55  bst
 * Use sysinfo() if gethostname() is unavailable.
 *
 * Revision 2.37  1993/11/19  03:18:55  bst
 * Initialize portName when using NADIRECT.
 *
 * Revision 2.36  1993/10/05  14:51:24  bst
 * Always coerce last 2 args to xdrec_create() to void* (Each machine requires
 *  different types for these args)
 *
 * Revision 2.35  1993/08/30  14:40:40  bst
 * Added debug message to NAOpenData)(
 *
 * Revision 2.34  1993/08/27  00:46:30  bst
 * Added coercions for [sg]etsockopt() args.
 * Removed system declarations.
 *
 * Revision 2.33  1993/08/18  19:39:08  bst
 * Close socket if connect failed.
 *
 * Revision 2.32  1993/08/10  02:15:58  bst
 * Coerce %l args to long.
 * Use strcasecmp() instead of strcmp() where appropriate.
 * Don't set socket buffering under NADIRECT.
 *
 * Revision 2.31  1993/06/23  20:37:06  bst
 * Changed 'long' to 'int32'
 *
 * Revision 2.30  1993/06/23  03:36:50  bst
 * Closed some memory leaks.
 *
 * Revision 2.29  1993/06/13  20:37:17  bst
 * Added NASetSocketBuf().
 * Added getsockopt() prototype.
 * Set buffering on data socket to 32768 bytes.
 *
 * Revision 2.28  1993/06/12  20:48:38  bst
 * Fixed prototypes to correspond to SGI version.
 *
 * Revision 2.27  1993/06/09  14:12:41  bst
 * Added some coercions for SGI
 *
 * Revision 2.26  1993/06/07  14:21:58  bst
 * Initialize port->bytesSent to zero when opening a data connection.
 *
 * Revision 2.25  1993/05/18  19:41:51  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 2.24  1993/05/07  15:28:38  bst
 * Moved UNIX domain sockets to a subdirectory of /tmp
 *
 * Revision 2.23  1993/04/26  20:48:56  bst
 * Fixed arg to malloc_leave() to match malloc_enter().
 *
 * Revision 2.22  1993/04/20  20:32:05  bst
 * Store server inet address instead of entire hostent struct.
 * Static struct returned by gethostbyname() may be overwritten
 *   by other network calls causing value to be clobbered.
 *
 * Revision 2.21  1993/04/16  01:28:46  bst
 * Added Debug() message if connect() fails.
 *
 * Revision 2.20  1993/04/12  02:27:31  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.19  1993/03/24  19:40:17  bst
 * Added include of naversion.h
 *
 * Revision 2.18  1993/02/23  16:47:27  bst
 * Allow bidirectional I/O.
 *
 * Revision 2.17  1993/02/04  23:12:13  bst
 * NADIRECT support.
 *
 * Revision 2.16  1992/10/25  20:58:50  bst
 * Added DEBUG_MALLOC support.
 *
 * Revision 2.15  1992/10/25  18:31:04  bst
 * Use _NAFreeReply() to free reply.
 *
 * Revision 2.14  1992/10/04  17:20:41  bst
 * Added support for NAGetServerVersion().
 *
 * Revision 2.13  1992/07/05  03:10:16  bst
 * Moved 'Unable to connect' error message to calling routine.
 *
 * Revision 2.12  1992/05/17  22:29:10  bst
 * Added support for UNIX domain sockets.
 * Removed some old code (setsockopt() stuff)
 *
 * Revision 2.11  1992/04/09  17:55:56  bst
 * Changed strings.h to string.h
 * Use strchr() instead of index()
 *
 * Revision 2.10  1992/02/15  19:50:31  bst
 * Suppress error messages if _NAquiet is non-zero.
 * On error, return NULL from NAOpen() rather than exitting.
 *
 * Revision 2.9  1992/02/12  04:32:14  bst
 * Remove include of errno.h, it's in sysdefs.h now.
 *
 * Revision 2.8  1992/02/11  18:17:02  bst
 * Changed prototype of setsockopt() to match NeXT.
 *
 * Revision 2.7  1992/02/08  03:09:24  bst
 * Use P() macro.
 *
 * Revision 2.6  1992/01/27  06:19:19  bst
 * Modified no-connection error messages.
 * Fixed coredump if unknown host was used.
 *
 * Revision 2.5  1992/01/22  20:47:14  bst
 * Added more informative messages if unable to connect to server.
 *
 * Revision 2.4  1991/12/16  05:24:09  bst
 * Set port->data back to -1 if open failed.
 *
 * Revision 2.3  1991/12/16  00:43:17  bst
 * Removed 2nd arg to NAOpen().
 * Check that user is not attempting bidirectional I/O in NAOpenData()
 *
 * Revision 2.2  1991/12/10  22:36:31  bst
 * Removed declarations of getenv(), perror() - they're in sysdefs.h
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include "NAlibint.h"
#include <string.h>
#include <signal.h>

#include "naversion.h"
#ifdef NADIRECT
#include "server.h"
#include "dlio.h"
#include "data.h"
#else /* NADIRECT */
#include <sys/socket.h>
#include <sys/un.h>

#ifdef HAS_netinet_in_h
#include <netinet/in.h>
#endif /* HAS_netinet_in_h */

#ifdef HAS_netinet_in_systm_h
/* in_systm.h is needed on NeXT for defn of n_long */
#include <netinet/in_systm.h>
#endif /* HAS_netinet_in_systm_h */

#include <netinet/tcp.h>

#ifdef HAS_sys_systeminfo_h
#include <sys/systeminfo.h>
#endif /* HAS_sys_systeminfo_h */
#endif /* !NADIRECT */

/* _NAquiet should be set to 1 to suppress error messages */
int _NAquiet = 0;

#ifndef NADIRECT

int _NAOpenSocket(port,socknum,unixDomain,dataConn)
NAport *port;
int socknum;	/* Port number for TCP, unit number for UNIX */
int unixDomain;	/* Non-zero for UNIX domain socket at /tmp/=DATLink.%d */
int dataConn;	/* Non-zero for data connections */
{
    struct sockaddr_in server_tcp;
    struct sockaddr_un server_unix;
    struct sockaddr *server;
    int serverlen;
    int result;

    /* Don't let SIGPIPE signals kill us */
    (void)signal(SIGPIPE,SIG_IGN);
    
    if (unixDomain) {
	server_unix.sun_family = AF_UNIX;
	sprintf (server_unix.sun_path, "%s/=%s.%d",
		 DL_UNIX_SOCK_DIR, dataConn?"data":"ctl", socknum);
	Debug("NAOpen",2,"Opening UNIX connection at %s to %s\n",
	      server_unix.sun_path,port->portName);
	server = (struct sockaddr *)&server_unix;
	serverlen = sizeof(server_unix);
    } else {
	Debug("NAOpen",2,"Opening TCP connection at port %d to %s\n",
	      socknum,port->portName);
	server_tcp.sin_family = AF_INET;
	server_tcp.sin_addr.s_addr = port->host_addr;
	server_tcp.sin_port = htons(socknum);
	server = (struct sockaddr *)&server_tcp;
	serverlen = sizeof(server_tcp);
    }

    if ((result = socket((int)server->sa_family,SOCK_STREAM,0)) < 0) {
	NALog(LOG_ERR,"NAOpen: socket() failed: %s\n", NAsyserr());
	return -1;
    }

    if (connect(result,server, serverlen) < 0) {
	Debug("NAOpen",1,"Failed socket connect: %s\n",NAsyserr());
	(void)close(result); 	/* Close socket */
	return -1;
    }
    return result;
}

int32 _NASetSocketBuf(sock, len)
int sock;
int32 len;
{
    int32 slen, rlen;
    int optlen;
#ifdef SO_SNDBUF
    optlen = sizeof(len);
    if (getsockopt (sock, SOL_SOCKET, SO_SNDBUF, (char *)&slen, &optlen) < 0)
	Debug("NASetSocketBuf",1,"Unable to set SO_SNDBUF: %s\n",NAsyserr());
    if (slen < len) {
	if (setsockopt (sock, SOL_SOCKET, SO_SNDBUF, (char *)&len, sizeof(len)) < 0)
	    Debug("NASetSocketBuf",1,"Unable to set SO_SNDBUF: %s\n",NAsyserr());
	optlen = sizeof(len);
	if (getsockopt (sock, SOL_SOCKET, SO_SNDBUF, (char *)&slen, &optlen) < 0)
	    Debug("NASetSocketBuf",1,"Unable to set SO_SNDBUF: %s\n",NAsyserr());
    }
    if (slen != len)
        Debug("NASetSocketBuf",1,
	      "SO_SNDBUF set to %ld instead of %ld (optlen=%d)\n",
	      (long)slen,(long)len,optlen);
#else
    slen = len;
#endif
#ifdef SO_RCVBUF
    optlen = sizeof(rlen);
    if (getsockopt (sock, SOL_SOCKET, SO_RCVBUF, (char *)&rlen, &optlen) < 0)
	Debug("NASetSocketBuf",1,"Unable to set SO_RCVBUF: %s\n",NAsyserr());
    if (rlen < len) {
	if (setsockopt (sock, SOL_SOCKET, SO_RCVBUF, (char *)&len, sizeof(len)) < 0)
	    Debug("NASetSocketBuf",1,"Unable to set SO_RCVBUF: %s\n",NAsyserr());
	optlen = sizeof(rlen);
	if (getsockopt (sock, SOL_SOCKET, SO_RCVBUF, (char *)&rlen, &optlen) < 0)
	    Debug("NASetSocketBuf",1,"Unable to set SO_RCVBUF: %s\n",NAsyserr());
    }
    if (rlen != len)
        Debug("NASetSocketBuf",1,
	      "SO_RCVBUF set to %ld instead of %ld (optlen=%d)\n",
	      (long)rlen,(long)len,optlen);
#else
    rlen = len;
#endif
    if (slen < rlen)
	return slen;
    return rlen;
}

static int unit;
static int unixDomain = 0;
#endif /* !NADIRECT */


NAport *NAOpen(s)
const char *s;
{
    NAport *port;
#ifndef NADIRECT
    char hostname[100];
    char localhostname[100];
    int serverNetAudio;
    struct hostent *h_ent;
#endif

    /* Allocate a structure */
    if ((port = (NAport *)malloc(sizeof(NAport))) == NULL) {
	NALog(LOG_ERR,"No memory.\n");
	exit(1);
    }
#ifdef NADIRECT
    clients[0].xdrs = port;
#endif

    /* Initialize it */
    port->playrec = 0;
    port->data = -1;
#ifndef NADIRECT
    port->control = -1;
#endif
    port->eventmask = (1<<NA_CONFIGURENOTIFY);
    /* Event queue is empty */
    port->head = port->tail = 0; port->qlen = 0;

    /* Figure out device name to connect to */
    if (s == 0)
	s = getenv("AUDIO_DEVICE");
    
    if (s == 0) {
#ifdef NADIRECT
	SetupDATLink(-1,0);
#else /* NADIRECT */
	hostname[0] = 0;
	unit = 0;
#endif /* !NADIRECT */
	port->portName = malloc(3);
	strcpy(port->portName,":0");
    } else {
#ifdef NADIRECT
	SetupDATLink(atoi(s),0);
#else /* NADIRECT */
	char *colon;
	strcpy(hostname,s);
	colon = strchr(hostname,':');
	if (colon) {
	    *colon = 0;
	    unit = atoi(colon+1);
	}
	else
	    unit = 0;
#endif /* !NADIRECT */
	port->portName = malloc(strlen(s)+1);
	strcpy(port->portName,s);
    }

#ifndef NADIRECT
#ifdef DEBUG_MALLOC
    malloc_enter("gethostname");
#endif
#ifdef HAS_gethostname
    gethostname(localhostname,sizeof(localhostname));
#else /* HAS_gethostname */
#ifdef HAS_sysinfo
    sysinfo(SI_HOSTNAME,localhostname,sizeof(localhostname));
#else /* HAS_sysinfo */
    strcpy(localhostname,"unknown");
    NALog(LOG_ERR,"Unable to determine name of current host.\n");
#endif /* !HAS_sysinfo */
#endif /* !HAS_gethostname */
#ifdef DEBUG_MALLOC
    malloc_leave("gethostname");
#endif

    if ((hostname[0] == 0) || (strcasecmp(hostname,"unix") == 0))
	strcpy(hostname,localhostname);

#ifdef DEBUG_MALLOC
    malloc_enter("gethostbyname");
#endif
    h_ent = gethostbyname(hostname);
#ifdef DEBUG_MALLOC
    malloc_leave("gethostbyname");
#endif

    if (h_ent == 0) {
	NALog(LOG_ERR,"Unknown host: %s\n",hostname);
	free(port->portName);
	free(port);
	return (NAport *)0;
    }
    port->host_addr = *(unsigned int32 *)h_ent->h_addr;

	/* Try UNIX domain socket if we\'re on the local host */
    if (strcasecmp(localhostname,hostname) == 0) {
	unixDomain = 1;
	port->control = _NAOpenSocket(port,unit,unixDomain,0);
    }
    else
	port->control = -1;

	/* If that fails, try a TCP socket */
    if (port->control < 0) {
	unixDomain = 0;
	port->control = _NAOpenSocket(port,SOCKBASE+unit,unixDomain,0);
    }

    if (port->control < 0) {
	if (_NAquiet == 0) {
	    NALog(LOG_ERR,"Unable to connect to NetAudio server at %s -- %s\n",
		    port->portName, NAsyserr());
	    NALog(LOG_ERR,
		  "Perhaps netaudiod is not running, or AUDIO_DEVICE %s.\n",
		  getenv("AUDIO_DEVICE")?
		  "is set incorrectly":"needs to be set");
	}
	free(port->portName);
	free(port);
	return (NAport *)0;
    }

#ifdef TCP_NODELAY
    if (!unixDomain) {
		/* Turn off TCP coalescence */
	    int tmp = 1;
	    if (setsockopt (port->control, IPPROTO_TCP, TCP_NODELAY, (char *)&tmp,
			    sizeof (int)) < 0)
		NALog(LOG_WARNING,"Unable to set TCP_NODELAY: %s\n",
		      NAsyserr());
	}
#endif
	/* Create XDR channel */
    xdrrec_create(&port->xdrs,0,0,(char *)(long)port->control,
		  (void *)_NACtlSockRead, (void *)_NACtlSockWrite);
    /* Verify match between server/client NetAudio versions */
    serverNetAudio = NAGetServerVersion(port);
    if (serverNetAudio != (MajorRevision*1000+MinorRevision))
	NALog(LOG_WARNING,"Server is running NetAudio V%d.%02d but client is V%d.%02d\n",
		serverNetAudio/1000,serverNetAudio%1000,MajorRevision,MinorRevision);
    /* Set-up event mask */
    NASelectInput(port,port->eventmask);
#endif /* NADIRECT */

    return port;
}

/* Open a data connection */
int NAOpenData(port,playrec)
NAport *port;
int playrec;
{
    NArequest request;
    NAreply *reply;

    Debug("NAOpenData",1,"port=%s,playrec=%d\n",port->portName,playrec);
    /* Request a data socket */
    request.request = NA_OPENDATA;
    request.NArequest_u.playrec = playrec;

    if (_NASendRequest(port,&request) < 0)
	exit(1);

    /* Get the reply with the socket number to use */
    reply = _NAReply(port);

    if (reply->reply != NA_DATASOCKET) {
	NALog(LOG_ERR,"Bad reply for open data request: Expected %d, got %d\n",
		NA_DATASOCKET, reply->reply);
	_NAIOError(port);
	errno = EIO;
	_NAFreeReply(reply);
	return -1;
    }
    if (reply->NAreply_u.port == 0) {
	/* Server is busy */
	NALog(LOG_ERR,"Audio server is in use, try again later\n");
	errno = EACCES;
	_NAFreeReply(reply);
	return -1;
    }

    port->bytesSent = 0;
#ifdef NADIRECT
    port->data = dt;
    port->playrec = playrec;
    NewData(0);
#else /* NADIRECT */
    /* Open the socket */
    if (unixDomain) {
	    /* UNIX domain socket */
	if ((port->data = _NAOpenSocket(port,unit,unixDomain,1)) >= 0)
	    port->playrec = playrec;
    }
    else if ((port->data =
	      _NAOpenSocket(port,(int)reply->NAreply_u.port,unixDomain,1)) >= 0)
	port->playrec = playrec;

    _NASetSocketBuf(port->data, 32768);
#endif /* !NADIRECT */
    
    /* Free reply */
    _NAFreeReply(reply);

    return port->data;
}
