/* $Id: nadsp.c,v 1.13 1993/10/06 16:28:05 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun May 17 16:48:18 EDT 1992
 *
 * Revision History: $Log: nadsp.c,v $
 * Revision 1.13  1993/10/06  16:28:05  bst
 * Check pgm_len for zero instead of pgm_val.
 *
 * Revision 1.12  1993/10/06  13:59:34  bst
 * Added coercion to DecodeProgram()
 *
 * Revision 1.11  1993/10/05  00:58:22  bst
 * Coercion
 *
 * Revision 1.10  1993/08/10  02:13:05  bst
 * Removed redundant declaration of MAXPGMSIZE.
 *
 * Revision 1.9  1993/06/23  03:35:40  bst
 * Make sure to free reply when using GETDSPPGM.
 *
 * Revision 1.8  1993/06/01  02:47:51  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 1.7  1993/05/18  19:41:30  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.6  1993/03/01  04:02:47  bst
 * Fixed use of sys vs. local includes.
 *
 * Revision 1.5  1992/11/01  20:56:51  bst
 * Added 'suppressNoLoad' arg to EncodeProgram().
 *
 * Revision 1.4  1992/10/25  18:30:18  bst
 * Use _NAFreeReply() to free reply.
 *
 * Revision 1.3  1992/08/17  03:10:39  bst
 * Removed 'nbytes' argument from program decoding.
 *
 * Revision 1.2  1992/05/25  17:12:47  bst
 * Changed NAGetDSPProgram() declaration to pre-ANSI syntax.
 *
 * Revision 1.1  1992/05/17  20:48:22  bst
 * Initial revision
 *
 */
#include <assert.h>
#include "pgm.h"
#include "NAlibint.h"

/* Set DSP Program */
int NASetDSPProgram(port,pgm)
NAport *port;
Program *pgm;
{
    NArequest request;
    u_char *buffer = 0;
    request.request = NA_SETDSPPGM;
    if (pgm == 0) {
	request.NArequest_u.pgm.pgm_len = 0;
	request.NArequest_u.pgm.pgm_val = 0;
    } else {
	buffer = (u_char *)malloc((size_t)MAXPGMSIZE);
	request.NArequest_u.pgm.pgm_len = EncodeProgram(pgm,buffer,MAXPGMSIZE,0);
	request.NArequest_u.pgm.pgm_val = (char *)buffer;
    }
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    if (pgm)
	free(buffer);
    return 0;
}

Program *NAGetDSPProgram(port)
NAport *port;
{
    NArequest request;
    NAreply *reply;
    Program *result;

    request.request = NA_GETDSPPGM;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    /* Wait for reply */
    if ((reply = _NAReply(port)) == 0)
	exit(1);
    
    if (reply->reply != NA_GETDSPPGMREPLY) {
	NALog(LOG_ERR,"Bad reply to GetDSPProgram request: %d\n", reply->reply);
	_NAFreeReply(reply);
	return (Program *)-1;
    }
    
    if (reply->NAreply_u.pgm.pgm_len == 0) {
	_NAFreeReply(reply);
	return 0;
    }

    result = DecodeProgram((unsigned char *)reply->NAreply_u.pgm.pgm_val);
    _NAFreeReply(reply);
    return result;
}
