/* $Id: naclose.c,v 2.17 1993/08/30 14:38:34 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:37 EST 1991
 *
 * Revision History: $Log: naclose.c,v $
 * Revision 2.17  1993/08/30  14:38:34  bst
 * Handle playback error return codes from NADrain()
 * Added some debug messages.
 *
 * Revision 2.16  1993/06/23  03:34:48  bst
 * Flush events when closing port.
 *
 * Revision 2.15  1993/06/16  17:05:22  bst
 * Removed call to NAFlush() in CloseData() -> close does it anyway.
 *
 * Revision 2.14  1993/05/26  13:07:42  bst
 * Check NADrain() return code and pass it up if non-zero.
 *
 * Revision 2.13  1993/05/18  19:41:27  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 2.12  1993/04/22  03:19:38  bst
 * Removed extern declaration of close().
 *
 * Revision 2.11  1993/02/05  22:01:50  bst
 * Use PRAGMA_UNUSED instead of UNUSED macro.
 *
 * Revision 2.10  1993/02/05  20:38:02  bst
 * Added UNUSED() macro call for ununused parameters to functions.
 *
 * Revision 2.9  1993/02/04  23:08:17  bst
 * Added support for NADIRECT.
 *
 * Revision 2.8  1992/10/25  18:29:45  bst
 * Use _NAFreeReply() to free reply.
 *
 * Revision 2.7  1992/07/13  05:21:12  bst
 * Use NA_CLOSE request.
 *
 * Revision 2.6  1992/02/12  04:30:20  bst
 * Remove include of errno.h, it's in sysdefs.h now.
 *
 * Revision 2.5  1992/01/10  04:06:57  bst
 * Send NA_CLOSEDATA request when closing data channel.
 *
 * Revision 2.4  1991/12/17  02:55:18  bst
 * Call NAFlush() before closing data channel.
 *
 * Revision 2.3  1991/12/16  05:22:20  bst
 * NAOpen() now calls NACloseData() with force==1
 * Added 'force' argument to NACloseData() - call NADrain() if its not set.
 *
 * Revision 2.2  1991/12/10  22:35:00  bst
 * Don't call NADrain() in NACloseData()
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include "NAlibint.h"
#ifdef NADIRECT
#include "dlio.h"
#endif

int NAClose(port)
NAport *port;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    return CloseDATLink();
#else
    int result = 0;
    NArequest request;

    Debug("NAClose",1,"port=%s\n",port?port->portName:"");
    if (port == 0) {
	errno = EBADF;
	return -1;
    }
    if ((port->data != -1) && (NACloseData(port,1) < 0)) {
	NALog(LOG_WARNING,"Unable to close data connection\n");
	result = -1;
    }

    /* Send close request */
    request.request = NA_CLOSE;
    if (_NASendRequest(port,&request) < 0)
	NALog(LOG_ERR,"Error sending CLOSE request to server\n");
    else {
	/* Wait for reply */
	NAreply *reply = _NAReply(port);
	if (reply->reply != NA_CLOSEREPLY)
	    NALog(LOG_ERR,"Bad reply to CLOSE request - ignored\n");
	_NAFreeReply(reply);
    }

    /* Destroy XDR stream */
    xdr_destroy(&port->xdrs);

    /* Close control socket */
    if (close(port->control) < 0)
	result = -1;
    
    /* Free memory associated with port */
    _NAFlushEvents(port);
    free(port->portName);
    free((char *)port);
    return result;
#endif /* NADIRECT */
}

/* Close a port's data connection */
int NACloseData(port,force)
NAport *port;
int force;
{
    NArequest request;
    int dresult = 0;

    Debug("NACloseData",1,"port=%s,force=%d\n",port->portName,force);
    if (port->data == -1) {
	errno = EBADF;
	return -1;
    }

    if ((force == 0) && (port->playrec & NA_PLAY)) {
	int dresult = NADrain(port);
	if (dresult) {
	    Debug("NACloseData",1,"NADrain failed with code %d\n", dresult);
	    if (dresult < 0)
		return -1;
	}
    }

#if 0
    /* Flush anything left */
    if (NAFlush(port,port->playrec) < 0)
	return -1;
#endif

    request.request = NA_CLOSEDATA;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

#ifndef NADIRECT
    if (close(port->data) < 0)
	return -1;
#endif

    port->data = -1;
    port->playrec = 0;
    return dresult;
}
