/* $Id: info.c,v 2.18 1993/10/30 20:26:12 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:44 EST 1991
 *
 * Revision History: $Log: info.c,v $
 * Revision 2.18  1993/10/30  20:26:12  bst
 * Don't force a status read in NADIRECT mode from NAGetInfo().
 *
 * Revision 2.17  1993/09/11  14:13:21  bst
 * Use -1 force instead of 1 force in NAGetSnapShot().
 *
 * Revision 2.16  1993/08/10  02:13:32  bst
 * Coerce %l args to long.
 *
 * Revision 2.15  1993/05/18  19:41:41  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 2.14  1993/04/12  02:27:18  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.13  1993/03/01  04:03:31  bst
 * Fixed us of sys vs. local includes.
 *
 * Revision 2.12  1993/02/05  22:01:53  bst
 * Use PRAGMA_UNUSED instead of UNUSED macro.
 *
 * Revision 2.11  1993/02/05  20:38:05  bst
 * Added UNUSED() macro call for ununused parameters to functions.
 *
 * Revision 2.10  1993/02/04  23:09:46  bst
 * NADIRECT support.
 *
 * Revision 2.9  1992/11/22  04:57:17  bst
 * Renamed SIOMODE_AES*
 *
 * Revision 2.8  1992/10/25  18:30:37  bst
 * Use _NAFreeReply() to free reply.
 *
 * Revision 2.7  1992/08/26  18:54:23  bst
 * Set sio mode to SIOMODE_AES_MSTR instead of SIOMODE_AES.
 *
 * Revision 2.6  1992/08/11  20:58:40  bst
 * Re-ordered include of siomode.h.
 *
 * Revision 2.5  1992/07/13  05:21:53  bst
 * Added default setting for dspSIOMode.
 *
 * Revision 2.4  1992/07/05  03:08:39  bst
 * Added check for protocol revision.
 * NAGetSnapshot() now gets separated record and playback snapshots.
 *
 * Revision 2.3  1992/04/07  22:53:37  bst
 * Set default values of channel status in GetDefaultInfo()
 *
 * Revision 2.2  1991/12/17  02:55:34  bst
 * Added default settings for gain,VUdecayRate, externalRate.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include <assert.h>
#include "NAlibint.h"
#include "siomode.h"

#ifdef NADIRECT
#include "server.h"
#include "dlio.h"
#endif

/* Set an info structure to the 'standard' defaults */
int NAGetDefaultInfo(info)
NAinfo *info;
{
    bzero((char *)info,sizeof(*info));

    /* Set non-zero fields */
    info->playback.sampleRate = 0;
    info->playback.externalRate = 48000;
    info->playback.precision = 16;
    info->playback.channels = NA_CHANNELS_STEREO;
    info->playback.gain = 1.0;
    info->playback.VUdecayRate = 40;
    info->playback.leftCS[0] = info->playback.rightCS[0] = 4;
    info->playback.leftCS[3] = info->playback.rightCS[3] = 2;

    info->record.sampleRate = 0;
    info->record.externalRate = 48000;
    info->record.precision = 16;
    info->record.channels = NA_CHANNELS_STEREO;
    info->record.gain = 1.0;
    info->record.VUdecayRate = 40;

    info->clock = NA_CLOCK_INTERNAL;
    info->skipSilence = False; /* GetBoolDefault("skipSilence",False); */
    				 /* True to skip silence at beginning */

    info->source = DL_ISRC_ALL;
    info->dspSIOMode = SIOMODE_AES;
    return 0;
}

/* Retrieve the current info from the audio dev */
int NAGetInfo(port,info)
NAport *port;
NAinfo *info;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    GetDATLinkStatus(-1);
    memcpy(info,&Info,sizeof(*info));
#else /* NADIRECT */
    NArequest request; 
    NAreply *reply;

    request.request = NA_GETINFO;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    /* Wait for reply */
    if ((reply = _NAReply(port)) == 0)
	exit(1);

    memcpy(info,&reply->NAreply_u.info,sizeof(*info));
    if (info->protoMajorVersion != _NAprotoMajorRev) {
	NALog(LOG_ERR,"NetAudio Error: Server is running imcompatible protocol revision: %ld.%ld instead of %d.%d.\n",
	      (long)info->protoMajorVersion,(long)info->protoMinorVersion,
	      _NAprotoMajorRev,_NAprotoMinorRev);
    }
    _NAFreeReply(reply);
#endif /* NADIRECT */
    return 1;
}

/* Retrieve the current snapshot from the audio dev */
int NAGetSnapshot(port,snapshot)
NAport *port;
NAsnapshots *snapshot;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    GetDATLinkStatus(-1);
    memcpy(snapshot,&SnapShots,sizeof(*snapshot));
#else /* NADIRECT */
    NArequest request; 
    NAevent event;

    request.request = NA_GETSNAP;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    /* Wait for event */
    _NAMaskEvent(port,(1<<NA_SNAPSHOT),&event);
    assert(event.event == NA_SNAPSHOT);
    memcpy(snapshot,&event.NAevent_u.snap,sizeof(*snapshot));
#endif /* NADIRECT */
    Debug("NAgetsnapshot",3,"Snapshot: pb sample=%ld, rec sample = %ld\n",
	  (long)snapshot->rec.sampleNumber,(long)snapshot->pb.sampleNumber);
    return 1;
}

/* Set the info - may flush pending data */
int NASetInfo(port,info)
NAport *port;
const NAinfo *info;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    return UpdateDATLinkMode((NAinfo *)info);
#else
    NArequest request;

    request.request = NA_SETINFO;
    request.NArequest_u.info = (NAinfo *)info;  /* Storage location for info */
    if (_NASendRequest(port,&request) < 0)
	exit(1);
    return 1;
#endif
}
