/* $Id: event.c,v 2.11 1993/11/16 01:50:04 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:41 EST 1991
 *
 * Revision History: $Log: event.c,v $
 * Revision 2.11  1993/11/16  01:50:04  bst
 * Added PRAGMA_UNUSED
 *
 * Revision 2.10  1993/06/23  20:37:06  bst
 * Changed 'long' to 'int32'
 *
 * Revision 2.9  1993/06/23  03:36:00  bst
 * Added _NAFlushEvents().
 *
 * Revision 2.8  1993/05/15  19:23:23  bst
 * Renamed _qfree to __NAqfree.
 *
 * Revision 2.7  1993/04/12  02:27:14  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.6  1993/03/01  04:03:19  bst
 * Fixed use of sys vs. local includes.
 *
 * Revision 2.5  1993/02/04  23:09:29  bst
 * Disable SetPollTime() if using NADIRECT>
 *
 * Revision 2.4  1992/10/25  18:30:24  bst
 * Use _NAFreeEvent to free events.
 *
 * Revision 2.3  1992/04/04  23:29:15  bst
 * Plugged memory lead of events.
 * Use same _NAqfree that is declared in NAlibint.c
 *
 * Revision 2.2  1992/01/30  06:10:26  bst
 * Coerce enums to int when needed.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include <assert.h>
#include "NAlibint.h"

extern NAeventQ *_NAqfree;

/* Select the event types to be received */
int NASelectInput(port,eventmask)
NAport *port;
int eventmask;
{
    NArequest request;
    request.request = NA_SELECTINPUT;
    request.NArequest_u.mask = port->eventmask = eventmask;
    return _NASendRequest(port,&request);
}

/* Retrieve the next event from the server */
int NANextEvent(port,event)
NAport *port;
NAevent *event;
{
    NAeventQ *hd;

    while (port->qlen == 0)
	_NAReadEvents(port);
    memcpy(event,port->head->event,sizeof(NAevent));
    hd = port->head;
    port->head = port->head->next;
    if (port->head == 0)
	port->tail = 0;
    port->qlen--;
    /* Put queue placeholder on internal free list */
    hd->next = _NAqfree;
    _NAqfree = hd;
    /* Free event */
    _NAFreeEvent(_NAqfree->event);
    _NAqfree->event = 0;
    return 0;
}

/* Discard all events on queue */
int _NAFlushEvents(port)
NAport *port;
{
    NAevent ev;
    while (port->qlen)
	NANextEvent(port,&ev);
    return 0;
}

/* Return the next event matching the mask */
int NAMaskEvent(port,eventmask,event)
NAport *port;
int eventmask;
NAevent *event;
{
    if ((port->eventmask & eventmask) != eventmask)
	NASelectInput(port, port->eventmask | eventmask);
    return _NAMaskEvent(port,eventmask,event);
}

/* Return the next event matching the mask */
int _NAMaskEvent(port,eventmask,event)
NAport *port;
int eventmask;
NAevent *event;
{
    int i;

    Debug("event",1,"Waiting for events (0x%x): ",eventmask);
    for (i=0;(1<<i)<=eventmask;i++)
	if (eventmask & (1<<i))
	    Debug("event",-1,"%s ",_NAeventNames[i]);
    Debug("event",-1,"\n");

    while (!NACheckMaskEvent(port,eventmask,event))
	/* Read some more events */
	_NAReadEvents(port);
    return 0;
}

/* Check if an event is in the event queue - return 1 if so, 0 otherwise */
int NACheckMaskEvent(port,eventmask,event)
NAport *port;
int eventmask;
NAevent *event;
{
    NAeventQ *prev = 0;
    NAeventQ *ev;

    _NAPollEvents(port);

    for (ev=port->head;ev;prev=ev,ev=ev->next)
	if (eventmask & (1<<(int)ev->event->event)) {
	    /* Found the event */
	    memcpy(event,ev->event,sizeof(NAevent));
	    if (prev)
		prev->next = ev->next;
	    else
		port->head = ev->next;

	    if (ev == port->tail)
		port->tail = prev;

	    port->qlen--;
	    ev->next = _NAqfree;
	    _NAFreeEvent(ev->event);
	    ev->event = 0;
	    _NAqfree = ev;
	    return 1;
	}
    return 0;
}

/* Returns the number of events on the queue */
int NAPending(port)
NAport *port;
{
    return port->qlen;
}

/* Set the time between SNAPSHOT events (if enabled) */
int NASetPollInterval(port,usec)
NAport *port;
int32 usec;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port,usec)
#endif /* PRAGMA_UNUSED */
#else /* NADIRECT */
    NArequest request;

    request.request = NA_SETPOLLTIME;
    request.NArequest_u.pollTime = usec;
    if (_NASendRequest(port,&request) < 0)
	exit(1);
#endif /* !NADIRECT */
    return 1;
}
