/* $Id: error.c,v 2.14 1993/06/09 14:12:33 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:39 EST 1991
 *
 * Revision History: $Log: error.c,v $
 * Revision 2.14  1993/06/09  14:12:33  bst
 * Removed extraneous return.
 *
 * Revision 2.13  1993/06/07  14:19:49  bst
 * Added NA_ERR_NODATA error message.
 *
 * Revision 2.12  1993/05/19  02:42:07  bst
 * Fixed typo.
 *
 * Revision 2.11  1993/05/18  19:41:38  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 2.10  1993/04/22  03:19:49  bst
 * Added static function declarations.
 * Completed definition of NAerrorFunction.
 *
 * Revision 2.9  1993/02/04  23:08:30  bst
 * Don't use sys_errlist[] - it's not on Mac.
 * Only use EPIPE if it's defined.
 *
 * Revision 2.8  1992/11/04  04:35:16  bst
 * Added error for NA_ERR_BADPGM.
 *
 * Revision 2.7  1992/10/31  23:04:58  bst
 * Added more descriptive error messages.
 *
 * Revision 2.6  1992/07/13  05:21:24  bst
 * Call NAClose() in default error handler.
 * Pass control to user error function after IO error.
 *
 * Revision 2.5  1992/02/12  04:31:24  bst
 * Remove include of errno.h, it's in sysdefs.h now.
 *
 * Revision 2.4  1992/01/30  06:10:15  bst
 * Coerce enums to int when needed.
 *
 * Revision 2.3  1992/01/18  04:06:51  bst
 * Handle error messages with no request given.
 *
 * Revision 2.2  1991/12/10  22:35:22  bst
 * Don't abort on error, just exit.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#include "NAlibint.h"

int (*NAerrorFunction) P((NAport *port, NAerror *error)) = 0;

static int _NADefaultError P((NAport *port, NAerror *error));

static int _NADefaultError(port,error)
NAport *port;
NAerror *error;
{
    switch (error->ecode) {
      case NA_ERR_ACCESS:
	fprintf(stderr,"DAT-Link Access Error");
	if (error->request)
	    fprintf(stderr," for NetAudio request: %s",
		    _NArequestNames[(int)error->request->request]);
	fprintf(stderr,".\n");
	fprintf(stderr,"This error is due to attempting to change some critical\n");
	fprintf(stderr," parameters of the DAT-Link while playback or recording\n");
	fprintf(stderr," is in progress.\n");
	break;
      case NA_ERR_BADSCONV:
	fprintf(stderr,"DAT-Link Sampling-rate Converter Error.\n");
	fprintf(stderr," The requested sampling rate conversion can not be implemented\n");
	fprintf(stderr," on the DAT-Link.  This may be due to input or output sampling\n");
	fprintf(stderr," rates that are too high or too great a stopband attenuation.\n");
	break;
      case NA_ERR_BADPGM:
	fprintf(stderr,"DAT-Link DSP Program Error.\n");
	fprintf(stderr," This error was probably been caused by attempting playback or\n");
	fprintf(stderr," recording while a user DSP program is loaded that does not support\n");
	fprintf(stderr," the requested parameters.  Use 'naloaddsp' to unload the user DSP program.\n");
	break;
      case NA_ERR_NODATA:
	fprintf(stderr,"DAT-Link error: Attempt to drain playback before sending any data.\n");
	break;
      default:
	if (error->request)
	    fprintf(stderr,"netaudio: Error code %d (%s) for '%s' request\n",
		    error->ecode, _NAerrorNames[(int)error->ecode],
		    _NArequestNames[(int)error->request->request]);
	else
	    fprintf(stderr,"netaudio: Error code %d (%s) for unknown request\n",
		    error->ecode, _NAerrorNames[(int)error->ecode]);
    }
    (void)NAClose(port);
    exit(-1);
}

int _NAError(port,error)
NAport *port;
NAerror *error;
{
    if (NAerrorFunction != NULL)
	return (*NAerrorFunction)(port,error);
    else
	return _NADefaultError(port,error);
}

void _NAIOError(port)
NAport *port;
{
    NALog(LOG_ERR,
	  "netaudio:  fatal IO error %d on netaudio server \"%s\": %s\n",
	  errno,  port->portName, NAsyserr());
#ifdef EPIPE
    if (errno == EPIPE)
	NALog(LOG_ERR,"      The connection was probably broken by a server shutdown.\r\n");
#endif
    if (NAerrorFunction != NULL)
	(void)(*NAerrorFunction)(0,0);
    exit(1);
}
