/* $Id: dspio.c,v 1.7 1993/10/05 00:58:32 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Dec 16 23:44:46 EST 1992
 *
 * Revision History: $Log: dspio.c,v $
 * Revision 1.7  1993/10/05  00:58:32  bst
 * Coercion change.
 *
 * Revision 1.6  1993/06/23  20:37:06  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.5  1993/06/01  02:47:57  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 1.4  1993/05/27  15:01:13  bst
 * Added coercions.
 *
 * Revision 1.3  1993/05/18  19:41:34  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.2  1993/04/12  02:27:03  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.1  1992/12/17  04:44:50  bst
 * Initial revision
 *
 */
#include "NAlibint.h"

int NADSPRead(port,addr,nbytes,buf)
NAport *port;
unsigned int32 addr;
int nbytes;
byte *buf;
{
    NArequest request;
    NAreply *reply;

    request.request = NA_DSPREAD;
    request.NArequest_u.dspdata.addr = addr;
    request.NArequest_u.dspdata.nbytes = (u_int)nbytes;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    /* Wait for reply */
    if ((reply = _NAReply(port)) == 0)
	exit(1);
    
    if (reply->reply != NA_DSPREADREPLY) {
	NALog(LOG_ERR,"Bad reply to DSPRead request: %d\n", reply->reply);
	return -1;
    }
    
    nbytes=reply->NAreply_u.dspdata.dspdata_len;
    memcpy(buf,reply->NAreply_u.dspdata.dspdata_val,(size_t)nbytes);
    _NAFreeReply(reply);
    return nbytes;
}

int NADSPWrite(port,addr,nbytes,buf)
NAport *port;
unsigned int32 addr;
int nbytes;
const byte *buf;
{
    NArequest request;

    request.request = NA_DSPWRITE;
    request.NArequest_u.wdspdata.addr = addr;
    request.NArequest_u.wdspdata.data.data_len = (u_int)nbytes;
    request.NArequest_u.wdspdata.data.data_val = (char *)buf;
    if (_NASendRequest(port,&request) < 0)
	exit(1);

    return nbytes;
}
