/* $Id: NAlibint.h,v 2.27 1996/10/15 23:12:36 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:31:01 EST 1991
 *
 * Revision History: $Log: NAlibint.h,v $
 * Revision 2.27  1996/10/15  23:12:36  bst
 * Undefine int32 before including rpc/types.h -- on alpha there is a typedef for int32.
 *
 * Revision 2.26  1996/10/11  19:37:00  bst
 * Added include of sys/select.h
 *
 * Revision 2.25  1995/06/01  20:24:10  bst
 * Handle declaration of malloc() in rpc/types.h
 *
 * Revision 2.24  1994/11/17  01:15:53  bst
 * Use NEEDS_NETDB instead of including netdb.h directly.
 *
 * Revision 2.23  1994/05/12  03:02:22  bst
 * Rearranged includes so sys includes are before sysdefs.h
 *
 * Revision 2.22  1993/10/04  02:04:49  bst
 * Made char * arrays const.
 *
 * Revision 2.21  1993/10/04  01:58:28  bst
 * Move some extern char *[] declarations to netaudio.h
 *
 * Revision 2.20  1993/06/23  20:37:06  bst
 * Changed 'long' to 'int32'
 *
 * Revision 2.19  1993/06/23  03:36:38  bst
 * Added _NAFlushEvents.
 *
 * Revision 2.18  1993/06/13  20:37:06  bst
 * Added _NASetSocketBuf()
 *
 * Revision 2.17  1993/06/07  14:21:27  bst
 * Added bytesSent.
 *
 * Revision 2.16  1993/05/26  13:29:41  bst
 * Added _NAstatNames[].
 *
 * Revision 2.15  1993/05/07  15:27:52  bst
 * Moved UNIX domain sockets to a subdirectory of /tmp
 *
 * Revision 2.14  1993/04/20  20:30:34  bst
 * Store server inet address instead of entire hostent struct.
 *
 * Revision 2.13  1993/03/01  04:04:22  bst
 * Fixed use of sys vs. local includes.
 *
 * Revision 2.12  1993/02/04  23:11:42  bst
 * NADIRECT support.
 *
 * Revision 2.11  1992/10/25  18:30:57  bst
 * Added _NAFreeReply(), _NAFreeEvent().
 *
 * Revision 2.10  1992/10/16  01:05:37  bst
 * Use socket 5060 (IPPORT_USERRESERVED+60) instead of 50000
 *
 * Revision 2.9  1992/05/27  14:45:20  bst
 * Don't need AIX include of sys/select.h if _BSD is defined.
 *
 * Revision 2.8  1992/05/25  13:06:29  bst
 * Added include of sys/select.h under AIX
 *
 * Revision 2.7  1992/05/17  22:28:54  bst
 * Added support for UNIX domain sockets.
 *
 * Revision 2.6  1992/05/10  19:03:39  bst
 * Added _NAencodingNames
 *
 * Revision 2.5  1992/04/07  22:53:56  bst
 * Use debug.h for prototype of Debug()
 *
 * Revision 2.4  1992/02/12  04:31:48  bst
 * Removed sys/types.h, it's in sysdefs.h now.
 *
 * Revision 2.3  1992/01/17  04:17:58  bst
 * Added include of rpc/types.h (DEC xdr.h doesn't include it)
 *
 * Revision 2.2  1992/01/11  23:21:32  bst
 * Use P() for function prototypes.
 * Don't include stdlib.h.
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#ifndef NA_PRIVATE_H
#define NA_PRIVATE_H

#define NEEDS_NETDB

#include <stdio.h>
#include "sysdefs.h"
#ifndef NADIRECT

#ifdef malloc
/* On Alpha machines, there is a prototype for malloc() in rpc/types.h! */
#undef malloc
#define reset_malloc
#endif /* malloc */

#ifdef int32
#undef int32
#define reset_int32
#endif

#include <rpc/types.h>

#ifdef reset_int32
#define int32 int
#undef reset_int32
#endif

#ifdef reset_malloc
/* Restore malloc to its previous setting (from sysdefs.h) */
#define malloc(x) chk_malloc(x,__FILE__,__LINE__)
#undef reset_malloc
#endif /* reset_malloc */

#include <rpc/xdr.h>
#include <netinet/in.h>

#ifdef HAS_SYS_SELECT_H
#include <sys/select.h>
#endif
#endif /* !NADIRECT */
#include "debug.h"
#ifdef NADIRECT
#include "netaudio.h"
#else /* NADIRECT */


/* Socket for connections */
#ifdef IPPORT_USERRESERVED
/* Make sure it is a socket reserved for non-privileged servers */
#define SOCKBASE ((IPPORT_USERRESERVED)+60)
#else /* IPPORT_USERRESERVED */
/* IPPORT_USERRESERVED is typically 5000, so use 5060 */
#define SOCKBASE 5060
#endif /* IPPORT_USERRESERVED */

#define DL_UNIX_SOCK_DIR "/tmp/.DATLink"
#endif /* !NADIRECT */

/* Define the struct first to override the opaque definition in netaudio.h */
struct NAportstruct {
    char *portName;	/* "host:unit" string used on this connected */
#ifndef NADIRECT
    int control;	/* File descriptor for control channel */
    XDR xdrs;		/* XDR channel for messages */
#endif
    int playrec;	/* NA_PLAY,NA_RECORD, or NA_CONTROL_ONLY */
    int data;		/* FD for data */
    int eventmask;	/* Event mask */
#ifndef NADIRECT
    unsigned int32 host_addr;
#endif
    struct NAeventQ_struct *head;	/* Head of event queue */
    struct NAeventQ_struct *tail;	/* Tail of event queue */
    int qlen;				/* Number of items on event queue */
    unsigned int32 bytesSent;		/* Data bytes sent to server */
};

#include "NAproto.h"

typedef struct NAeventQ_struct NAeventQ;

struct NAeventQ_struct {
    NAeventQ *next;
    NAevent *event;
};

extern const char *_NAerrorNames[];
extern const char *_NArequestNames[];
extern const char *_NAreplyNames[];

extern int _NAEnq P((NAport *port,NAevent *event));
extern NAreply *_NAReply P((NAport *port));
extern int _NAPollEvents P((NAport *port));
extern int _NAReadEvents P((NAport *port));
extern int _NASendRequest P((NAport *port, NArequest *request));
extern void _NAIOError P((NAport *port));
extern int _NAOpenSocket P((NAport *port,int socknum,int unixDomain, int dataConn));
extern int32 _NASetSocketBuf P((int sock, int32 buflen));
extern void _NAHexDump P((char *buf,int len));
extern int _NACtlSockRead P((int fd,char *buf,int len));
extern int _NACtlSockWrite P((int fd,char *buf,int len));
extern int _NAError P((NAport *port,NAerror *error));
/* Like NAMaskEvent(), but don't verify mask */
extern int _NAMaskEvent P((NAport *port, int eventmask, NAevent *event));
extern void _NAFreeReply P((NAreply *reply));
extern void _NAFreeEvent P((NAevent *event));
extern int _NAFlushEvents P((NAport *port));
#endif

