/* $Id: NAlibint.c,v 2.17 1994/03/07 18:35:00 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:30:33 EST 1991
 *
 * Revision History: $Log: NAlibint.c,v $
 * Revision 2.17  1994/03/07  18:35:00  bst
 * Changed '#if' to '#ifdef'
 *
 * Revision 2.16  1993/08/27  00:47:01  bst
 * Coerce xdr_free() arg 2 to char *
 * Removed select() declaration.
 * Use NEEDS_TIME
 *
 * Revision 2.15  1993/05/18  19:41:47  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 2.14  1993/05/15  19:24:28  bst
 * Renamed _qfree to __NAqfree.
 *
 * Revision 2.13  1993/04/22  03:20:18  bst
 * Use P() macro.
 *
 * Revision 2.12  1993/03/01  04:04:05  bst
 * Exit immediately on out of memory error.
 *
 * Revision 2.11  1993/02/05  22:01:57  bst
 * Use PRAGMA_UNUSED instead of UNUSED macro.
 *
 * Revision 2.10  1993/02/05  20:38:09  bst
 * Added UNUSED() macro call for ununused parameters to functions.
 *
 * Revision 2.9  1993/02/04  23:11:15  bst
 * NADIRECT support.
 *
 * Revision 2.8  1992/11/06  01:45:43  bst
 * Cleanup warnings from GNU C 2.3.1
 *
 * Revision 2.7  1992/10/25  20:58:41  bst
 * Removed old debug message.
 *
 * Revision 2.6  1992/10/25  18:30:45  bst
 * Added _NAFreeReply(), _NAFreeEvent().
 *
 * Revision 2.5  1992/04/04  23:29:47  bst
 * Made _qfree global so that event.c can access it.
 *
 * Revision 2.4  1992/02/12  04:31:40  bst
 * Remove include of errno.h, it's in sysdefs.h now.
 *
 * Revision 2.3  1992/01/30  06:10:34  bst
 * Coerce enums to int when needed.
 *
 * Revision 2.2  1992/01/17  04:17:47  bst
 * Added include of sys/time.h
 *
 * Revision 2.1  1991/12/08  21:31:39  bst
 * Network version
 *
 * Revision 1.1  1991/12/08  20:32:14  bst
 * Initial revision
 *
 */
#define NEEDS_TIME
#include "NAlibint.h"

#ifdef NADIRECT
#include "server.h"
#include "control.h"
#include "message.h"
#include "dlio.h"
NAreply staticReply;
#endif /* NADIRECT */

NAeventQ *_NAqfree = 0;

#ifndef NADIRECT

/* Return true if bytes are available for reading on fd */
int BytesReadable(port,fd)
NAport *port;
int fd;
{
    fd_set readfds;
    int nr;
    struct timeval to;

    FD_ZERO(&readfds);
    FD_SET(fd,&readfds);
    to.tv_sec = 0;
    to.tv_usec = 0;
    /* Poll to see if the fd is ready to read */
    nr = select(fd+1,&readfds,0,0,&to);
    if (nr < 0) {
	NALog(LOG_ERR,"select failed: %s\n",NAsyserr());
	_NAIOError(port);
    }
    return nr;
}
#endif /* !NADIRECT */

/* Queue up an event (the event pointer should NOT be freed or used after calling this) */
int _NAEnq(port,event)
NAport *port;
NAevent *event;
{
    NAeventQ *qelt;
    NAeventQ *ev;

    Debug("proto",1,"Received %s event\n",_NAeventNames[(int)event->event]);

    /* Squash events */
    for (ev=port->head;ev;ev=ev->next)
	if (ev->event->event == event->event) {
	    Debug("proto",1,"Squashing event\n");
	    _NAFreeEvent(ev->event);
	    ev->event = event;
	    return 0;
	}

    if ((qelt = _NAqfree) != 0)
	_NAqfree = qelt->next;
    else if ((qelt = (NAeventQ *)malloc(sizeof(NAeventQ))) == NULL) {
	NALog(LOG_ERR,"Out of memory\n");
	exit(1);
    }
    qelt->next = NULL;
    qelt->event = event;

    if (port->head)
	port->tail->next = qelt;
    else
	port->head = qelt;
    port->tail = qelt;
    port->qlen++;
    return 0;
}

/* _NAPollEvents - read in as many events as possible, return number read
 */
int _NAPollEvents(port)
NAport *port;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    return 0;
#else /* NADIRECT */
    NAmessage msg;
    int nevents = 0;

    while ((xdrrec_eof(&port->xdrs) == FALSE) ||
	   BytesReadable(port,port->control)) {
	port->xdrs.x_op = XDR_DECODE;
	bzero((char *)&msg,sizeof(msg));
	xdrrec_skiprecord(&port->xdrs);
	if (!xdr_NAmessage(&port->xdrs,&msg)) {
	    NALog(LOG_ERR,"Unable to retrieve message\n");
	    _NAIOError(port);
	    return -1;
	}
	switch (msg.msgtype) {
	  case NA_ERROR:
	    _NAError(port,msg.NAmessage_u.error);
	    xdr_free(xdr_NAmessage,(char *)&msg);
	    break;
	  case NA_EVENT:
	    _NAEnq(port,msg.NAmessage_u.event);
	    nevents++;
	    break;
	  default:
	    NALog(LOG_ERR,"Bad message type: 0x%x\n",msg.msgtype);
	    xdr_free(xdr_NAmessage,(char *)&msg);
	    _NAIOError(port);
	}
    }
    return nevents;
#endif /* NADIRECT */
}

/* _NAReadEvents - read as many events as possible (but at least 1) and enqueue them
 */
int _NAReadEvents(port)
NAport *port;
{
#ifdef NADIRECT
    GetDATLinkStatus(1);
    if (infoChanged) {
	(void)SendConfigureNotify(-1);
	infoChanged = 0;
    }
    else {
	NAevent event;
	event.event = NA_SNAPSHOT;
	memcpy(&event.NAevent_u.snap,&SnapShots,sizeof(SnapShots));
	if (_NASendEvent(port,&event) < 0) {
	    Debug("control",1,"Error sending SNAPSHOT event to client\n");
	    return -1;
	}
    }
#else /* NADIRECT */
    NAmessage msg;
    int gotsome = 0;

    do {
	port->xdrs.x_op = XDR_DECODE;
	bzero((char *)&msg,sizeof(msg));
	xdrrec_skiprecord(&port->xdrs);
	if (!xdr_NAmessage(&port->xdrs,&msg)) {
	    NALog(LOG_ERR,"Unable to retrieve message\n");
	    _NAIOError(port);
	    return -1;
	}
	switch (msg.msgtype) {
	  case NA_ERROR:
	    _NAError(port,msg.NAmessage_u.error);
	    xdr_free(xdr_NAmessage,(char *)&msg);
	    break;
	  case NA_EVENT:
	    _NAEnq(port,msg.NAmessage_u.event);
	    gotsome = 1;
	    break;
	  default:
	    NALog(LOG_ERR,"Bad message type: 0x%x\n",msg.msgtype);
	    xdr_free(xdr_NAmessage,(char *)&msg);
	    _NAIOError(port);
	    return -1;
	}
    } while (!xdrrec_eof(&port->xdrs) || !gotsome);
#endif /* NADIRECT */
    return 0;
}

/* Wait for a reply */
NAreply *_NAReply(port)
NAport *port;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    return &staticReply;
#else /* NADIRECT */
    NAmessage msg;
    
    while (1) {
	port->xdrs.x_op = XDR_DECODE;
	/* Zero out message so XDR routine will alloc memory as needed */
	bzero((char *)&msg,sizeof(msg));
	xdrrec_skiprecord(&port->xdrs);
	if (!xdr_NAmessage(&port->xdrs,&msg)) {
	    NALog(LOG_ERR,"Unable to retrieve message\n");
	    _NAIOError(port);
	    return NULL;
	}
	xdrrec_eof(&port->xdrs);
	Debug("proto",4,"Received message type %d\n",msg.msgtype);
	switch (msg.msgtype) {
	  case NA_ERROR:
	    _NAError(port,msg.NAmessage_u.error);
	    break;
	  case NA_REPLY:
	    Debug("proto",1,"Received reply: %s\n",
		  _NAreplyNames[(int)msg.NAmessage_u.reply->reply]);
	    return msg.NAmessage_u.reply;
	  case NA_EVENT:
	    _NAEnq(port,msg.NAmessage_u.event);
	    /* Make sure event doesn't get freed or used */
	    msg.NAmessage_u.event = 0;
	    break;
	  default:
	    NALog(LOG_ERR,"Bad message type: 0x%x\n",msg.msgtype);
	    _NAIOError(port);
	    return NULL;
	}
	/* Free up memory */
	xdr_free(xdr_NAmessage,(char *)&msg);
    }
#endif /* NADIRECT */
}

#ifndef NADIRECT
int _NASendMessage(port,msg)
NAport *port;
const NAmessage *msg;
{
    Debug("proto",4,"Sending message type %d\n",msg->msgtype);
    port->xdrs.x_op = XDR_ENCODE;
    if (!xdr_NAmessage(&port->xdrs,msg)) {
	NALog(LOG_ERR,"Unable to send message\n");
	_NAIOError(port);
	return -1;
    }
    /* Flush data */
    xdrrec_endofrecord(&port->xdrs,TRUE);
    return 0;
}
#endif /* !NADIRECT */

int _NASendRequest(port,request)
NAport *port;
NArequest *request;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(port)
#endif /* PRAGMA_UNUSED */
    return ExecRequest(0,request);
#else /* NADIRECT */
    NAmessage msg;
    msg.msgtype = NA_REQUEST;
    msg.NAmessage_u.request = request;
    Debug("proto",1,"Sending request: %s\n",_NArequestNames[(int)request->request]);
    return _NASendMessage(port,&msg);
#endif /* NADIRECT */
}

void _NAFreeReply(reply)
NAreply *reply;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(reply)
#endif /* PRAGMA_UNUSED */
#else /* NADIRECT */
    NAmessage msg;
    /* Fake a message wrapper */
    msg.msgtype = NA_REPLY;
    msg.NAmessage_u.reply = reply;
    /* and use xdr_free to free wrapped reply */
    xdr_free(xdr_NAmessage,(char *)&msg);
#endif /* !NADIRECT */
}

void _NAFreeEvent(event)
NAevent *event;
{
#ifdef NADIRECT
#ifdef PRAGMA_UNUSED
#pragma unused(event)
#endif /* PRAGMA_UNUSED */
#else /* NADIRECT */
    NAmessage msg;
    /* Fake a message wrapper */
    msg.msgtype = NA_EVENT;
    msg.NAmessage_u.event = event;
    /* and use xdr_free to free wrapped event */
    xdr_free(xdr_NAmessage,(char *)&msg);
#endif /* !NADIRECT */
}
