/* $Id: write.c,v 1.25 1994/03/07 18:34:04 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:31 EDT 1991
 *
 * Revision History: $Log: write.c,v $
 * Revision 1.25  1994/03/07  18:34:04  bst
 * Call dat_SetDirection() on all platforms.
 * Reorganized some conditionals for MSDOS/SIZEOF_INT
 *
 * Revision 1.24  1993/10/26  16:15:34  bst
 * Added coercions for GCC 2.5.0
 *
 * Revision 1.23  1993/08/10  02:12:17  bst
 * Coerce %l args to long.
 * Shorten writes > 64k under DOS.
 *
 * Revision 1.22  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.21  1993/06/12  20:47:54  bst
 * Added call to dat_SetDirection.
 *
 * Revision 1.20  1993/05/18  19:41:21  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.19  1993/04/12  02:10:35  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.18  1993/03/10  03:42:06  bst
 * Removed dat_beginWrite().
 * Use dat_beginIO() instead of dat_beginWrite().
 *
 * Revision 1.17  1993/03/01  04:52:52  bst
 * Use apsiwrite() instead of write() under MSDOS
 *
 * Revision 1.16  1992/07/05  03:08:14  bst
 * Removed checks of 'dat_currentMode'.
 * Used 'stat.pb' instead of 'stat'.
 *
 * Revision 1.15  1992/04/07  22:53:27  bst
 * Use DebugCheck() instead of Debug() to avoid format warning.
 *
 * Revision 1.14  1992/04/06  21:56:05  bst
 * Added coercion to match prototype.
 *
 * Revision 1.13  1992/01/30  06:10:07  bst
 * Removed direction checking.
 *
 * Revision 1.12  1992/01/27  03:56:37  bst
 * Removed uses of MODE_CONVERT
 *
 * Revision 1.11  1991/12/06  06:00:03  bst
 * Coercions to char* for write()
 *
 * Revision 1.10  1991/12/05  18:52:42  bst
 * Make sure all writes are a multiple of BLOCK_LENGTH
 *
 * Revision 1.9  1991/11/11  04:30:22  bst
 * Use new Debug() procedure.
 *
 * Revision 1.8  1991/10/03  14:22:03  bst
 * Don't abort flushWrite if the beginWrite command is rejected.
 *
 * Revision 1.7  1991/09/27  14:49:02  bst
 * If sample rate conversion is loaded, verify correct direction.
 * Added dat_writeany() to bypass above check.
 *
 * Revision 1.6  1991/09/16  05:22:31  bst
 * Changed some function names to make them more consistent.
 * Added call to dat_beginWrite in dat_flushWrite
 *
 * Revision 1.5  1991/09/12  04:49:29  bst
 * Fixed bug in assuming return value from write() was unsigned.
 *
 * Revision 1.4  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.3  1991/08/23  16:00:16  bst
 * Changed dat_sendmsg() interface.
 *
 * Revision 1.2  1991/08/05  19:12:46  bst
 * Changed name of include file to 'initiator.mac.h'
 *
 * Revision 1.1  1991/08/05  06:04:41  bst
 * Initial revision
 *
 *
 */
#include "libdefs.h"
#include "support.h"

#ifdef macintosh
#include "initiator.mac.h"
#endif /* macintosh */
#ifdef MSDOS
#include "aspi_io.h"
#endif /* MSDOS */

/*
 * Write data to DAT tape
 *	data - data to write
 *	nbytes - number of bytes to write
 * Returns:
 *        number of bytes written, or -1 to indicate error
 */
int32 dat_write(dt,data,nbytes)
dat_fd dt;
const byte *data;
int32 nbytes;
{
    return dat_writeany(dt,data,nbytes);
}

int32 dat_writeany(dt,data,nbytes)
dat_fd dt;
const byte *data;
int32 nbytes;
{
#ifndef macintosh
    int32 nwritten;
    if (nbytes % BLOCK_LENGTH) {
	NALog(LOG_WARNING,
	      "Write length of %ld is not a multiple of block size of %d\n",
	      (long)nbytes,BLOCK_LENGTH);
	return -1;
    }
    Debug("libdatlink.write",8,"dat_writeany(%ld)\n",(long)nbytes);
#if SIZEOF_INT == 2
    if (nbytes > 65534)
	nbytes = 65534;
#endif

    dat_SetDirection(dt,1,nbytes);

#ifdef MSDOS
    nwritten = (int32)aspiwrite(dt,(char *)data,(unsigned int)nbytes);
#else /* MSDOS */
    nwritten = longwrite(dt,(char *)data,(unsigned int32)nbytes);
#endif /* MSDOS */

#if SIZEOF_INT == 2
    /* We can write up to 65534 bytes, but 65535 is an error indicator (-1) */
    if (nwritten == 0xffff)
	nwritten = -1;
#endif
    if (nwritten < 0)
	Debug("libdatlink.writeany",1,"dat_write: %s\n", NAsyserr());

    return nwritten;
#else /* macintosh */
    return InitiatorWrite(dt,0,data,nbytes);
#endif /* macintosh */
}

int dat_flushWrite(dt)
dat_fd dt;
{
    DL_Status stat;
    int32 occupied;
    
    if (dat_beginIO(dt,0,1) < 0)
	if (dat_errno != EDLMSGREJECT)
	    return -1;

    if (dat_getStatus(dt,&stat) < 0)
	return -1;
    
    do {
#ifndef macintosh
	sleep(1);
#endif
	occupied = stat.pb.bufferUtilization;
	if (dat_getStatus(dt,&stat) < 0)
	    return -1;
    } while (occupied && (stat.pb.bufferUtilization < occupied));
    
    if (occupied) {
	NALog(LOG_ERR,"dat_flushWrite: DAT-Link buffer is not draining\n");
	dat_errno = EDLFLUSH;
	return -1;
    }

    return 0;
}

