/* $Id: status.c,v 1.29 1996/03/21 18:29:19 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:29 EDT 1991
 *
 * Revision History: $Log: status.c,v $
 * Revision 1.29  1996/03/21  18:29:19  bst
 * Removed dead code
 *
 * Revision 1.28  1996/03/21  16:37:14  bst
 * Made fn static.
 *
 * Revision 1.27  1994/10/26  23:04:26  bst
 * Fixed bug in checks of VUMAX.
 *
 * Revision 1.26  1994/03/07  18:33:37  bst
 * Make sure status buffer in long aligned.
 *
 * Revision 1.25  1993/11/19  03:18:11  bst
 * Assume long status on old firmware revisions.
 *
 * Revision 1.24  1993/11/01  21:46:07  bst
 * Use statType to decide if status if full or partial.
 *
 * Revision 1.23  1993/09/11  14:09:50  bst
 * Removed SIGFPE handling.
 *
 * Revision 1.22  1993/08/10  02:10:17  bst
 * Avoid invalid VU levels which can cause math errors.
 * Handl FPE errors during status conversion.
 * Moved ntohl() macroto support.h
 *
 * Revision 1.21  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.20  1993/06/16  17:21:33  bst
 * Retry status reads after a failure.
 *
 * Revision 1.19  1993/05/21  16:14:53  bst
 * Use dat_read() to retrieve status if autoStatus is available.
 *
 * Created dat_convertStatus()
 *
 * Revision 1.18  1993/04/22  03:18:49  bst
 * Added static function prototypes.
 *
 * Revision 1.17  1993/04/12  02:10:28  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.16  1992/11/04  22:03:47  bst
 * Added include of support.h.
 *
 * Revision 1.15  1992/11/01  22:47:43  bst
 * Added scaling of VU levels.
 *
 * Revision 1.14  1992/10/04  17:19:46  bst
 * Corrected byte-order dependencies for dsp floats.
 *
 * Revision 1.13  1992/07/05  03:07:19  bst
 * Changed 'stat' structure to have separate record and playback fields.
 *
 * Revision 1.12  1991/12/17  02:53:56  bst
 * Moved DSPFloat(),to dsp.c as NativeFloat()
 * Added gain
 *
 * Revision 1.11  1991/12/05  18:52:32  bst
 * Increased debug level for NativeFloat
 *
 * Revision 1.10  1991/12/05  02:20:21  bst
 * Added interpretration of more fields of status.
 * Convert DSP floating point number to host format.
 *
 * Revision 1.9  1991/11/11  04:28:52  bst
 * Worked around assertions warning re: null effect.
 * Added missing braces to if clause - only byte-swap if dat_sendmsg() succeeded.
 *
 * Revision 1.8  1991/10/30  02:56:39  bst
 * Add coercions to int before shifting bytes (DEC warning)
 *
 * Revision 1.7  1991/10/25  04:23:21  bst
 * Remove (void) coercion from free.
 *
 * Revision 1.6  1991/10/25  03:41:15  bst
 * Made indep. of host byte-order.
 *
 * Revision 1.5  1991/09/16  05:22:22  bst
 * Changed dat_getstat to dat_getStatus
 *
 * Revision 1.4  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.3  1991/08/23  16:00:16  bst
 * Changed dat_sendmsg() interface.
 *
 * Revision 1.2  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include <assert.h>
#include <math.h>
#include <signal.h>
#ifdef MSDOS
#include <float.h>
#endif /* MSDOS */
#include "libdefs.h"
#include "support.h"

/* Don't let VU levels or scale execeed this to avoid overflows when scaling */
#define VUMAX 1e10

/* Get status of DAT-Link
 */


static void ConvertFloat P((float *x));
static void ConvertFloat(x)
float *x;
{
    dsp32float xtmp = *(dsp32float *)x;
    xtmp = ntohl(xtmp);
    *x = NativeFloat(xtmp);
}

int dat_getStatus(dt,stat)
dat_fd dt;
DL_Status *stat;
{
    /* If params are not already loaded, dat_version() will result in a
       recursion loop */
    if (dat_version(dt)%1000 < 44) {
	int result = dat_sendmsg(dt,DL_GETSTATUS,0,0,sizeof(*stat),(byte *)stat);
	if (result < 0)
	    return result;
	dat_convertStatus(stat);
    }
    else {
	byte bbuf[STAT_XFR_SIZE+3];   /* Extra for alignment */
	byte *buf;
	DL_Status *rstat;

	/* Need to be sure buf is aligned on 4-byte boundary */
	buf = bbuf;
	while (((long)buf) & 0x3)
	    buf++;

	/* Try reading twice in case the OS thinks we're at EOF */
	if ((dat_read(dt,buf,(int32)0,&rstat) != 0) &&
	    (dat_read(dt,buf,(int32)0,&rstat) != 0)) {
	    NALog(LOG_ERR,"dat_getStatus: Internal Error: status read error\n");
	    return -1;
	}
	if ((byte *)rstat != buf) {
	    NALog(LOG_ERR,
		  "dat_getStatus: Internal Error: status alignment error (rstat=%p, buf=%p)\n",rstat,buf);
	    return -1;
	}
	if ((dat_version(dt)%1000) < 48)
	    rstat->statType = 0;
	memcpy(stat,rstat,sizeof(*stat));
    }
    return 0;
}

#if 0
#ifdef MSDOS
static void dat_statFPEHandler(sig, code)
int sig,code;
#else /* MSDOS */
static void dat_statFPEHandler(sig)
int sig;
#endif /* !MSDOS */
{
#ifdef MSDOS
    const char *ftype;
    switch (code) {
      case FPE_INTOVFLOW:
	ftype = "INTOVFLOW";
	break;
      case FPE_INTDIV0:
	ftype = "INTDIV0";
	break;
      case FPE_INVALID:
	ftype = "INVALID";
	break;
      case FPE_ZERODIVIDE:
	ftype = "ZERODIVIDE";
	break;
      case FPE_OVERFLOW:
	ftype = "OVERFLOW";
	break;
      case FPE_UNDERFLOW:
	ftype = "UNDERFLOW";
	break;
      case FPE_INEXACT:
	ftype = "INEXACT";
	break;
      case FPE_STACKFAULT:
	ftype = "STACKFAULT";
	break;
      case FPE_EXPLICITGEN:
	ftype = "EXPLICIT";
	break;
      default:
	ftype = "???";
	break;
    }
    NALog(LOG_WARNING,"Floating point %s during status conversion. (%d,%d)\n",
	  ftype,sig,code);
#else /* MSDOS */
    NALog(LOG_WARNING,"Floating point signal during status conversion. (%d)\n",
	  sig);
#endif /* !MSDOS */
}
#endif

void dat_convertStatus(stat)
DL_Status *stat;
{
#if 0
#ifdef SIGFPE
    void (*oldFPEHandler)P((int sig));
    oldFPEHandler = signal(SIGFPE,dat_statFPEHandler);
#endif
#endif
    stat->locked = ntohl(stat->locked);
    stat->dspStatus = ntohl(stat->dspStatus);
    stat->uptime = ntohl(stat->uptime);
    stat->pb.transferStatus = ntohl(stat->pb.transferStatus);
    stat->pb.bufferSize = ntohl(stat->pb.bufferSize);
    stat->pb.bufferUtilization = ntohl(stat->pb.bufferUtilization);
    stat->pb.transferMode = ntohl(stat->pb.transferMode);
    stat->rec.transferStatus = ntohl(stat->rec.transferStatus);
    stat->rec.bufferSize = ntohl(stat->rec.bufferSize);
    stat->rec.bufferUtilization = ntohl(stat->rec.bufferUtilization);
    stat->rec.transferMode = ntohl(stat->rec.transferMode);

    if (stat->statType == 0) {
	stat->pb.sampleNumber = ntohl(stat->pb.sampleNumber);
	stat->rec.sampleNumber = ntohl(stat->rec.sampleNumber);
	ConvertFloat(&stat->pb.VULevel_left);
	ConvertFloat(&stat->pb.VULevel_right);
	ConvertFloat(&stat->pb.VULevel_scale);
	if (stat->pb.VULevel_left > VUMAX)
	    stat->pb.VULevel_left = VUMAX;
	if (stat->pb.VULevel_right > VUMAX)
	    stat->pb.VULevel_right = VUMAX;
	if (stat->pb.VULevel_scale > VUMAX)
	    stat->pb.VULevel_scale = VUMAX;
	if (stat->pb.VULevel_left < -VUMAX)
	    stat->pb.VULevel_left = -VUMAX;
	if (stat->pb.VULevel_right < -VUMAX)
	    stat->pb.VULevel_right = -VUMAX;
	if (stat->pb.VULevel_scale < -VUMAX)
	    stat->pb.VULevel_scale = -VUMAX;
	stat->pb.VULevel_left *= stat->pb.VULevel_scale;
	stat->pb.VULevel_right *= stat->pb.VULevel_scale;
	ConvertFloat(&stat->pb.VUDecay);
	ConvertFloat(&stat->pb.gain);
	ConvertFloat(&stat->rec.VULevel_left);
	ConvertFloat(&stat->rec.VULevel_right);
	ConvertFloat(&stat->rec.VULevel_scale);
	if (stat->rec.VULevel_left > VUMAX)
	    stat->rec.VULevel_left = VUMAX;
	if (stat->rec.VULevel_right > VUMAX)
	    stat->rec.VULevel_right = VUMAX;
	if (stat->rec.VULevel_scale > VUMAX)
	    stat->rec.VULevel_scale = VUMAX;
	if (stat->rec.VULevel_left < -VUMAX)
	    stat->rec.VULevel_left = -VUMAX;
	if (stat->rec.VULevel_right < -VUMAX)
	    stat->rec.VULevel_right = -VUMAX;
	if (stat->rec.VULevel_scale < -VUMAX)
	    stat->rec.VULevel_scale = -VUMAX;
	stat->rec.VULevel_left *= stat->rec.VULevel_scale;
	stat->rec.VULevel_right *= stat->rec.VULevel_scale;
	ConvertFloat(&stat->rec.VUDecay);
	ConvertFloat(&stat->rec.gain);
    }
#if 0
#ifdef SIGFPE
    (void)signal(SIGFPE,oldFPEHandler);
#endif
#endif
}


