/* $Id: serial.c,v 1.8 1993/08/10 02:09:59 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Tue Apr 28 15:14:11 EDT 1992
 *
 * Revision History: $Log: serial.c,v $
 * Revision 1.8  1993/08/10  02:09:59  bst
 * Use SIZEOF_INT instead of INT16
 *
 * Revision 1.7  1993/06/01  02:44:43  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 1.6  1993/04/22  18:31:26  bst
 * Fixed conditions so they will not give warnings under DOS.
 *
 * Revision 1.5  1993/04/22  03:18:29  bst
 * Use MAXSERIAL for maximum transfers to serial port.
 *
 * Revision 1.4  1993/04/12  02:10:06  bst
 * Added coercion to unsigned int for dat_sendmsg arg.
 *
 * Revision 1.3  1993/03/01  04:02:32  bst
 * Use malloc() instead of static storage for buffers.
 *
 * Revision 1.2  1993/02/02  16:20:01  bst
 * Made 'rbuf' and 'sbuf' static so they don't overflow stack.
 *
 * Revision 1.1  1992/05/01  17:12:20  bst
 * Initial revision
 *
 */
#include "libdefs.h"
#include "dat_types.h"

#if SIZEOF_INT == 2
#define MAXSERIAL 0x7fff
#else
#define MAXSERIAL DL_MAXMSGLENGTH-DL_HEADER_LEN-1
#endif

int dat_serialRead(dt,port,buf,nbytes)
dat_fd dt;
int port;
char *buf;
int nbytes;
{
    byte sbuf[3];
    static byte *rbuf = 0;
    int nrecv;

    if (rbuf == 0)
	rbuf = (byte *)malloc((size_t)DL_MAXMSGLENGTH);

    if (port != 1) {
	errno = EINVAL;
	return -1;
    }
    if (nbytes >= MAXSERIAL)
	nbytes = MAXSERIAL;
    sbuf[0] = port;
    sbuf[1] = (nbytes>>8)&0xff;
    sbuf[2] = nbytes&0xff;
    if ((nrecv =
	 dat_sendmsg(dt,DL_SERIALREAD,3,sbuf,(unsigned int)nbytes+1,rbuf)) < 0)
	return -1;
    if ((nrecv < 1) || (rbuf[0] != port)) {
	errno = EDLBADMSG;
	return -1;
    }
    if (nrecv > 1)
	memcpy(buf,&rbuf[1],(size_t)(nrecv-1));
    return nrecv-1;
}

int dat_serialWrite(dt,port,buf,nbytes)
dat_fd dt;
int port;
const char *buf;
int nbytes;
{
    static byte *sbuf = 0;

    if (sbuf == 0)
	sbuf = (byte *)malloc((size_t)DL_MAXMSGLENGTH);

    if ((port&0x7f) != 1) {
	errno = EINVAL;
	return -1;
    }
    sbuf[0] = port;
    if (nbytes >= MAXSERIAL)
	nbytes = MAXSERIAL;
    memcpy(&sbuf[1],buf,(size_t)nbytes);
    if (dat_sendmsg(dt,DL_SERIALWRITE,(unsigned int)(nbytes+1),sbuf,0,0) < 0)
	return -1;
    return nbytes;
}

