/* $Id: sendmsg.c,v 1.39 1994/05/12 03:02:19 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:24 EDT 1991
 *
 * Revision History: $Log: sendmsg.c,v $
 * Revision 1.39  1994/05/12  03:02:19  bst
 * Coerce bzero 1st arg to char*
 *
 * Revision 1.38  1994/03/07  18:33:21  bst
 * Removed lseek() calls (Handled by dat_SetDirection() now)
 *
 * Revision 1.37  1993/08/27  00:32:40  bst
 * Use mtim() instead of micro_time()
 *
 * Revision 1.36  1993/08/10  02:09:03  bst
 * Increase stack size under DOS.
 * Coerce %l args to long
 *
 * Revision 1.35  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.34  1993/06/23  03:34:25  bst
 * Initialize end of buffer to avoid UMR.
 *
 * Revision 1.33  1993/06/01  02:44:31  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 1.32  1993/05/18  19:41:18  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.31  1993/05/05  17:10:05  bst
 * Don't include aspi_io.h except under DOS.
 *
 * Revision 1.30  1993/04/22  03:14:57  bst
 * Renamed 'utime()' as 'micro_time()'
 * Include aspi_io.h
 *
 * Revision 1.29  1993/04/12  02:09:49  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.28  1993/03/01  16:45:20  bst
 * Removed special THINK-C declaration (use enum==int option under Think-C)
 *
 * Revision 1.27  1993/03/01  04:01:37  bst
 * Use malloc() instead of static s
 * torage for buffers.
 * Some fixes for THINK C.
 *
 * Revision 1.26  1993/02/28  20:08:17  bst
 * Use aspilseek() on DOS.
 *
 * Revision 1.25  1992/08/20  00:19:02  bst
 * Don't use lseek() on mac.
 *
 * Revision 1.24  1992/08/19  00:22:07  bst
 * Removed old includes of ioctl.h and mtio.h.
 *
 * Revision 1.23  1992/08/14  03:02:21  bst
 * Check for message too large before filling buffer.
 * Message too large no returns and error rather than truncating.
 *
 * Revision 1.22  1992/07/15  23:46:39  bst
 * Moved cmd_magic[] and msgnames[] to constants.c
 *
 * Revision 1.21  1992/07/01  17:07:22  bst
 * Added seek to beginning of DAT-Link 'file' so position doesn't overflow.
 *
 * Revision 1.20  1992/05/20  01:46:58  bst
 * Added COLDBOOT message label.
 *
 * Revision 1.19  1992/05/01  17:06:08  bst
 * Added SERIALWRITE and SERIALREAD directives.
 *
 * Revision 1.18  1992/04/06  21:55:58  bst
 * Added coercion to match prototype.
 *
 * Revision 1.17  1991/12/12  04:36:26  bst
 * Added SETDSPADDRS and SETDSPPGM message names.
 *
 * Revision 1.16  1991/12/08  20:27:31  bst
 * Removed coercions of args to memcpy()
 * Removed include of memory.h
 *
 * Revision 1.15  1991/12/06  05:59:41  bst
 * Coercions to char* for memcpy()
 *
 * Revision 1.14  1991/12/05  02:19:19  bst
 * Added timing of transactions when sendmsg.Debug >= 8
 * Don't read replies from DAT-Link if nrecv==0
 *
 * Revision 1.13  1991/11/11  04:28:13  bst
 * Use new Debug() procedure.
 *
 * Revision 1.12  1991/11/06  16:42:53  bst
 * Coerce opcode into an int before using as an array index.
 *
 * Revision 1.11  1991/11/04  02:10:31  bst
 * Display command names in debug messages.
 *
 * Revision 1.10  1991/10/25  03:41:07  bst
 * Added debug message.
 *
 * Revision 1.9  1991/10/20  18:26:21  bst
 * Made nrecv a signed int instead of unsigned.
 * If nrecv < 0 don't read back reply.
 *
 * Revision 1.8  1991/10/09  17:19:39  bst
 * Coerce buffer[i+n] to an unsigned int before shifting (DEC warnings)
 *
 * Revision 1.7  1991/10/03  14:21:34  bst
 * Print message rejected error only if debug > 1
 *
 * Revision 1.6  1991/09/27  14:47:41  bst
 * Used dat_readany() and dat_writeany() to bypass direction checking.
 *
 * Revision 1.5  1991/09/12  04:49:14  bst
 * Added coercions of enumerations to use as integers.
 *
 * Revision 1.4  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.3  1991/08/23  16:01:12  bst
 * Changed argument list.
 * Added transmission and reception of data lengths.
 *
 * Revision 1.2  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include "libdefs.h"
#include <assert.h>
#ifdef MSDOS
#include "aspi_io.h"
#ifdef __BORLANDC__
/* Bump up stack size */
extern unsigned _stklen = 12000;
#endif
#endif /* MSDOS */
#include "support.h"

int dat_sendmsg(dt,opcode,nsend,sdata,nrecv,rdata)
dat_fd dt;
Opcodes opcode;
unsigned int nsend;
const byte *sdata;
unsigned int nrecv;
byte *rdata;
{
    static byte *buffer = 0;
    unsigned int txlen,rxlen;
    int i,nxfr;
    int32 replyDataLen;
    double start;
    
    if (buffer == 0)
	buffer = (byte *)malloc((size_t)DL_MAXMSGLENGTH);

    start = mtime();

    Debug("libdatlink.sendmsg",7,
	  "dat_sendmsg(%s,ns=%u,nr=%u,rdata=%p,sdata=%p)\n",
	  msgnames[(int)opcode],nsend,nrecv,rdata,sdata);

    for (i=0;i<DL_MAGIC_LEN;i++)
	buffer[i] = cmd_magic[i];

    buffer[i++] = (byte)opcode;

    if (nsend > DL_MAXMSGLENGTH-DL_HEADER_LEN) {
	Debug("libdatlink.sendmsg",1,
	      "Message too long (%ld bytes), max is %ld.\n",
	      (long)nsend+DL_HEADER_LEN,(long)DL_MAXMSGLENGTH);
	dat_errno= EDLSNDMSG;
	return -1;
/*	nsend = DL_MAXMSGLENGTH-DL_HEADER_LEN; */
    }

    buffer[i++] = (((unsigned int32)nsend)>>24)&0xff;
    buffer[i++] = (((unsigned int32)nsend)>>16)&0xff;
    buffer[i++] = (nsend>>8)&0xff;
    buffer[i++] = nsend&0xff;
    assert(i == DL_HEADER_LEN);

    txlen = ((int)((nsend+DL_HEADER_LEN+BLOCK_LENGTH-1)/BLOCK_LENGTH))*BLOCK_LENGTH;
    if (nsend) {
	memcpy(&buffer[DL_HEADER_LEN],sdata,nsend);
    }
    if (txlen > (nsend+DL_HEADER_LEN))
	/* To make sure Purify doesn't detect a UMR */
	bzero((char *)&buffer[DL_HEADER_LEN+nsend],txlen-nsend-DL_HEADER_LEN);

    nxfr = dat_writeany(dt,buffer,(int32)txlen);
    if (nxfr != txlen) {
	Debug("libdatlink.sendmsg",1,"dat_sendmsg: write (%d/%d)\n",nxfr,txlen);
	dat_errno= EDLSNDMSG;
	return -1;
    }

    if (nrecv == 0)
	return 0;

    rxlen = ((int)(nrecv+DL_HEADER_LEN+BLOCK_LENGTH-1)/BLOCK_LENGTH)*BLOCK_LENGTH;
    nxfr = dat_readany(dt,buffer,(int32)rxlen);
    if (nxfr != rxlen) {
	Debug("libdatlink.sendmsg",1,"dat_sendmsg: read (%d/%d)\n",nxfr,rxlen);
	dat_errno = EDLRCVMSG;
	return -1;
    }

    for (i=0;i<DL_MAGIC_LEN;i++)
	if (buffer[i] != cmd_magic[i]) {
	    Debug("libdatlink.sendmsg",1,
		  "dat_sendmsg: Bad magic number in reply byte %d\n",i);
	    dat_errno = EDLBADMSG;
	    return -1;
	}

    if (buffer[i++] != (byte)opcode) {
	if (buffer[i-1] == (byte)DL_ERROR) {
	    Debug("libdatlink.sendmsg",2,"dat_sendmsg: %s message rejected.\n",
		  msgnames[(int)opcode]);
	    dat_errno = EDLMSGREJECT;
	}
	else
	    dat_errno = EDLBADMSG;
	return -1;
    }

    replyDataLen = (((unsigned int32)buffer[i])<<24)
	| (((unsigned int32)buffer[i+1])<<16)
	| (((unsigned int32)buffer[i+2])<<8) | buffer[i+3];
    
    if (nrecv > replyDataLen)
	nrecv = replyDataLen;

    for (i=0;i<nrecv;i++)
	rdata[i] = buffer[i+DL_HEADER_LEN];

    Debug("libdatlink.sendmsg",8,"dat_sendmsg took %f seconds\n",mtime()-start);
    return replyDataLen;
}


