/* $Id: read.c,v 1.38 1995/03/15 23:58:58 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:17 EDT 1991
 *
 * Revision History: $Log: read.c,v $
 * Revision 1.38  1995/03/15  23:58:58  bst
 * Use an external array rather than a scalar static for bytesSinceRewind.
 *
 * Revision 1.37  1994/03/07  18:30:44  bst
 * Call dat_SetDirection() on all platforms.
 * Made dat_SetDirection() do rewinds on tape drives before file pointers overflow.
 * Reorganized conditionals for MSDOS and SIZEOF_INT
 *
 * Revision 1.36  1993/11/19  03:17:26  bst
 * Don't check status alignment on Mac (not needed)
 *
 * Revision 1.35  1993/10/30  20:25:38  bst
 * Check that status is aligned on a word boundary.
 *
 * Revision 1.34  1993/10/26  16:15:30  bst
 * Added coercions for GCC 2.5.0
 *
 * Revision 1.33  1993/10/04  18:11:07  bst
 * Use an array indexed by fd for lastDirection.
 *
 * Revision 1.32  1993/08/11  21:11:10  bst
 * Change autoStatus to an array.
 *
 * Revision 1.31  1993/08/10  02:05:55  bst
 * Punt on reads > 64k if SIZEOF_INT == 2
 * Coerce %l args to long.
 *
 * Revision 1.30  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.29  1993/06/16  17:21:17  bst
 * Log error if unable to set autoStatus mode.
 *
 * Revision 1.28  1993/06/12  20:46:38  bst
 * Added dat_SetDirection to do a rewind between read/write changes.
 *
 * Revision 1.27  1993/05/21  16:14:26  bst
 * Modified dat_read() to optionally retrieve DAT-Link status.
 *
 * Revision 1.26  1993/05/18  19:40:52  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.25  1993/04/12  02:04:29  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.24  1993/03/10  03:42:00  bst
 * Removed dat_beginRead().
 *
 * Revision 1.23  1993/02/28  20:07:47  bst
 * Use aspiread() on DOS.
 *
 * Revision 1.22  1993/02/08  19:46:51  bst
 * Modified error handling on Macintosh.
 * Got rid of static 'eofreached' variable on Mac.
 *
 * Revision 1.21  1992/11/01  19:32:15  bst
 * Removed check for firmware revision.
 *
 * Revision 1.20  1992/07/05  03:06:48  bst
 * Removed checks of 'dat_currentMode'
 * Used stat.rec instead of 'stat'.
 *
 * Revision 1.19  1992/04/07  22:53:10  bst
 * Use DebugCheck() instead of Debug() to avoid format warning.
 *
 * Revision 1.18  1992/04/06  21:55:26  bst
 * Added coercion to match read() prototype.
 *
 * Revision 1.17  1992/02/11  18:16:05  bst
 * Moved declaration of 'eofreached' to beginning of block.
 *
 * Revision 1.16  1992/01/30  06:10:00  bst
 * Removed direction checking.
 *
 * Revision 1.15  1992/01/27  03:55:27  bst
 * Removed MODE_CONVERT usage
 *
 * Revision 1.14  1991/12/08  20:27:20  bst
 * Removed coercions of args to memcmp().
 *
 * Revision 1.13  1991/12/06  05:59:02  bst
 * Coercion to char*
 *
 * Revision 1.12  1991/12/05  18:51:24  bst
 * Check to make sure reads are a multiple of BLOCK_LENGTH
 * Discard replies received while trying to read data.
 *
 * Revision 1.11  1991/12/05  02:15:36  bst
 * Slight change of debug messages.
 *
 * Revision 1.10  1991/11/11  04:26:10  bst
 * Use new DEBUG routine.
 * Check for errors in dat_nAvail().
 *
 * Revision 1.9  1991/10/17  21:13:20  bst
 * Removed duplicate definition of eofreached on mac.
 *
 * Revision 1.8  1991/10/04  02:15:09  bst
 * Workaround bug in ROM revisions < 13 in BEGINREAD.
 *
 * Revision 1.7  1991/09/27  17:55:00  bst
 * Removed dat_waitForData() - replaced with dat_nAvail().
 *
 * Revision 1.6  1991/09/27  14:47:02  bst
 * If sample rate converter is loaded, make sure its for the correction direction.
 * Added dat_waitForData()
 *
 * Revision 1.5  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.4  1991/08/23  16:00:16  bst
 * Changed dat_sendmsg() interface.
 *
 * Revision 1.3  1991/08/05  19:12:46  bst
 *  Changed name of include file to 'initiator.mac.h'
 *
 * Revision 1.2  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include "libdefs.h"
#include "support.h"

#ifdef macintosh
#include "initiator.mac.h"
#endif /* macintosh */
#ifdef MSDOS
#include "aspi_io.h"
#endif /* MSDOS */

#ifdef __sgi
#include <sys/mtio.h>
#endif

#ifndef macintosh	
void dat_SetDirection(dt,todatlink,nbytes)
dat_fd dt;
int todatlink;
int32 nbytes;
{
#ifdef __sgi
    /* On SGI machines, we can only change between reading and writing at BOP */
    if (lastDirection[dt] != todatlink) {
	struct mtop op;
	op.mt_op = MTREW;
	op.mt_count = 1;
	Debug("libdatlink.SetDirect",2,"Rewinding %d for todatlink=%d\n",
	      dt,todatlink);
	if (ioctl(dt, MTIOCTOP,(char *)&op) < 0)
	    perror("MTIOCTOP");
	bytesSinceRewind[dt] = 0;
    }
    lastDirection[dt] = todatlink;
#endif /* __sgi */
    /* On most machines, there is a limit to how many bytes can be read/written
       without a rewind.  In SUNOS it is 2^31, in MSDOS it appears to be 2^23 */
    bytesSinceRewind[dt] += nbytes;
    if (bytesSinceRewind[dt] > (1L<<22)) {
	/* Time to fake a rewind for the benefit of the SCSI controller/driver */
	Debug("dat_SetDirection",1,"Rewinding after %ld bytes\n",
	      bytesSinceRewind[dt]);
#ifdef MSDOS
	if (aspilseek(dt,0L,0) < 0)
#else
	if (lseek(dt,0L,0) < 0)
#endif
	    NALog(LOG_ERR,"lseek failed: %s\n",NAsyserr());
	/* Since we are called before actually sending the data we still to 
	   count these 'nbytes' */
	bytesSinceRewind[dt] = nbytes;
    }
}
#endif /* macintosh */


/*
 * Read data from DAT machine
 *	data - pointer to buffer for incoming data
 *	nbytes - number of bytes to transfer
 * Returns:
 *	number of bytes written, or -1 for error
 *      return 0 for EOF (Buffer overrun)
 */
int32 dat_read(dt,data,nbytes,stat)
dat_fd dt;
byte *data;
int32 nbytes;
DL_Status **stat;
{
    int32 nread;
    int statSize = 0;

    /* Make sure AUTOSTATUS mode is set appropriately */
    if (dat_setAutoStatus(dt,stat?1:0) < 0) {
	NALog(LOG_ERR,"Unable to set autoStatus mode\n");
	return -1;
    }

    if (autoStatus[dt] == 1) {
	statSize = STAT_XFR_SIZE;
	*stat = 0;
	if (nbytes+statSize > OPTIMUM_TRANSFER_LENGTH) {
	    Debug("libdatlink.read",1,
		  "dat_read: Requested shortened from %ld to %ld bytes for stat\n",
		  (long)nbytes+statSize,(long)OPTIMUM_TRANSFER_LENGTH-statSize);
	    nbytes = OPTIMUM_TRANSFER_LENGTH-statSize;
	}
    }

    nread = dat_readany(dt,data,nbytes+statSize);

    if ((nread >= DL_MAGIC_LEN) &&
	(memcmp(data,cmd_magic,DL_MAGIC_LEN) == 0)) {
	/* Looks like we got an old reply */
	NALog(LOG_WARNING,
	      "libdatlink.read: Reply discarded: opcode=%d\n",data[DL_MAGIC_LEN]);
	nread = dat_readany(dt,data,nbytes+statSize);
    }
    
    if ((autoStatus[dt] == 1) && (nread > nbytes)) {
	if (nread < nbytes+statSize) {
	    NALog(LOG_ERR,"Only read %ld/%ld bytes from DAT-Link\n",
		  (long)nread,(long)nbytes+statSize);
	    return (nread>nbytes)?nbytes:nread;
	}
#ifndef macintosh
	else if ((((long)data)+nbytes) & 0x3) {
	    NALog(LOG_ERR,"dat_read() attempted to read status on non-word boundary,data=%p,nbyte=%ld\n",data,(long)nbytes);
	    return nread-statSize;
	}
#endif
	else {
	    /* Adjust pointer to point at status */
	    *stat = (DL_Status *)&data[nbytes];
	    /* Convert status from DSP to host format */
	    dat_convertStatus(*stat);
	    return nread-statSize;
	}
    }
    else
	return nread;
}

int32 dat_readany(dt,data,nbytes)
dat_fd dt;
byte *data;
int32 nbytes;
{
    int32 nread;

    if (nbytes % BLOCK_LENGTH) {
	NALog(LOG_WARNING,
		"Read length of %ld is not a multiple of block size of %d\n",
		(long)nbytes,BLOCK_LENGTH);
	nbytes = (nbytes/BLOCK_LENGTH)*BLOCK_LENGTH;
    }
    Debug("libdatlink.read",8,"dat_readany(%ld)\n",(long)nbytes);
#ifdef macintosh
    nread = InitiatorRead(dt,0,data,nbytes);
#else /* macintosh */

#if SIZEOF_INT == 2
    if (nbytes > 65534)
	nbytes = 65534;
#endif

    dat_SetDirection(dt,0,nbytes);
#ifdef MSDOS
    nread = (int32)aspiread(dt,(char *)data,(unsigned int)nbytes);
#else /* MSDOS */
    nread = longread(dt,(char *)data,(unsigned int)nbytes);
#endif /* MSDOS */

#if SIZEOF_INT == 2
    /* We can write up to 65534 bytes, but 65535 is an error indicator (-1) */
    if (nread == 0xffff)
	nread = -1;
#endif

#endif /* macintosh */
    if (nread < 0)
	Debug("libdatlink.read",1,"read failed: %s, nbytes=%ld, nread=%ld\n",
	      NAsyserr(),(long)nbytes,(long)nread);
    if (nread == 0) {
	Debug("libdatlink.read",1,"Buffer overrun\n");
	nread = -1;   /* Really, this is an error */
	dat_errno = EDLOVERRUN;
    }
    return nread;
}

/*
 * Check how much data is available for reading.
 *   Return: -1 for error
 *           otherwise - number of bytes immediately available in DAT-Link
 */
int32 dat_nAvail(dt)
dat_fd dt;
{
    DL_Status stat;

    if (dat_getStatus(dt,&stat) < 0)
	return -1;
    if (stat.locked == 0) {
	dat_errno = EDLLOSTLOCK;
	return -1;
    }
    if (stat.rec.transferStatus != 2) {
	dat_errno = EDLDSP;
	return -1;
    }
    return stat.rec.bufferUtilization;
}
