/* $Id: perror.c,v 1.8 1993/06/16 17:19:28 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:16 EDT 1991
 *
 * Revision History: $Log: perror.c,v $
 * Revision 1.8  1993/06/16  17:19:28  bst
 * Added include of string.h
 *
 * Revision 1.7  1993/05/18  19:40:45  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.6  1992/11/04  04:34:57  bst
 * Added EDLBADPGM error message.
 *
 * Revision 1.5  1991/11/11  04:25:59  bst
 * Added 'Lost lock' error.
 *
 * Revision 1.4  1991/09/27  17:54:52  bst
 * Added new error codes.
 *
 * Revision 1.3  1991/09/27  14:46:51  bst
 * Added new error codes.
 *
 * Revision 1.2  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.1  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include "libdefs.h"
#include <string.h>

int dat_errno = 0;
char *dat_errlist[] = {
    "DAT-Link Error 0",
    "DAT-Link internal buffer overrun",
    "DAT-Link internal buffer underrun",
    "Digital signal processor error",
    "Error sending message to DAT-Link",
    "Error receiving message from DAT-Link",
    "Bad message from DAT-Link",
    "Message rejected by DAT-Link",
    "DAT-Link buffer not flushed",
    "Invalid mode setting",
    "Unimplemented",
    "Illegal argument",
    "Unable to implement requested sample-rate conversion",
    "Attempt to transfer data opposite direction specified by mode",
    "Attempt to set mode while transfers in progress",
    "Lost lock from digital audio device",
    "Invalid or incompatible DSP program",
    };
int dat_nerr = sizeof(dat_errlist)/sizeof(dat_errlist[0]);

void dat_perror(msg)
const char *msg;
{
    if (dat_errno == 0)
	NALog(LOG_ERR,"%s: %s\n",msg,NAsyserr());
    else {
	char buf[200];
	if (msg && *msg)
	    sprintf(buf,"%s: ",msg);
	if ((dat_errno > 0) && (dat_errno < dat_nerr))
	    strcat(buf,dat_errlist[dat_errno]);
	else
	    sprintf(buf,"%sDAT-Link error %d\n",buf,dat_errno);
	NALog(LOG_ERR,"%s\n",buf);
	dat_errno = 0;
    }
}


