/* $Id: open.c,v 1.38 1996/03/21 16:35:35 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:14 EDT 1991
 *
 * Revision History: $Log: open.c,v $
 * Revision 1.38  1996/03/21  16:35:35  bst
 * Added coercion.
 *
 * Revision 1.37  1995/03/15  23:58:39  bst
 * Index lastDirection by FD not unit.
 * Initialize bytesSinceRewind.
 *
 * Revision 1.36  1994/08/30  18:58:06  bst
 * Removed redundant word "warning"
 *
 * Revision 1.35  1994/05/26  15:54:58  bst
 * Added extern dat_FirmwareRootName to set firmware name.
 * Only check firmware revision match if dat_FirmwareRootName is default.
 *
 * Revision 1.34  1993/11/19  03:16:21  bst
 * Removed fcntl.h
 *
 * Revision 1.33  1993/11/16  01:49:46  bst
 * Added PRAGMA_UNUSED
 *
 * Revision 1.32  1993/10/04  18:10:27  bst
 * Initialize lastDirection[] at each open.
 *
 * Revision 1.31  1993/08/27  00:31:16  bst
 * Removed declaration of getenv()
 *
 * Revision 1.30  1993/08/11  21:11:03  bst
 * Changed autoStatus to an array.
 *
 * Revision 1.29  1993/08/10  02:05:30  bst
 * Use O_BINARY
 *
 * Revision 1.28  1993/05/21  16:13:48  bst
 * Added autoStatus global, initialize it to zero in dat_reset()
 *
 * Revision 1.27  1993/05/18  19:40:28  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.26  1993/03/24  19:37:29  bst
 * Pass 3rd arg to aspiopen().
 * Include naversion.h.
 *
 * Revision 1.25  1993/03/10  03:41:52  bst
 * Added dat_beginIO().
 *
 * Revision 1.24  1993/03/09  02:12:15  bst
 * Use aspiopen() instead of open() under MSDOS.
 *
 * Revision 1.23  1993/02/28  20:07:33  bst
 * Added ASPI support for DOS.
 *
 * Revision 1.22  1992/10/04  17:19:32  bst
 * Check for expected firmware revision.
 *
 * Revision 1.21  1992/07/05  03:06:36  bst
 * Remvoed setting of 'dat_currentMode'.
 *
 * Revision 1.20  1992/05/20  01:45:37  bst
 * Assume DAT-Link connection was close by dat_reload().
 * Do 2 step reload if already running out of RAM.
 *
 * Revision 1.19  1992/05/12  18:50:28  bst
 * NeXT - close always returns -1 with EPERM - workaround.
 *
 * Revision 1.18  1992/02/11  18:15:33  bst
 * Check "DL_UNIT" environment variable on Mac.
 * Accept device as a DAT-Link if it returns ARCHIVE Id.
 *
 * Revision 1.17  1992/01/27  06:18:53  bst
 * Removed use of 'Unit' default.
 *
 * Revision 1.16  1992/01/17  04:17:11  bst
 * Added second arg to dat_open()
 *     -> device name
 *
 * Revision 1.15  1991/12/06  05:58:55  bst
 * New defaults.
 *
 * Revision 1.14  1991/12/05  02:15:25  bst
 * Fixed typo.
 *
 * Revision 1.13  1991/11/22  05:08:23  bst
 * Don't call dat_reset() from dat_open_nrl()
 *
 * Revision 1.12  1991/11/12  05:44:26  bst
 * Provide hard-wired defaults for unit and device name.
 *
 * Revision 1.11  1991/11/11  04:25:28  bst
 * Use new Debug() routine.
 * Use defaults files for unit number and device paths.
 *
 * Revision 1.10  1991/11/08  05:56:52  bst
 * Improved indentation.
 *
 * Revision 1.9  1991/10/30  04:17:09  bst
 * Renamed 'stat' to 'dlstat'
 *
 * Revision 1.8  1991/10/24  22:29:53  bst
 * Created dat_open_nrl() to open with reloading firmware.
 * On MAC, call TestUnitReady before Inquiry()
 *
 * Revision 1.7  1991/10/20  18:25:10  bst
 * Use Inquiry() on MAC to verify that device is really a DAT-Link.
 * Reload firmware if its out-of-date.
 *
 * Revision 1.6  1991/09/27  14:45:14  bst
 * Reset also resets 'dat_currentMode' global variable.
 *
 * Revision 1.5  1991/09/16  05:20:58  bst
 * Return 0 for success rather than result from dat_sendmsg()
 *
 * Revision 1.4  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.3  1991/08/23  16:00:16  bst
 * Changed dat_sendmsg() interface.
 *
 * Revision 1.2  1991/08/05  19:12:46  bst
 * Changed name of include file to 'initiator.mac.h'
 *
 * Revision 1.1  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include "naversion.h"
#include "libdefs.h"
#include "defaults.h"
#include "debug.h"
#ifdef macintosh
#include "initiator.mac.h"
#else /* macintosh */
#ifdef MSDOS
#include "aspi_io.h"
#endif /* MSDOS */
#endif /* macintosh */

int autoStatus[MAXDTFD] = {0};

#ifdef __sgi
int lastDirection[MAXDTFD] = {0};
#endif /* __sgi */
long bytesSinceRewind[MAXDTFD] = {0};

dat_fd dat_open_nrl(unit,devname)
int unit;
const char *devname;
{
#ifdef macintosh
#ifdef PRAGMA_UNUSED
#pragma unused(devname)
#endif /* PRAGMA_UNUSED */
    byte inqdata[36];
#endif /* macintosh */
    dat_fd dt;

#ifndef macintosh
    if (devname == 0) {
	char defaultDevice[20],devDef[20];
	if (unit == -1) 
	    unit = GetIntDefault("unit",0);
    
	Debug("libdatlink.open",3,"Unit = %d\n",unit);
	sprintf(defaultDevice,"/dev/datlink%d",unit);
	sprintf(devDef,"%d.Device",unit);
	devname = GetDefault(devDef,defaultDevice);
    }
#ifdef MSDOS
    dt = aspiopen((char *)devname,O_RDWR|O_BINARY,0644);
#else
    dt = open(devname,O_RDWR|O_BINARY);
#endif
    Debug("libdatlink.open",3,"Device = %s,dt=%d\n",devname,dt);
    if (dt < 0) {
	NALog(LOG_ERR,"Failed open of %s: %s\n",devname,NAsyserr());
	return dt;
    }
#else /* macintosh */
    if (unit == -1)  {
	if (getenv("DL_UNIT"))
	    unit = atoi(getenv("DL_UNIT"));
	else
	    unit = GetIntDefault("unit",0);
    }

    Debug("libdatlink.open",3,"Unit = %d\n",unit);
    dt = unit;
    if (!TestUnitReady(unit,0)) {
	NALog(LOG_ERR,"Unable to connect to DAT-Link at target ID %d.\n",unit);
	exit(1);
    }		
    if (Inquiry(unit,0,inqdata,sizeof(inqdata)) < 0) {
	NALog(LOG_ERR,"Unable to get Inquiry data from DAT-Link.\n");
	exit(1);
    }
	if ((strncmp((char *)&inqdata[8],"TCT     ",8) != 0) &&
	    (strncmp((char *)&inqdata[8],"ARCHIVE ",8) != 0)) {
	NALog(LOG_ERR,"Device at target %d is '%.24s', not a DAT-Link\n",
		unit, &inqdata[8]);
	exit(1);
    }
#endif /* macintosh */
    
#ifdef __sgi
    lastDirection[dt] = -1;
#endif
    bytesSinceRewind[dt] = 0;

    return dt;
}


extern const char *dat_FirmwareRootName;

dat_fd dat_open(unit,devname)
int unit;
const char *devname;
{
    dat_fd dt = dat_open_nrl(unit,devname);
    int reloaded;
    int firmware;

    if (dt < 0)
	return -1;

    /* Try reloading firmware */
    if ((reloaded = dat_reload(dt)) < 0)
	NALog(LOG_WARNING,"Unable to reload firmware - using running version.\n");
    
    if (reloaded >= 1) {
	/* Software was reloaded */
	if ((dt = dat_open_nrl(unit,devname)) < 0)
	    return -1;
    }

    if (reloaded == 2) {
	    /* DAT-Link was cold-booted, re-open it and try again */
	if ((reloaded = dat_reload(dt)) != 1) {
	    NALog(LOG_ERR,"Firmware reload failed\n");
	    return -1;
	}
	if ((dt = dat_open_nrl(unit,devname)) < 0)
	    return -1;
    }

    /* Check if firmware revision matches expected revision */
    firmware = dat_version(dt)%1000;
    if ((FirmwareRevision != firmware) && (*dat_FirmwareRootName == 0)) {
	NALog(LOG_WARNING,"DAT-Link is running embedded software version V%d; expected V%d.\n", firmware, FirmwareRevision);
	NALog(LOG_WARNING,"         Check NetAudio software installation (etc/dl/Version).\n");
    }

    /* Clear out buffers */
    if (dat_reset(dt) < 0)
	return -1;
    
    return dt;
}

/* Clear inputs buffers and put DAT-Link into idle state 
 */
int dat_clearTransfers(dt)
dat_fd dt;
{
    int dlstat = dat_sendmsg(dt,DL_CLEARTRANSFERS,0,0,0,0);
    if (dlstat < 0)
	Debug("libdatlink.clearTransfers",1,
	      "Error while sending CLEARTRANSFERS message\n");
    return dlstat;
}


/* Reset DAT-Link
 */
int dat_reset(dt)
dat_fd dt;
{
    int dlstat = dat_sendmsg(dt,DL_RESET,0,0,0,0);
    if (dlstat < 0)
	Debug("libdatlink.reset",1,"Error while sending RESET message\n");
    if ((dt < 0) || (dt >= MAXDTFD)) {
	NALog(LOG_ERR,"File description for DAT-Link (%d) out of range 0-%d\n",
	      dt, MAXDTFD-1);
	return -1;
    }
    autoStatus[dt] = 0;
    return (dlstat>=0)?0:-1;
}

/*
 * Begin transferring between DAT and DAT-Link internal memory
 */
int dat_beginIO(dt,rd,wr)
dat_fd dt;
int rd,wr;
{
    if (rd && wr) {
	if (dat_version(dt)/1000 <= 14) {
	    Debug("libdatlink.beginIO",1,
		  "Attempt to do bidirectional I/O on HW rev %.1f\n",
		  (dat_version(dt)/1000)/10.0);
	    dat_errno = EDLDIRECTION;
	    return -1;
	}
	return dat_sendmsg(dt,DL_BEGINIO,0,0,0,0);
    }
    else if (rd)
	return dat_sendmsg(dt,DL_BEGINREAD,0,0,0,0);
    else if (wr)
	return dat_sendmsg(dt,DL_BEGINWRITE,0,0,0,0);
    return 0;
}

