/* $Id: mode.c,v 1.38 1993/08/11 21:10:51 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:12 EDT 1991
 *
 * Revision History: $Log: mode.c,v $
 * Revision 1.38  1993/08/11  21:10:51  bst
 * Changed autoStatus to an array.
 *
 * Revision 1.37  1993/08/10  02:05:17  bst
 * Moved abs() macro to support.h
 *
 * Revision 1.36  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.35  1993/06/09  14:12:25  bst
 * Added coercion.
 *
 * Revision 1.34  1993/05/21  16:13:14  bst
 * Generalized dat_mode() to handle additional mode types.
 * Added dat_setAutoStatus()
 *
 * Revision 1.33  1993/04/12  02:04:00  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.32  1993/03/24  19:37:16  bst
 * Check if abs() is already defined.
 *
 * Revision 1.31  1993/03/15  20:33:01  bst
 * Change dat_getErrorLog() to use a buffer passed to it as an arg.
 *
 * Revision 1.30  1993/03/01  03:59:42  bst
 * Use malloc() instead of static storage for buffers.
 *
 * Revision 1.29  1992/12/20  15:50:16  bst
 * Added coercion for native C compiler.
 *
 * Revision 1.28  1992/11/21  03:10:35  bst
 * Added dat_getErrorLog().
 *
 * Revision 1.27  1992/09/09  04:05:42  bst
 * Moved dat_dspSetSIOMode() here from dsp.c so it won't require libsconv.a
 *
 * Revision 1.26  1992/07/12  15:50:55  bst
 * Added dat_setDiagnostic().
 *
 * Revision 1.25  1992/07/05  03:05:20  bst
 * Added 'todat' arg to dat_setMode.
 * Changed interface to DL_SETMODE directive.
 * Removed 'dat_currentMode' variable.
 * Removed 'dat_getMode()' function - use dat_getStatus().
 *
 * Revision 1.24  1992/01/27  03:54:55  bst
 * Move dat_getDSPProgram() to dsp.c
 * dat_setMode() no longer sets DSP program.
 *
 * Revision 1.23  1991/12/17  04:44:27  bst
 * Added more args to BuildConverter(), dat_getDSPProgram()
 *
 * Revision 1.22  1991/12/12  04:34:36  bst
 * Use dat_loadDSPProgram()
 * Reorganization of dsp_setMode().
 *
 * Revision 1.21  1991/12/08  20:26:42  bst
 * Fixed bug in checking hardware revision number.
 * Added debug messages.
 *
 * Revision 1.20  1991/12/06  05:57:45  bst
 * Use FIX program if datrate is within 1 sample/sec of hostrate
 * Don't give an error if MODE_CONVERT is set along with other MODE bits.
 *
 * Revision 1.19  1991/12/05  02:14:35  bst
 * Changed name of FIX_y and FIX_c to FIXy and FIXc
 * Added call to DL_SETDSPADDRS after loading a DSP program.
 *
 * Revision 1.18  1991/11/22  05:06:31  bst
 * Moved DSP filter design out of dat_setMode() and into dat_getDSPProgram()
 *
 * Revision 1.17  1991/11/14  05:38:36  bst
 * Added global variable 'dat_dspProgram'
 * Set dat_dspProgram while loading new program.
 *
 * Revision 1.16  1991/11/14  01:03:15  bst
 * Rename dsp read/write functions.
 *
 * Revision 1.15  1991/11/12  05:43:32  bst
 * No longer need to pass 'atten' to BuildConverter.
 *
 * Revision 1.14  1991/11/11  04:24:00  bst
 * Workaround for warnings about assertions with no effect.
 * Use new Debug() routine.
 *
 * Revision 1.13  1991/10/28  23:26:28  bst
 * Removed extra spaces.
 *
 * Revision 1.12  1991/10/25  03:37:48  bst
 * Made indep. of host byte-order.
 * Use byte transfers for dsp_write()
 *
 * Revision 1.11  1991/10/20  20:08:02  bst
 * Use DL_DSPHALT to force halt of DSP.
 *
 * Revision 1.10  1991/10/20  18:24:12  bst
 * Pass hardware revision to BuildConverter()
 * If the DSP is not halted, wait a bit and try again (let buffers drain).
 *
 * Revision 1.9  1991/10/04  02:14:06  bst
 * Made 'atten' into double as it always should have been.
 * If DSP is running and it's an old ROM revision of the DAT-Link,
 *     write illegal op-codes into DSP to force it to halt.
 *
 * Revision 1.8  1991/09/29  06:49:11  bst
 * Check if MODE_CONVERT conflicts with other mode bits.
 * Check if DAT srate is a reasonable value.
 * Don't bother verifying that the DSP is halted, things seem to be OK anyway.
 *
 * Revision 1.7  1991/09/27  17:54:31  bst
 * Make sure transferStatus is IDLE before allowing mode change.
 *
 * Revision 1.6  1991/09/27  14:45:02  bst
 * Added sample rate conversion to dat_mode()
 *
 * Revision 1.5  1991/09/16  05:20:51  bst
 * Changed some function names to make them more consistent.
 *
 * Revision 1.4  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.3  1991/08/23  16:00:16  bst
 * Changed dat_sendmsg() interface.
 *
 * Revision 1.2  1991/08/05  19:12:46  bst
 * Added include of dsp_mode.h
 *
 * Revision 1.1  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include <assert.h>
#include "libdefs.h"

/* Set mode bits */
int dat_setMode(dt,mcode,newmode)
dat_fd dt;
int mcode;
int newmode;
{
    DL_Status stat;
    byte buf[5];

    if ((mcode == MODE_FROMDAT) || (mcode == MODE_TODAT)) {
	if (newmode & ~MODE_SELECTABLE) {
	    dat_errno = EDLBADMODE;
	    return -1;
	}
	
	if (dat_getStatus(dt,&stat) < 0)
	    return -1;
	
	if ((mcode?stat.pb.transferStatus:stat.rec.transferStatus) != 0) {
	    dat_errno = EDLNOTIDLE;
	    return -1;
	}
    }

    buf[0] = mcode;
    buf[1] = (((unsigned int32)newmode)>>24)&0xff;
    buf[2] = (((unsigned int32)newmode)>>16)&0xff;
    buf[3] = (newmode>>8)&0xff;
    buf[4] = newmode&0xff;
    if (dat_sendmsg(dt,DL_SETMODE,sizeof(buf),buf,0,0) < 0)
	return -1;

    return 0;
}

/*
 * Set AutoStatus mode
 */
int dat_setAutoStatus(dt,enable)
dat_fd dt;
int enable;
{
    int result;

    if ((dt < 0) || (dt >= MAXDTFD)) {
	NALog(LOG_ERR,"File description for DAT-Link (%d) out of range 0-%d\n",
	      dt, MAXDTFD-1);
	return -1;
    }
    if (autoStatus[dt] == enable)
	return 0;

    if (dat_version(dt)%1000 < 44) {
	NALog(LOG_ERR,"Attempt to set autoStatus mode with old firmware (V%d)\n",
		dat_version(dt)%1000);
	return -1;
    }
    result = dat_setMode(dt,MODE_AUTOSTATUS,enable);
    if (result == 0)
	autoStatus[dt] = enable;
    else
	autoStatus[dt] = -1;
    return result;
}

int dat_setDiagnostic(dt,diagnostic,value)
dat_fd dt;
int diagnostic;
int value;
{
    byte buf[2];
    buf[0] = diagnostic;
    buf[1] = value;
    if (dat_sendmsg(dt,DL_DIAGNOSTICS,sizeof(buf),buf,0,0) < 0)
	return -1;
    return 0;
}

int dat_getErrorLog(dt,buf,buflen)
dat_fd dt;
char *buf;
unsigned int buflen;
{
    if (buflen > DL_MAXREPLYLEN)
	buflen = DL_MAXREPLYLEN;
    return dat_sendmsg(dt,DL_GET_ERRLOG,0,0,buflen,(byte *)buf);
}

int dat_dspSetSIOMode(dt,siomode)
dat_fd dt;
int siomode;
{
    byte buf = siomode;
    if (dat_sendmsg(dt,DL_SETSIOMODE,1,&buf,0,0) < 0)
	return -1;
    return 0;
}
