/* $Id: libdefs.h,v 1.34 1995/03/15 23:58:32 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:38 EDT 1991
 *
 * Revision History: $Log: libdefs.h,v $
 * Revision 1.34  1995/03/15  23:58:32  bst
 * Added bytesSinceRewind.
 *
 * Revision 1.33  1994/03/07  18:29:42  bst
 * Always call dat_SetDirection().
 *
 * Revision 1.32  1993/10/04  18:10:10  bst
 * Added lastDirection[].
 *
 * Revision 1.31  1993/08/27  00:32:23  bst
 * Removed micro_time()
 *
 * Revision 1.30  1993/08/11  21:10:44  bst
 * Made autoStatus an array
 *
 * Revision 1.29  1993/08/10  02:04:57  bst
 * Moved dat_seteAutoStatus() to datlink.h
 *
 * Revision 1.28  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.27  1993/06/12  20:45:42  bst
 * Added dat_SetDirection().
 *
 * Revision 1.26  1993/05/21  16:12:55  bst
 * Added dat_setAutoStatus(), dat_convertStatus(), autoStatus.
 *
 * Revision 1.25  1993/04/22  03:12:46  bst
 * Added micro_time() declaration.
 * Include dos.h under MSDOS.
 *
 * Revision 1.24  1993/04/12  02:03:53  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.23  1992/11/04  04:34:46  bst
 * Moved DSPFloat(), NativeFloat() to libsupport/dspfloat.c
 *
 * Revision 1.22  1992/10/04  17:18:03  bst
 * Changed declarations of NativeFloat(), DSPFloat() to use 'dsp32float' type.
 *
 * Revision 1.21  1992/07/05  03:05:06  bst
 * Removed 'dat_currentMode' external variable.
 *
 * Revision 1.20  1992/06/27  22:15:56  bst
 * Removed global dat_* variables.
 *
 * Revision 1.19  1992/05/20  01:45:31  bst
 * Added dat_closefast()
 *
 * Revision 1.18  1992/05/20  00:20:53  bst
 * Added RAMExecution, Emulation, SSCSISwitchSetting, DIPSwitchSetting vars.
 *
 * Revision 1.17  1992/02/11  18:14:52  bst
 * Added declarations of NativeFloat(), DSPFloat()
 *
 * Revision 1.16  1992/02/08  03:08:30  bst
 * Used P() macro
 * Remove dat_str*casecmp()
 *
 * Revision 1.15  1992/01/27  06:18:41  bst
 * Include sysdefs.h earlier.
 *
 * Revision 1.14  1991/12/06  06:00:12  bst
 * Use sysdefs.h
 * Include debug.h
 *
 * Revision 1.13  1991/12/05  18:52:54  bst
 * Added declaration of memcmp()
 *
 * Revision 1.12  1991/11/14  01:03:06  bst
 * Added dat_versionNumber global variable.
 *
 * Revision 1.11  1991/11/11  04:23:45  bst
 * Added dat_strcasecmp() and dat_strncasecmp()
 *
 * Revision 1.10  1991/11/08  21:29:24  bst
 * Added declarations of bzero(), time(), and ctime().
 *
 * Revision 1.9  1991/10/24  22:31:48  bst
 * Added definition of DSEP, the pathname separator.
 *
 * Revision 1.8  1991/10/20  18:27:28  bst
 * Added declarations of fread() and dat_reload()
 *
 * Revision 1.7  1991/10/04  02:15:38  bst
 * Added defn of fflush()
 *
 * Revision 1.6  1991/09/27  14:49:39  bst
 * Added prototypes for dat_writeany() and dat_readany().
 * Added global variable 'dat_currentMode'.
 *
 * Revision 1.5  1991/09/12  03:03:30  bst
 * Fixed handling of prototypes and include files for non-ANSI compilers.
 * Added non-ANSI declarations of getenv() and malloc().
 *
 * Revision 1.4  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.3  1991/08/23  16:01:50  bst
 * Added host_if.h
 *
 * Revision 1.2  1991/08/05  19:12:46  bst
 * Added include of dat_errno.h
 *
 * Revision 1.1  1991/08/05  06:04:41  bst
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include "sysdefs.h"

#include "datlink.h"
#include "dat_errno.h"
#include "host_if.h"
#include "dsp_mode.h"
#include "debug.h"

extern int dat_closefast P((dat_fd));
extern int32  dat_writeany P((dat_fd,const byte*,int32));
extern int32 dat_readany P((dat_fd,byte*,int32));
extern int dat_reload P((dat_fd));
extern void dat_convertStatus P((DL_Status *stat));
void dat_SetDirection P((dat_fd dt,int todatlink,int32 nbytes));

#define MAXDTFD 100
extern int autoStatus[MAXDTFD];
#ifdef __sgi
extern int lastDirection[MAXDTFD];
#endif
/* Number of bytes read/written since last rewind */
extern long bytesSinceRewind[MAXDTFD];

#ifdef MSDOS
#include <dos.h>	/* For declaration of sleep() */
#endif /* MSDOS */

#ifdef macintosh
#define DSEP ':'
#else
#define DSEP '/'
#endif
