/* $Id: dsprw.c,v 1.14 1993/08/10 02:04:28 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:10 EDT 1991
 *
 * Revision History: $Log: dsprw.c,v $
 * Revision 1.14  1993/08/10  02:04:28  bst
 * Moved min() macro to support.h
 * Changed some int's to u_int's
 *
 * Revision 1.13  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.12  1993/06/01  02:44:18  bst
 * Added coercions for GCC 2.4.1 unsigned 'size_t'.
 *
 * Revision 1.11  1993/05/18  19:40:24  bst
 * Use NALog() to log/print errors and warnings.
 *
 * Revision 1.10  1993/04/12  02:03:35  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.9  1993/03/01  03:58:55  bst
 * Use malloc() instead of static storage for buffers.
 *
 * Revision 1.8  1992/12/17  04:40:38  bst
 * Don't exit if a write to DSP fails, just return error code.
 *
 * Revision 1.7  1992/11/04  04:34:30  bst
 * Moved DSPFloat(), NativeFloat() to libsupport/dspfloat.c
 *
 * Revision 1.6  1992/10/04  17:17:51  bst
 * Use host byte-order for DSP floating points stored in ints.
 *
 * Revision 1.5  1992/08/19  00:21:17  bst
 * Don't use 'u_int'; it's not declared on mac.
 *
 * Revision 1.4  1992/07/09  21:34:01  bst
 * Break reads from DSP using DL_MAXREPLYLEN.
 * Allow DSP writes of any length.
 *
 * Revision 1.3  1992/06/27  22:15:32  bst
 * Use 32 bit DSP address
 *
 * Revision 1.2  1992/05/01  17:05:31  bst
 * Make sure write command is not longer than max message lenght
 *
 * Revision 1.1  1992/03/06  01:24:21  bst
 * Initial revision
 *
 * Revision 1.18  1992/01/30  06:08:55  bst
 * Set impulse response to 1,0,0,... if no conversion is done.
 * Fixed up a possible pointer alignment problem.
 *
 * Revision 1.17  1992/01/28  05:48:34  bst
 * Added impulse response parameters as parameters.
 *
 * Revision 1.16  1992/01/27  03:54:37  bst
 * Moved dat_getDSPProgram() here from mode.c
 *
 * Revision 1.15  1992/01/11  16:18:13  bst
 * Fixed DSPFloat debug message to print correct floating point value
 *
 * Revision 1.14  1991/12/17  02:52:07  bst
 * Removed 'dat_dspProgram' global variable.
 * Moved NativeFloat() and DSPFloat() here from status.c
 * Added dat_dspGetFloat() and dat_dspSetFloat()
 * Added 'pgm' arg to dat_dsp{Get,Set}Parameter()
 *
 * Revision 1.13  1991/12/16  00:33:46  bst
 * Added defaultProgram variable to fix problem with extra delete of programs.
 *
 * Revision 1.12  1991/12/12  04:35:51  bst
 * Added dat_dspLoadProgram() (Extracted from mode.c)
 *
 * Revision 1.11  1991/12/08  20:27:11  bst
 * Removed include of memory.h
 *
 * Revision 1.10  1991/12/06  05:58:39  bst
 * More coercions before shifting.
 *
 * Revision 1.9  1991/12/05  18:49:39  bst
 * Coerce bytes to unsigned int before shifting to form a word
 *
 * Revision 1.8  1991/11/14  05:37:59  bst
 * Added dat_dspGetParameter() and dat_dspSetParameter().
 * Added global variable 'dat_dspProgram'
 *
 * Revision 1.7  1991/11/14  01:01:52  bst
 * Renamed 'dsp_write'->dat_dspWrite and 'dsp_read'->'dat_dspRead'
 * Added dat_dspGetParams()
 * Removed dsp_getpcr and dsp_setpcr
 *
 * Revision 1.6  1991/11/04  02:10:05  bst
 * Fixed bug which was overrunning memory while byte-swapping.
 *
 * Revision 1.5  1991/10/25  03:36:42  bst
 * Made indep. of host byte-order.
 * Went back to byte transfers for dsp_write() and dsp_read() (but only even cnts)
 * dsp_write() and dsp_read() now word with data in DSP32c byte-order, indep.
 *     of host byte-order.
 *
 * Revision 1.4  1991/09/12  04:48:56  bst
 * Fixed problem with too many local variables on Alliant.
 *
 * Revision 1.3  1991/09/09  04:53:06  bst
 * Changed lowlevel interface to dsp_write().
 *
 * Revision 1.2  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.1  1991/08/05  06:06:53  bst
 * Initial Revision
 */
#include <math.h>
#include "libdefs.h"
#include "host_if.h"
#include "support.h"

/* Read DSP32 memory */
int dat_dspRead(dt,dspAddr,buffer,nbytes)
dat_fd dt;
unsigned int32 dspAddr;
byte *buffer;
unsigned int nbytes;
{
    int result = 0;
    byte tbuf[6];
    unsigned int i;
    unsigned int nremain = nbytes;
    byte *bptr = buffer;

    if (nbytes & 1) {
	NALog(LOG_WARNING,
	      "dat_dspRead: Can't read odd number of bytes: %d\n",nbytes);
	exit(1);
    }

    while (nremain) {
	unsigned int tlen = min(nremain,DL_MAXREPLYLEN);
	tbuf[0] = ((tlen/2)>>8)&0xff;
	tbuf[1] = (tlen/2)&0xff;
	tbuf[2] = (dspAddr>>24)&0xff;
	tbuf[3] = (dspAddr>>16)&0xff;
	tbuf[4] = (dspAddr>>8)&0xff;
	tbuf[5] = dspAddr&0xff;
	result= dat_sendmsg(dt,DL_DSPREAD,sizeof(tbuf),tbuf,tlen,bptr);
	if (result < 0)
	    break;
	nremain -= tlen;
	dspAddr += tlen;
	bptr += tlen;
    }

    /* Swap bytes in buffer */
    for (i=0;i<nbytes;i+=2) {
	byte tmp = buffer[i];
	buffer[i] = buffer[i+1];
	buffer[i+1] = tmp;
    }
    return result;
}

/* Write DSP32 memory */
int dat_dspWrite(dt,dspAddr,buffer,nbytes)
dat_fd dt;
unsigned int32 dspAddr;
const byte *buffer;
unsigned int nbytes;
{
    byte *tbuf = 0;
    int i;
    unsigned int nremain = nbytes;
    int result = 0;

    while (nremain) {
	size_t tlen = min(nremain,DL_MAXMSGLENGTH-DL_HEADER_LEN-6);
	if (tlen == 1) {
	    NALog(LOG_WARNING,
		    "dat_dspWrite: Can't write odd number of bytes: %d\n",nbytes);
	    result = -1;
	    break;
	}
	tlen &= ~1;
	if (tbuf == 0) 
	    tbuf = (byte *)malloc(tlen+6);
	tbuf[0] = ((tlen/2)>>8)&0xff;
	tbuf[1] = (tlen/2)&0xff;
	tbuf[2] = (dspAddr>>24)&0xff;
	tbuf[3] = (dspAddr>>16)&0xff;
	tbuf[4] = (dspAddr>>8)&0xff;
	tbuf[5] = dspAddr&0xff;
	
	/* Swap bytes to transfer to DAT-Link */
	for (i=0;i<tlen;i+=2) {
	    tbuf[i+6] = buffer[i+1];
	    tbuf[i+7] = buffer[i];
        }
	
	result = dat_sendmsg(dt,DL_DSPWRITE,(unsigned int)tlen+6,tbuf,0,0);
	if (result < 0)
	    break;
	nremain -= tlen;
	dspAddr += tlen;
	buffer += tlen;
    }
    if (tbuf)
	free(tbuf);
    return result;
}
