/* $Id: cubits.c,v 1.10 1993/06/23 20:08:03 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:08 EDT 1991
 *
 * Revision History: $Log: cubits.c,v $
 * Revision 1.10  1993/06/23  20:08:03  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.9  1993/04/12  02:02:39  bst
 * Use long when 32-bit integers required.
 * Use 'unsigned int' instead of 'int' in dat_setU().
 *
 * Revision 1.8  1992/04/06  21:54:30  bst
 * Added coercion to match prototype.
 *
 * Revision 1.7  1991/12/08  20:27:05  bst
 * Removed include of memory.h
 *
 * Revision 1.6  1991/11/11  04:22:48  bst
 * Kludge to avoid warnings about assertions with no effect.
 *
 * Revision 1.5  1991/10/25  03:36:27  bst
 * Made indep. of host byte-order.
 *
 * Revision 1.4  1991/09/12  03:01:51  bst
 * Don't need to include malloc.h (it's defined in libdefs.h)
 *
 * Revision 1.3  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.2  1991/08/23  16:02:07  bst
 * Changed interface to get/set C/U routines.
 *
 * Revision 1.1  1991/08/05  06:06:53  bst
 * Initial Revision
 *
 *
 */
#include <assert.h>
#include "libdefs.h"

/* Get current value of U data, return actual number received */
int dat_getU(dt,udat,nalloc)
dat_fd dt;
byte *udat;
unsigned int nalloc;
{
    byte buffer[4];
    int x;

    assert((x=sizeof(buffer)) == sizeof(nalloc));
    buffer[0] = ((unsigned int32)nalloc)>>24;
    buffer[1] = (((unsigned int32)nalloc)>>16)&0xff;
    buffer[2] = (nalloc>>8)&0xff;
    buffer[3] = nalloc&0xff;
    return dat_sendmsg(dt,DL_GETU,sizeof(buffer),buffer,nalloc,udat);
}

/* Set U data, "udat" is a pointer to nbytes bytes of data */
int dat_setU(dt,udat,nbytes)
dat_fd dt;
const byte *udat;
unsigned int nbytes;
{
    return dat_sendmsg(dt,DL_SETU,nbytes,udat,0,0);
}

/* Get current value of C data */
int dat_getC(dt,cdat)
dat_fd dt;
byte cdat[48];
{
    return dat_sendmsg(dt,DL_GETC,0,0,48,cdat);
}

/* Set C data */
int dat_setC(dt,cdat)
dat_fd dt;
const byte cdat[48];
{
    return dat_sendmsg(dt,DL_SETC,48,(byte *)cdat,0,0);
}
