/* $Id: close.c,v 1.10 1993/03/01 04:50:51 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 02:03:06 EDT 1991
 *
 * Revision History: $Log: close.c,v $
 * Revision 1.10  1993/03/01  04:50:51  bst
 * Use aspiclose() instead of close() unser DOS.
 *
 * Revision 1.9  1993/02/05  22:01:20  bst
 * Use PRAGMA_UNUSED instead of UNUSED macro.
 *
 * Revision 1.8  1993/02/05  20:37:28  bst
 * Added UNUSED() macro call for ununused parameters to functions.
 *
 * Revision 1.7  1992/05/20  01:45:17  bst
 * Added dat_closefast() to just close the DAT-Link.
 *
 * Revision 1.6  1992/05/12  18:49:51  bst
 * NeXT seems to always return EPERM from close() - workaround.
 *
 * Revision 1.5  1992/02/11  18:13:56  bst
 * Don't declare 'ecode' on Mac
 *
 * Revision 1.4  1991/11/14  05:35:50  bst
 * Call dat_clearTransfers() before closing.
 *
 * Revision 1.3  1991/11/11  04:21:01  bst
 * Use new Debug() procedure.
 *
 * Revision 1.2  1991/08/23  23:50:52  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.1  1991/08/05  06:06:53  bst
 * Initial Revision
 */
#include "libdefs.h"
#ifdef MSDOS
#include "aspi_io.h"
#endif

int dat_close(dt)
int dt;
{
    if (dat_clearTransfers(dt) < 0) {
	dat_closefast(dt);
	return -1;
    }
    return dat_closefast(dt);
}

int dat_closefast(dt)
int dt;
{
#ifdef macintosh
#ifdef PRAGMA_UNUSED
#pragma unused(dt)
#endif /* PRAGMA_UNUSED */
    return 0;
#else /* macintosh */
#ifdef MSDOS
    int ecode = aspiclose(dt);
#else
    int ecode = close(dt);
#endif
#ifdef NeXT
    if ((ecode < 0) && (errno == EPERM))
	ecode = 0;
#endif /* NeXT */
    if (ecode < 0)
	Debug("libdatlink.close",1,"Error closing DAT-Link (dt=%d,errno=%d)\n",
	   dt,errno);
    return ecode;
#endif /* macintosh */
}
