/* $Id: sysdefs.h,v 1.62 1996/03/21 18:29:09 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Thu Dec 5 23:24:21 EST 1991
 *
 * Revision History: $Log: sysdefs.h,v $
 * Revision 1.62  1996/03/21  18:29:09  bst
 * Always include string.h (if it exists)
 *
 * Revision 1.61  1996/03/19  19:13:14  eryk
 * Removed declaration of errno under DOS (Borland has a macro for errno)
 *
 * Revision 1.60  1994/11/17  01:19:31  bst
 * Added NEEDS_NETDB support.
 *
 * Revision 1.59  1994/05/12  03:01:34  bst
 * Include string.h if bzero is defined.
 *
 * Revision 1.58  1994/04/14  19:20:42  bst
 * Use HAS_stdarg instead of HAS_stdarg_h
 *
 * Revision 1.57  1994/03/04  15:23:49  bst
 * Use HAS_*_h to determine if mem.h and io.h should be included.
 * Always declare chk_malloc()
 *
 * Revision 1.56  1994/02/02  21:06:28  bst
 * Moved malloc() definition after include of malloc header files.
 *
 * Revision 1.55  1993/11/19  03:13:58  bst
 * Define malloc() as chk_malloc().
 * Added include of fcntl.h
 *
 * Revision 1.54  1993/11/16  01:49:19  bst
 * Moved EAGAIN/EWOULDBLOCK handling here.
 * Don't include sys/types.h on mac.
 *
 * Revision 1.53  1993/10/05  14:50:51  bst
 * Only include sgtty.h if noecho() is a macro.
 *
 * Revision 1.52  1993/10/05  00:57:49  bst
 * Moved 'const' define to dat_types.h
 *
 * Revision 1.51  1993/09/17  13:16:49  bst
 * Added NEEDS_CURSES sectoin.
 * Undefine compatibility macros defined in curses.h
 *
 * Revision 1.50  1993/08/31  17:30:33  bst
 * Undefine size if its defined in macros.h
 *
 * Revision 1.49  1993/08/31  17:21:28  bst
 * Inlude sys/timers.h if needed.
 * Undefine length if its defined in macros.h
 *
 * Revision 1.48  1993/08/30  18:01:22  bst
 * Removed include of config.h
 *
 * Revision 1.47  1993/08/27  00:44:53  bst
 * Modified fro use with SysConfig.
 *
 *
 */

#ifndef DAT_SYSDEFS_H
#define DAT_SYSDEFS_H
#include "pmacro.h"
#include "dat_types.h"
#include <stdio.h>
#include <fcntl.h>
#ifndef macintosh
#include <sys/types.h>
#endif /* !macintosh */
#include <errno.h>

#ifndef MSDOS
extern int errno;  /* Some machines don't define this in errno.h */
#endif

/* Add some consistency to EAGAIN/EWOULDBLOCK confusion */
#ifdef EWOULDBLOCK
#ifndef EAGAIN
#define EAGAIN EWOULDBLOCK
#endif /* !EAGAIN */
#else /* EWOULDBLOCK */
#ifdef EAGAIN
#define EWOULDBLOCK EAGAIN
#else /* EAGAIN */
#define EAGAIN 0xffff		/* Non-existent */
#define EWOULDBLOCK 0xffff
#endif /* !EAGAIN */
#endif /* !EWOULDBLOCK */

#include "syscap.h"

#ifdef NEEDS_VA
#ifdef HAS_stdarg
#include <stdarg.h>
#else /* HAS_stdarg */
#ifndef MISSING_varargs
#include <varargs.h>
#endif /* !MISSING_varargs */
#endif /* !HAS_stdarg */
#endif /* NEEDS_VA */

#ifdef NEEDS_ASYNCH
#ifdef HAS_sys_asynch_h
#define NEEDS_TIME
#include <sys/asynch.h>
#endif /* HAS_sys_asynch_h */
#endif /* NEEDS_ASYNCH */

#ifdef NEEDS_NETDB
#ifdef HAS_netdb_h
#include <netdb.h>
#endif /* HAS_netdb_h */
#endif /* NEEDS_NETDB */

#ifdef NEEDS_TIME
#ifdef HAS_time_h
#include <time.h>
#endif /* HAS_time_h */
#ifdef HAS_timers_h
#include <timers.h>
#else /* HAS_timers_h */
#ifdef HAS_sys_timers_h
#include <sys/timers.h>
#endif /* HAS_sys_timers_h */
#endif /* !HAS_timers_h */
#ifdef HAS_sys_time_h
#include <sys/time.h>
#endif /* HAS_sys_time_h */
#ifdef HAS_sys_timeb_h
#include <sys/timeb.h>
#endif /* HAS_sys_timeb_h */
#ifdef HAS_sys_resource_h
#include <sys/resource.h>
#endif /* HAS_sys_resource_h */
#ifdef macintosh
#include <Time.h>
#endif /* macintosh */
#endif /* NEEDS_TIME */

#ifdef NEEDS_CURSES
#if defined(HAS_sgtty_h)&&defined(ISMACRO_noecho)
#include <sgtty.h>
#endif /* HAS_sgtty_h && ISMACRO_noecho */
#include <curses.h>

/* Some machines (SGI and Solaris?) hack a few defines in curses.h that are bad */
#if defined(memcpy) && defined(HAS_memcpy) && !defined(ISMACRO_memcpy)
#undef memcpy
#endif /* memcpy && HAS_memcpy && !ISMACRO_memcpy */

#if defined(strchr) && defined(HAS_strchr) && !defined(ISMACRO_strchr)
#undef strchr
#endif /* strchr && HAS_strchr && !ISMACRO_strchr */

#if defined(strrchr) && defined(HAS_strrchr) && !defined(ISMACRO_strrchr)
#undef strrchr
#endif /* strrchr && HAS_strrchr && !ISMACRO_strrchr */

#endif /* NEEDS_CURSES */

#include "sysdecls.h"

#ifdef MSDOS
/* Check for memory overruns */
extern void _FAR *chk_farmalloc P((unsigned long len,char *file, int line));
#endif /* MSDOS */

extern void *chk_malloc P((size_t len,char *file, int line));
extern void *realmalloc P((size_t len));

#ifdef HAS_mem_h
#include <mem.h>
#endif /* HAS_mem_h */
#ifdef HAS_io_h
#include <io.h>
#endif /* HAS_io_h */
#ifdef HAS_stdlib_h
#include <stdlib.h>
#endif /* HAS_stdlib_h */
#ifdef HAS_unistd_h
#include <unistd.h>
#endif /* HAS_unistd_h */
#ifdef HAS_malloc_h
#include <malloc.h>
#endif /* HAS_malloc_h */
#ifdef HAS_macros_h
#include <macros.h>
#ifdef length
#undef length
#endif /* length */
#ifdef size
#undef size
#endif /* size */
#endif /* HAS_macros_h */
#ifdef HAS_getopt_h
#include <getopt.h>
#endif /* HAS_getopt_h */
#ifdef HAS_memory_h
#include <memory.h>
#endif /* HAS_memory_h */

#ifdef HAS_string_h
#include <string.h>
#endif /* HAS_string_h */

#ifdef HAS_bzero
#ifdef HAS_bstring_h
#include <bstring.h>
#endif /* HAS_bstring_h */
#else /* HAS_bzero */
#define bzero(p,n) memset(p,0,n)
#endif /* !HAS_bzero */

#if defined(macintosh) || defined(MSDOS)
/* Suppressed unused parameter warnings */
#define PRAGMA_UNUSED
#endif /* macintosh || MSDOS */

#ifndef HAS_tell
#define tell(fd) lseek(fd,0L,1)
#endif /* !HAS_tell */

#ifndef O_BINARY
#define O_BINARY 0
#endif /* !O_BINARY */

#define malloc(x) chk_malloc(x,__FILE__,__LINE__)
#endif /* !DAT_SYSDEFS_H */
