/* $Id: support.h,v 1.21 1994/04/25 20:28:21 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Sep 16 20:05:30 EDT 1992
 *
 * Revision History: $Log: support.h,v $
 * Revision 1.21  1994/04/25  20:28:21  bst
 * Changed GetRateFromCS() arg to unsigned char.
 *
 * Revision 1.20  1994/03/07  18:26:26  bst
 * Added labs().
 *
 * Revision 1.19  1993/12/09  19:40:21  bst
 * Added parens to BytesToSamples(), SamplesToBytes() macros.
 *
 * Revision 1.18  1993/11/01  22:15:53  bst
 * Added GetRateFromCS()
 *
 * Revision 1.17  1993/10/26  16:14:55  bst
 * Changed 2rd arg to longread(), longwrite() to unsigned.
 *
 * Revision 1.16  1993/10/06  03:31:51  bst
 * Include machine/ndian.h if it exists.
 *
 * Revision 1.15  1993/10/05  21:42:53  bst
 * Use SysConfig defines for hton*, ntoh*
 *
 * Revision 1.14  1993/10/05  14:50:11  bst
 * Pass args to ntohs(), htons() as int (in case non-ANSI compiler)
 *
 * Revision 1.13  1993/09/13  02:23:21  bst
 * Added swapBytes()
 *
 * Revision 1.12  1993/09/11  14:12:19  bst
 * Only delete ntoh* calls if we know the machine.
 *
 * Revision 1.11  1993/08/27  00:45:14  bst
 * Use HAS_* defines.
 * Don't define ntohl if it is already defined as a macro.
 *
 * Revision 1.10  1993/08/10  01:59:05  bst
 * Added ntoh*(), hton*(), Swap*() prototypes.
 * Added min,max,abs,round macros.
 * Fixed test of SIZEOF_INT
 *
 * Revision 1.9  1993/07/08  13:18:57  bst
 * Added BytesToSamples(), SamplesToBytes() macros.
 *
 * Revision 1.8  1993/06/25  14:35:44  bst
 * Added check for DAT_SUPPORT_H
 *
 * Revision 1.7  1993/06/23  20:32:48  bst
 * Changed 'long' to 'int32'
 * Define long* as base functions if sizeof(int)==32
 *
 * Revision 1.6  1993/04/22  03:09:27  bst
 * Moved P() macro to pmacro.h
 * Use ANSI declaration for functions with no args.
 *
 * Revision 1.5  1993/04/12  02:26:55  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.4  1992/11/04  04:32:29  bst
 * Added NativeFloat(), DSPFloat().
 * Use P() macro.
 *
 * Revision 1.3  1992/10/31  23:04:48  bst
 * Made num_parse() return double.
 *
 * Revision 1.2  1992/10/30  23:04:19  bst
 * Added declarations of num_*() routines.
 *
 * Revision 1.1  1992/09/17  00:25:12  bst
 * Initial revision
 *
 */
#ifndef DAT_SUPPORT_H
#define DAT_SUPPORT_H
#include "pmacro.h"
#include "dat_types.h"
#include "syscap.h"

/* These macros are written to avoid overflowing if b*8 >MAXINT or s*ss>MAXINT */
#define BytesToSamples(b,ss) ((b)/(ss)*8+((b)%(ss))*8/(ss))
#define SamplesToBytes(s,ss) ((s)/8*(ss)+((s)%8)*(ss)/8)

extern void swapBytes P((byte *data, int32 nbytes));
extern unsigned int GetRateFromCS P((unsigned char cstatus[24]));
extern double mtime P((void));
extern void maxprio P((void));
extern double num_parse P((const char *));
extern void num_undefstab P((void));
extern void num_clearstab P((void));
#if SIZEOF_INT == 2
extern int32 longread P((int fd, char *buf, unsigned int32 len));
extern int32 longwrite P((int fd, const char *buf, unsigned int32 len));
char *longmemcpy P((char *dest, const char *src, unsigned int32 n));
#else
#define longread read
#define longwrite write
#define longmemcpy memcpy
#endif

typedef int32 dsp32float;

/* Convert a DSP floating point number stored in an int in host byte-order
   into a native float */
double NativeFloat P((dsp32float x));

/* Convert a native floating point number into a DSP float stored as an int
   in host byte-order */
dsp32float DSPFloat P((double x));

#ifndef ntohl
#ifdef HAS_netinet_in_h
#include <sys/types.h>
#include <netinet/in.h>
#endif /* HAS_netinet_in_h */
#ifdef HAS_machine_endian_h
#include <machine/endian.h>
#endif /* HAS_machine_endian_h */
#endif /* !ntohl */

#if !defined(ISMACRO_ntohl) && (defined(sun) || defined(macintosh) || defined(m68k))
/* For these machines, we are sure that the byte-order matches the net-order */
#define ntohl(x) (x)
#define ntohs(x) (x)
#define htonl(x) (x)
#define htons(x) (x)
#endif

void SwapShort P((short *x));
void SwapLong P((int32 *x));
void SwapUShort P((unsigned short *x));
void SwapULong P((unsigned int32 *x));

#ifdef min
#undef min
#endif
#define min(a,b) ((a)<(b)?(a):(b))
#ifdef max
#undef max
#endif
#define max(a,b) ((a)>(b)?(a):(b))
#ifndef HAS_abs
#define abs(x) ((x)>0?(x):-(x))
#endif /* !HAS_abs */
#ifndef HAS_labs
#define labs(x) ((x)>0?(x):-(x))
#endif /* !HAS_labs */
#ifdef round
#undef round
#endif
#define round(x) ((int32)((x)+0.5))

#if defined(HAS_syslog)&&!defined(HAS_vsyslog)&&defined(NEEDS_VA)
/* We have a replacement in libsupport */
extern int vsyslog P((int priority, const char *format, va_list ap));
#endif
#endif /* !DAT_SUPPORT_H */
