/* $Id: siomode.h,v 1.14 1995/02/21 07:47:50 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Fri Jul 3 15:59:21 EDT 1992
 *
 * Revision History: $Log: siomode.h,v $
 * Revision 1.14  1995/02/21  07:47:50  bst
 * Changed comments.
 *
 * Revision 1.13  1993/12/09  19:43:24  bst
 * Added SIOMODE_DP_*_DELAY
 *
 * Revision 1.12  1993/08/31  17:22:39  bst
 * Added SIOMODE_DP_ISPRO macro.
 *
 * Revision 1.11  1993/06/25  14:36:27  bst
 * Added check for DAT_SIOMODE_H
 *
 * Revision 1.10  1993/04/26  20:49:51  bst
 * Corrected SIOMODE_DP_PRO() macro.
 *
 * Revision 1.9  1992/11/22  05:07:04  bst
 * Renamed SIOMODE_AES*
 *
 * Revision 1.8  1992/09/08  02:36:11  bst
 * Modified comments.
 *
 * Revision 1.7  1992/08/29  20:04:31  bst
 * Exchanged slave/master.
 *
 * Revision 1.6  1992/08/27  23:17:05  bst
 * Changed SIOMODE_AES to SIOMODE_AES_MSTR.
 *
 * Revision 1.5  1992/07/16  17:47:53  bst
 * Added coments regarding output muting.
 *
 * Revision 1.4  1992/07/15  23:59:21  bst
 * Added declaration of DSPSIOModeNames[].
 *
 * Revision 1.3  1992/07/10  16:46:34  bst
 * Changed comments to reflect return to 18P8 for port2.
 *
 * Revision 1.2  1992/07/08  02:10:41  bst
 * Changed comments to reflect using 16V8 for port2 control.
 *
 * Revision 1.1  1992/07/05  03:38:29  bst
 * Initial revision
 *
 */

#ifndef DAT_SIOMODE_H
#define DAT_SIOMODE_H
/* SIO configuration */
#define SIOMODE_MASK 0x3f

#define SIOMODE_AES 0x0a	/* Normal AES/EBU input and output */
#define SIOMODE_IR 0x00		/* Internal DSP clocks, input from IR sensor */

/* The following modes are only available for DAT-Link revisions >= 1.5 */
#define SIOMODE_AES_OVERRIDE 0x08
 			/* Normal AES/EBU input and output, override pause input */
#define SIOMODE_AESRX	0x0c	/* AES/EBU input, SIO output clock same as input */
#define SIOMODE_AESTX	0x28	/* AES/EBU output, SIO input clock same as output */
#define SIOMODE_DP_INT	0x20	/* General purpose DSP Port with internal clocks */
#define SIOMODE_DP_INT_DELAY	0x21	/* General purpose DSP Port with internal clocks */
#define SIOMODE_DP_EXT	0x30	/* General purpose DSP Port with external clocks */
#define SIOMODE_DP_EXT_DELAY	0x31	/* General purpose DSP Port with external clocks */
#define SIOMODE_DP_PRO(m) (0x38|((m)&0x7))
#define SIOMODE_DP_ISPRO(x) (((x)&0x38)==0x38)
				/* Pro-port compatibility mode with PC=m */
#define SIOMODE_TXFSYNC	0x02	/* Input from TX FSYNC using internal clock */
#define SIOMODE_RXFSYNC	0x04	/* Input from RX FSYNC using internal clock */

/* Names of SIO modes */
extern const char *DSPSIOModeNames[];

/* Other settings of the mode bits are reserved */


/* Summary of settings:

DI	Input Clocks	OutputClocks	Output		Mode
							543210
--------------------------------------------------------------
IR	DSP		DSP		-		00000x
RXFSYNC	DSP		DSP		-		00010x
TXFSYNC	DSP		DSP		-		00001x
AES	AESRX		AESTX		AESTX		001000	External pause
AES	AESRX		AESTX		AESTX		00101x
AES	AESRX		AESRX		DSPPort		0011xx
DSPPort	AESTX		AESTX		AESTX		1010xx
DSPPort	DSP		DSP		DSPPort		100xxx
DSPPort	DSPPort		DSPPort		DSPPort		110xxx
ProPort	ProPort		ProPort		DSPPort		111abc

* Unless 'output' is listed above, the output is muted.

* In ProPort Mode: If PC[2..0] == 111, SCLK=MCK, RXD=PC[1], TXD=PC[0],
                   If PC[2..0] != 111, SCLK=PC[2], RXD=PC[1], TXD=PC[0]
  Otherwise,       SCLK=IBF (except if using ext trig)
	  	   RXD=OSE
		   TXD=PC[0]

* When DI is from DSPPort:  if (PC[0] == 1)  DI=is delayed by 1 bit time.

* In external pause mode, pulling SCLK low will pause transfers.

*/
#endif /* !DAT_SIOMODE_H */

