/* $Id: sampfile.h,v 1.17 1993/06/23 20:33:57 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Nov 3 20:42:33 EST 1991
 *
 * Revision History: $Log: sampfile.h,v $
 * Revision 1.17  1993/06/23  20:33:57  bst
 * Changed 'long' to 'int32'
 *
 * Revision 1.16  1993/06/01  02:51:09  bst
 * Changed DataAlloc() so nbytes arg is 'size_t' instead of 'int'.
 *
 * Revision 1.15  1993/04/22  03:09:14  bst
 * Fixed declaration of DataIO.
 *
 * Revision 1.14  1993/04/12  02:25:01  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.13  1992/05/10  19:03:27  bst
 * Added encoding, precision.
 *
 * Revision 1.12  1992/02/17  04:46:49  bst
 * Removed 'nsamples' arg to wrtrailer.
 * Added channel status.
 * Added sample I/O routines declarations.
 * Added SampFileIdentify()
 *
 * Revision 1.11  1992/02/13  17:44:25  bst
 * Use 'char *' for private instead of 'void *'
 *
 * Revision 1.10  1992/01/27  03:54:11  bst
 * Added aborted() function to handle aborted playback (for waves)
 * Removed 'nsamples' arg to close()
 *
 * Revision 1.9  1992/01/24  05:05:55  bst
 * Added prototypes for function pointers.
 *
 * Revision 1.8  1992/01/22  20:46:45  bst
 * Changed left,right to channels
 * Made sampleSize counts bits not bytes.
 *
 * Revision 1.7  1992/01/19  04:24:10  bst
 * Removed 'remain', added 'headerLength','totalSamples', and 'sampleSize'
 * Use P() macro for prototypes.
 *
 * Revision 1.6  1992/01/18  04:06:20  bst
 * Added 'remain' to count samples remaining to read/write.
 *
 * Revision 1.5  1991/12/10  22:34:00  bst
 * Added currentSample to SampFile structure.
 *
 * Revision 1.4  1991/11/08  21:32:06  bst
 * Remove 'params' argument from SampFileSetDefaults()
 *
 * Revision 1.3  1991/11/08  06:03:59  bst
 * Rmeove *_construct() definiations
 * Renamed SPW_construct to SampFileSetDefaults
 * Added SampFileSetFormat to handle calling the corerct *_construct()
 *
 * Revision 1.2  1991/11/07  14:53:15  bst
 * Added private field
 * Added SPW_construct()
 * Added SampFile_null()
 *
 * Revision 1.1  1991/11/04  01:47:10  bst
 * Initial revision
 *
 */
#ifndef SAMPFILE_H
#define SAMPFILE_H

typedef struct SampFile {
    char cmd[200];	/* Command line */
    int fd;		
    FILE *io;
    char *name;		/* File name */
    float srate;	/* Sampling rate */
    float scale;	/* Scale factor (spwa only) */
    int channels;	/* Channels */
    int encoding;	/* Data encoding */
    int precision;	/* Number of bits per sample of each channel. For xfr
			to/from DAT-Link only, may be different from sampleSize. */
    unsigned int32 currentSample;    /* Current sample number */
    unsigned int32 totalSamples;
                       /* Total number of samples (or 0 if writing continuously) */
    				/* Should be set in rd/wrheader() */
    unsigned int32 headerLength;/* Length of header in bytes */
    				/* Should be set in rd/wrheader() */
    int sampleSize;		/* Size of a frame in the file in bits including
	                           any padding - should be set in rd/wrheader() */
    int cstatValid;		/* Non-zero if channel status is valid */
    unsigned char leftCS[24], rightCS[24];
    				/* Left and right channel status */
    int format;			/* File format code */
    char *private;		/* Don't use void here, FX/80 rejects it */
    int (*open) P((struct SampFile*));
    int (*create) P((struct SampFile*));
    int (*wrheader) P((struct SampFile*,unsigned int32 nsamples));
    int (*rdheader) P((struct SampFile*));
    int32 (*write) P((struct SampFile*,const byte*,int32));
    int32 (*read) P((struct SampFile*,byte*,int32));
    int (*wrtrailer) P((struct SampFile*));
    int (*seek) P((struct SampFile*,unsigned int32 sampleNumber));
    int (*close) P((struct SampFile*));
    int (*aborted) P((struct SampFile*,unsigned int32 sampleNumber));
} SampFile;

/* Constructors for different file types */
/* Set up default fields */
void SampFileSetDefaults P((struct SampFile *this,int argc, char *argv[]));

/* Initialize once file format is known */
int SampFileSetFormat P((struct SampFile *this,const char *fmtName));
int SampFile_null P((struct SampFile *this));

/* Identify a sample file */
const char *SampFileIdentify P((const char *filename));

/* Sample I/O routines */
int32 samp_write_16_B P((SampFile *this,const byte *buf,int32 nbytes));
int32 samp_read_16_B P((SampFile *this,byte *buf,int32 nbytes));
int32 samp_read_N_B P((SampFile *this,byte *buf,int32 nbytes));

int32 samp_write_16_L P((SampFile *this,const byte *buf,int32 nbytes));
int32 samp_read_16_L P((SampFile *this,byte *buf,int32 nbytes));

/* Data I/O operations */
extern void DataAlloc P((size_t nbytes,int stereo));
extern int32 DataIO P((SampFile *this,int32 (*fn)P((int,char*,int32)),
		       int32 nbytes,int32 nsamples,int stereo));
extern double *dleft;

#endif /* SAMPFILE_H */
