/* $Id: pgmspecs.h,v 1.3 1993/06/25 14:35:35 bst Exp $
 *
 * Copyright 1993 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Tue Feb 23 14:29:53 EST 1993
 *
 * Revision History: $Log: pgmspecs.h,v $
 * Revision 1.3  1993/06/25  14:35:35  bst
 * Added check for DAT_PGMSPECS_H
 *
 * Revision 1.2  1993/04/22  03:08:52  bst
 * Use ANSI prototype for functions with no args.
 *
 * Revision 1.1  1993/02/23  19:30:03  bst
 * Initial revision
 *
 */
/* Structure for passing program specifications */

#ifndef DAT_PGMSPECS_H
#define DAT_PGMSPECS_H

struct PGMSpecs {
    int mode;			/* Mode for transfers */
    double datrate, hostrate;	/* Sampling rates */
    double atten;		/* Stopband attenuation in converter */
    int nfalloc;		/* Number of points allocated in freq resp */
    int nf;			/* Number of points specified in freq resp */
    float *freqs, *levels;	/* Points in freq resp */
    float impulseRate;		/* Sampling rate of impulse response */
    int impulseAlloc;		/* Allocated space for impulse response */
    int impulseLength;		/* Length of impulse response */
    float *impulse;		/* Actual impulse response */
};

typedef struct PGMSpecs PGMSpecs;

/* Constructor for a new PGMSpecs on the heap */
PGMSpecs *PGMSpecs_New P((void));

/* Destroy a PGMSpecs including the memory pointed to by 'p' */
void PGMSpecs_Delete P((PGMSpecs *p));

/* Copy from 'src' to 'dst', allocating new storage as needed */
void PGMSpecs_Copy P((PGMSpecs *dst,const PGMSpecs *src));

/* Compare two specs returning 0 if they are identical */
int PGMSpecs_Compare P((const PGMSpecs *p1,const PGMSpecs *p2));

#endif /* !DAT_PGMSPECS_H */
