/* $Id: pgm.h,v 1.37 1994/11/17 05:11:11 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Sep 25 16:26:51 EDT 1991
 *
 * Revision History: $Log: pgm.h,v $
 * Revision 1.37  1994/11/17  05:11:11  bst
 * Changed arg to PgmSetWord to int to avoid promotion problems.
 *
 * Revision 1.36  1993/08/10  03:02:59  bst
 * Reduced MAXPGMSIZE to 64k - 2 under DOS.
 *
 * Revision 1.35  1993/06/25  14:36:17  bst
 * Change PGM_H to DAT_PGM_H
 *
 * Revision 1.34  1993/06/23  20:03:03  bst
 * Added include of dat_types.h
 * Changed 'long' to 'int32'.
 *
 * Revision 1.33  1993/05/24  18:19:33  bst
 * Use long instead of int when encoding/decoding programs.
 *
 * Revision 1.32  1993/05/05  17:11:42  bst
 * Added some coercions to SetWord() arg.
 *
 * Revision 1.31  1993/04/22  03:34:25  bst
 * Use pmacro.h for P() macro.
 *
 * Revision 1.30  1993/04/12  02:21:47  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.29  1993/03/12  14:40:20  bst
 * Added 'prefix', SetPrefix().
 * Made Relocate() return an error code.
 *
 * Revision 1.28  1993/02/23  21:32:14  bst
 * Added some 'const' qualifiers to 'Program *' args.
 *
 * Revision 1.27  1992/11/04  04:42:02  bst
 * Renamed BuildConverter() to SetupConverter() with extra 'pgm' arg.
 * Added GetCapabilities(), PgmSetWord(), DuplicateProgram().
 * Removed old pgm_*() routines.
 *
 * Revision 1.26  1992/11/01  20:57:15  bst
 * Added 'suppressNoLoad' arg to EncodeProgram().
 *
 * Revision 1.25  1992/10/30  23:05:01  bst
 * Added Program::GetPointer() - use it for GetByte() and SetByte().
 * Added NumSyms() and IndexSymbol().
 *
 * Revision 1.24  1992/10/01  03:31:24  bst
 * Added Dec/EncodeShort().
 *
 * Revision 1.23  1992/09/16  23:45:22  bst
 * Added ReadDSPProgram()  (was in patchpgm.h)
 *
 * Revision 1.22  1992/08/17  03:11:24  bst
 * Removed 'nbytes' argument from program decoding.
 *
 * Revision 1.21  1992/07/13  05:31:18  bst
 * Added 'stamp' field to Program for timestamp.
 * Added Program::TimeStamp().
 * Added Checksum routines, but commented them out.
 *
 * Revision 1.20  1992/07/11  20:35:11  bst
 * Added Decode(), GetOffset(), SetOffset(), LoadPGM().
 * Added Relocation structure for more reloc info.
 *
 * Revision 1.19  1992/07/05  03:45:01  bst
 * Added 'todat' field to BuildConverter().
 * Use pgm_FIXnn() instead of pgm_FIX[cy]()
 *
 * Revision 1.18  1992/06/27  22:25:49  bst
 * Added baseSegmentSize argument for BuildConverter().
 *
 * Revision 1.17  1992/05/17  20:40:15  bst
 * Added MAXPGMSIZE macro.
 * Added LoadCOFF() routine.
 * Replaced contructor using COFF file with a null constructor.
 * Added DecodeProgram(), LoadProgram() C-callable functions.
 *
 * Revision 1.16  1992/05/15  23:00:58  bst
 * Added constructor to read from COFF file.
 *
 * Revision 1.15  1992/01/28  05:57:59  bst
 * Added impulse args to BuildConverter()
 *
 * Revision 1.14  1992/01/22  21:24:09  bst
 * Added PgmSetFloat()
 *
 * Revision 1.13  1992/01/11  23:27:30  bst
 * Chnaged some 'int' to 'unsigned int'
 * Use P() macro for function prototypes.
 * Renamed Segment() to IndexSegment()
 * .`
 *
 * Revision 1.12  1991/12/17  04:49:15  bst
 * Added additional args for filtering to BuildConverter()
 *
 * Revision 1.11  1991/12/12  04:27:10  bst
 * Converted to C++
 *
 * Revision 1.10  1991/12/03  17:29:12  bst
 * Added DeleteProgram()
 *
 * Revision 1.9  1991/11/14  05:39:33  bst
 * Added declarations of LookupDSPSymbol() and BuildConverter().
 *
 * Revision 1.8  1991/11/07  02:37:37  bst
 * Removed SetDSPParams().
 *
 * Revision 1.7  1991/11/06  16:45:02  bst
 * SetDspParams no longer deals with overheads.
 *
 * Revision 1.6  1991/10/30  02:59:20  bst
 * Made data a vector of bytes to avoid host byte-order problems.
 *
 * Revision 1.5  1991/10/25  03:44:05  bst
 * GetProgram now uses a buffer of bytes.
 *
 * Revision 1.4  1991/10/20  18:28:42  bst
 * Added HWRevision to PatchProgram() arguments.
 *
 * Revision 1.3  1991/09/30  00:53:45  bst
 * Change float->double.
 *
 * Revision 1.2  1991/09/27  15:09:51  bst
 * PatchProgram() now takes 'mode' as an argument.
 * Added GetProgram().
 *
 * Revision 1.1  1991/09/25  20:27:21  bst
 * Initial revision
 *
 *
 */
/* Definitions for a DSP32 program built as a C structure */

#ifndef DAT_PGM_H
#define DAT_PGM_H

#ifndef EMEDDED
#include "pmacro.h"
#else
#define P(params) params
#endif
#include "dat_types.h"

#if SIZEOF_INT == 2
#define MAXPGMSIZE 65534
#else
#define MAXPGMSIZE 512*1024
#endif

#ifdef __cplusplus
extern short DecodeShort(const unsigned char *&stream);
extern int32 DecodeInt(const unsigned char *&stream);
extern unsigned char *DecodeBytes(const unsigned char *&stream,
				  int32 &stlen);
extern int32 EncodeShort(short x, unsigned char *&stream, int32 &slen);
extern int32 EncodeInt(int32 x, unsigned char *&stream, int32 &slen);
extern int32 EncodeBytes(const unsigned char *s,
		       unsigned char *&stream, int32 &slen, int32 stlen);
extern unsigned short AddSum(unsigned short sum, unsigned char *data, int32 nbytes);
#else /* __cplusplus */
#define class struct
#endif /* __cplusplus */

/* A relocatation entry */
struct Relocation {
    unsigned int32 r_vaddr;
    unsigned short r_type;
};
    
/* A symbol table entry */
class Symbol {
    char *name;
    unsigned int32 addr;
    int nreloc;
    struct Relocation *reloc;
#ifdef __cplusplus
  public:
    Symbol(const char *_name, unsigned int32 _addr,int _nreloc,
	   Relocation _reloc[]);
    Symbol(const Symbol &old);
    Symbol(const unsigned char *&stream);
    ~Symbol()
	{ if (name) delete name; if (reloc) delete reloc; }
    int32 Encode(unsigned char *buf, int32 nbytes) const;
    const char *Name() const { return name; }
    unsigned int32 Addr() const { return addr; }
    void SetAddr(unsigned int32 newAddr) { addr = newAddr; }
    int NumReloc() const { return nreloc; }
    Relocation *Reloc() const { return reloc; }
//    unsigned short Checksum(unsigned short sum) const;
#endif /* __cplusplus */
};

/* A Segment of data */
class Segment {
    char *name;
    unsigned int32 base;
    unsigned int32 length;
    unsigned char *data;
#ifdef __cplusplus
  public:
    Segment(const char *_name, unsigned int32 _base, unsigned int32 _length,
	    const unsigned char *_data);
    Segment(const Segment &old);
    Segment(const unsigned char *&stream);
    ~Segment()
	{ if (name) delete name; if (data) delete data; }
    int32 Encode(unsigned char *buf, int32 nbytes) const;
    const char *Name() const { return name; }
    unsigned int32 Base() const { return base; }
    void SetBase(unsigned int32 newBase) { base = newBase; }
    unsigned int32 Length() const { return length; }
    const unsigned char *Data() const { return data; }
    void SetByte(unsigned int32 a, unsigned char v) { data[a-base] = v; }
    void Resize(unsigned int32 newLength);
//    unsigned short Checksum(unsigned short sum) const;
#endif /* __cplusplus */
};

#ifndef __cplusplus
typedef struct Symbol Symbol;
typedef struct Segment Segment;
#endif /* __cplusplus */

/* A program, complete with symbol table and section contents */
class Program {
    char *prefix;	/* Prefix to use when looking up symbols */
    char *name;
    int32 stamp;	/* time & date stamp */
    int nstab;
    Symbol **stab;
    int nsegs;
    Segment **segs;
#ifdef __cplusplus
  public:
    Program(const char *_name, const Symbol _stab[], const Segment _segs[]);
    Program(const Program &old);
    Program(const unsigned char *stream);
    Program() 
	{ name=0; nstab=0; nsegs=0; stab=0; segs=0; stamp=0; prefix=0; }
    ~Program();

    const char *Name() const { return name; }
    int32 TimeStamp() const { return stamp; }

    /* Read from COFF file - return -1 for failure */
    int LoadCOFF(const char *filename);

    /* Read from PGM file - return -1 for failure */
    int LoadPGM(const char *filename);

    /* Compute a checksum of the program */
//    unsigned short Checksum(unsigned short sum) const;

    /* Lookup a symbol in the symbol table and return the entry */
    Symbol *Lookup(const char *symbol) const;

    /* Get the address of a symbol */
    unsigned int32 GetAddr(const char *vname) const;

    int NumSegs() const { return nsegs; }
    const Segment *IndexSegment(int i) const { return segs[i]; }

    int NumSyms() const { return nstab; }
    const Symbol *IndexSymbol(int i) const { return stab[i]; }

    /* Get segment descriptor for addr 'a' in 'pgm',  Return 0 if not found  */
    Segment *GetSegment(unsigned int32 a) const; 

    /* Get segment descriptor by name */
    Segment *GetSegment(const char *nm) const;

    /* Check if an address is valid */
    int ValidAddr(unsigned int32 a) const
	{ return GetSegment(a) != 0; }

    /* Get a pointer to the byte at the given address */
    unsigned char *GetPointer(unsigned int32 a) const;

    /* Get the byte at the given address */
    unsigned char GetByte(unsigned int32 a) const
        { return *GetPointer(a); }

    /* Set the byte at the given address */
    void SetByte(unsigned int32 a,unsigned char v)
        { *GetPointer(a) = v; }

    /* Get the word at the given address */
    unsigned short GetWord(unsigned int32 a) const
	{ return GetByte(a)|(GetByte(a+1)<<8); }

    /* Set the word at the given address */
    void SetWord(unsigned int32 a, unsigned short v)
	{ SetByte(a,v&0xff); SetByte(a+1,(v>>8)&0xff); }

    /* Get the int at the given address */
    unsigned int32 GetInt(unsigned int32 a) const
	{ return GetWord(a)|(((unsigned int32)GetWord(a+2))<<16); }

    /* Set the int at the given address */
    void SetInt(unsigned int32 a,unsigned int32 v)
	{ SetWord(a,(unsigned short)v&0xffff);
	  SetWord(a+1,(unsigned short)(v>>16)&0xffff); }

    /* Convert a program to its image starting from address 0 */
    void Get(unsigned char *buf, int32 nbytes) const;

    /* Encode a program onto a byte stream - return length */
    int32 Encode(unsigned char *buf, int32 nbytes,int suppressNoLoad) const;

    /* Decode a program from a byte stream \(-1 for failure\) */
    int Decode(const unsigned char *buf);
#ifndef EMBEDDED
    /* Get the offset of a relocatable address from the program */
    int32 GetOffset(Relocation *reloc);

    /* Set the offset of a relocatable address from the program */
    void SetOffset(Relocation *reloc,int32 offset);

    /* Relocate a symbol to the given address - return -1 for error. */
    int Relocate(const char *vname, unsigned int32 newAddr);

    /* Get the float at the given address */
    double GetFloat(unsigned int32 a) const;

    /* Set the float at the given address */
    void SetFloat(unsigned int32 a, double dvalue);

    /* Dump as ASCII to a file */
    void DumpASCII(const char *fname,unsigned int nbytes) const;

    /* Dump as binary to a file */
    void DumpBinary(const char *fname,unsigned int nbytes) const;

    /* Set prefix for symbol lookups */
    void SetPrefix(const char *pre);
#endif /* EMBEDDED */
#endif /* __cplusplus */
};
#ifndef __cplusplus
#undef class
typedef struct Program Program;
#endif /* __cplusplus */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
    extern Symbol *LookupDSPSymbol P((const Program *pgm, const char *nm));
    extern void GetProgram P((Program *pgm, unsigned char *buf,
			      int32 nbytes));
    extern int32 EncodeProgram P((const Program *pgm, unsigned char *buf,
				 int32 nbytes,int suppressNoLoad));
    extern Program *DecodeProgram P((unsigned char *buf));
    extern Program *DuplicateProgram P((const Program *old));
    extern int SetupConverter P((double ir, double or,int todat, Program *pgm,int mode,
				 int32 baseSegmentSize,double atten, int nf, float freqs[],
				 float levels[], float *rate,float *impulse, int *maxImpulse));
    extern unsigned int32 GetCapabilities P((const Program *pgm));
    extern void DeleteProgram P((Program *pgm));
    extern int PgmSetFloat P((Program *pgm, const char *symname, double value));
    extern int PgmSetWord P((Program *pgm, const char *symname, int value));
    extern Program *LoadProgram P((const char *filename));
    extern Program *ReadDSPProgram P((const char *pgmName));
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* !DAT_PGM_H */
