/* $Id: netaudio.h,v 2.33 1996/03/19 20:58:18 eryk Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Sun Dec 8 15:35:43 EST 1991
 *
 * Revision History: $Log: netaudio.h,v $
 * Revision 2.33  1996/03/19  20:58:18  eryk
 * Changed OPTIMUM_TRANSFER_LENGTH to 51200 under WIN32
 *
 * Revision 2.32  1995/01/20  06:43:16  bst
 * Added NA_FILLPAUSED to NAstate
 *
 * Revision 2.31  1993/11/10  00:32:47  bst
 * Added NA_ENCODING_CONTROL.
 *
 * Revision 2.30  1993/10/26  16:14:38  bst
 * Made channel status, user bits unsigned.
 *
 * Revision 2.29  1993/10/04  02:04:31  bst
 * Don't include extern decls in RPC files.
 *
 * Revision 2.28  1993/10/04  01:58:13  bst
 * Added some extern char * arrays.
 *
 * Revision 2.27  1993/08/10  01:58:35  bst
 * int32 changes.
 *
 * Revision 2.26  1993/06/25  14:35:26  bst
 * Modified comment.
 *
 * Revision 2.25  1993/06/23  20:32:25  bst
 * Added include of dat_types.h
 * Changed 'long' to 'int32'
 *
 * Revision 2.24  1993/06/07  14:18:57  bst
 * Added bytesTransferred.
 *
 * Revision 2.23  1993/05/27  15:00:48  bst
 * Changed NADSPRead(), NADSPWrite() to signed int byte counts.
 *
 * Revision 2.22  1993/05/26  13:07:22  bst
 * Added DRAINING, DRAINPAUSED states.
 *
 * Revision 2.21  1993/04/22  03:08:29  bst
 * Use P() macro for declarations.
 * Added NAerrorFunction declaration.
 *
 * Revision 2.20  1993/04/12  02:24:38  bst
 * Use long when 32-bit integers required.
 *
 * Revision 2.19  1993/02/23  16:45:35  bst
 * *** empty log message ***
 *
 * Revision 2.18  1992/12/17  04:21:11  bst
 * Added NADSPRead(), NADSPWrite().
 *
 * Revision 2.17  1992/10/25  20:57:59  bst
 * Do not send info with CONFIGURE_NOTIFY events.
 *
 * Revision 2.16  1992/10/04  17:16:04  bst
 * Added NAGetServerVersion().
 *
 * Revision 2.15  1992/07/15  23:46:14  bst
 * Added NAResumeServer().
 *
 * Revision 2.14  1992/07/05  03:03:57  bst
 * Get separate SnapShots for playback and record.
 * Added dspSIOMode to info struct.
 *
 * Revision 2.13  1992/05/25  17:11:53  bst
 * Added extern definition of NAGetDSPProgram() for non-ANSI compilers.
 *
 * Revision 2.12  1992/05/20  00:20:18  bst
 * Added NA_FILLING state for filling playback buffer.
 *
 * Revision 2.11  1992/05/17  20:31:57  bst
 * Added dspProgram field to info.
 * Added NASetDSPProgram() and NAGetDSPProgram()
 *
 * Revision 2.10  1992/05/10  19:03:04  bst
 * Added additional encodings: IEEE, ULAW, ALAW.
 *
 * Revision 2.9  1992/05/01  17:05:17  bst
 * Added NASerialRead() and NASerialWrite()
 *
 * Revision 2.8  1992/02/15  19:48:10  bst
 * Added NAServer(), NAPauseServer().
 * Added _NAquiet to suppress internal error messages.
 *
 * Revision 2.7  1992/01/28  05:48:18  bst
 * Added NAGetFilterImpulse()
 *
 * Revision 2.6  1992/01/17  04:16:22  bst
 * Made some strings 'const'.
 *
 * Revision 2.5  1991/12/17  04:46:35  bst
 * Modified NAfilter structure.
 *
 * Revision 2.4  1991/12/17  02:54:40  bst
 * Added 'gain', 'VUdecayRate'
 * Added non-ANSI return types for NAList{Devices,Operations}()
 *
 * Revision 2.3  1991/12/16  05:22:05  bst
 * Added 'force' argument to NACloseData()
 *
 * Revision 2.2  1991/12/16  00:41:24  bst
 * Changed interpretation of 'state'
 * Removed 'pause' boolean (state encodes that now)
 * Removed 2nd arg to NAOpen() - NAOpenData() must be called explicitly.
 *
 * Revision 2.1  1991/12/08  21:39:00  bst
 * Network version number
 *
 * Revision 1.1  1991/12/08  20:35:46  bst
 * Initial revision
 *
 */
/* NetAudio Interface */

/* NOTE: The syntax of the data definitions should comply with both "C" and XDR */

#ifndef NETAUDIO_H
#define NETAUDIO_H

#include "pmacro.h"
#include "dat_types.h"

enum NAstate_enum { NA_INACTIVE, NA_PAUSED, NA_ACTIVE, NA_FILLING, NA_DRAINING,
		    NA_DRAINPAUSED, NA_FILLPAUSED };
/* Note: States FILLING, DRAINING, and DRAINPAUSED are only
   applicable to playback */
typedef enum NAstate_enum NAstate;

enum NAclock_enum { NA_CLOCK_INTERNAL, NA_CLOCK_EXTERNAL, NA_CLOCK_INPUT };
typedef enum NAclock_enum NAclock;

enum NAxfrError_enum { NA_XFRERR_NOERROR, NA_XFRERR_UNDERRUN, NA_XFRERR_OVERRUN,
		       NA_XFRERR_DROPPEDLOCK,NA_XFRERR_DSPERROR,
		       NA_XFRERR_RATECHANGED };
typedef enum NAxfrError_enum NAxfrError;

struct NAinfosect_struct {
    float sampleRate;		/* Sampling rate of data stream; 0 for DAT rate */
    float externalRate;		/* External sampling rate (RO for record) */
    char precision;		/* Number of bits per sample */
    char encoding;		/* Data encoding */
    char channels;		/* Stereo/mono definition */
    char waiting;		/* If another process wants to transfer data (RO) */
    float gain;			/* Gain control - 1.0 = unscaled */
    float VUdecayRate;		/* VU decay rate in dB/second */
    NAstate state;		/* State of transfers (RO) */
    NAxfrError error;		/* Cause of transfer error (RO) */
    unsigned int32 bufferSize;	/* Total number of bytes of buffering avail (RO) */
    
    /* AES/EBU info */
    unsigned char leftCS[24];	/* Left channel status (RO for record) */
    unsigned char rightCS[24];	/* Right channel status (RO for record) */
    unsigned char user[4];	/* User bits (RO for record) */
};

typedef struct NAinfosect_struct NAinfosect;

/* Info structure */
struct NAinfo_struct {
    /* Fields that are repeated for playback and record */
    NAinfosect playback;
    NAinfosect record;

    NAclock clock;		/* Clock source for playback */
    unsigned char master;	/* 1 to become a master clock source */
    unsigned char skipSilence;	/* 1 to skip silence on record */
    unsigned char locked;	/* 1 if input signal present (RO) */

    /* Info about server (RO) */
    int32 protoMajorVersion;	/* Major version of server's NA protocol */
    int32 protoMinorVersion;	/* Minor version of server's NA protocol */
    char hardware[16];		/* Name of server hardware */
    int32 hwVersion;		/* Server hardware version number */

    /* Fields specific to DAT-Link */
    unsigned short source;	/* Input source */
    unsigned short rxstatus;	/* Status registers of AES receiver */
    unsigned char loopback;	/* 1 to enable ramp output during record */
    char dspProgram[16];	/* Name of current DSP program */
    int32 dspSIOMode;		/* SIO Mode (see siomode.h) */
};

/* Bit definitions for DAT-Link specific fields */
/* Input source */
#define DL_ISRC_ALL 0
#define DL_ISRC_RCA 1
#define DL_ISRC_AES 2
#define DL_ISRC_FIBER 3

/* Optimum length for read/write transfers */
#ifdef __WIN32__
/* it seems that aspi32 doesn't support transfers larger than that */
#define OPTIMUM_TRANSFER_LENGTH 51200L
#else
#define OPTIMUM_TRANSFER_LENGTH 64512L
#endif /* __WIN32__ */

typedef struct NAinfo_struct NAinfo;

/* Fast-changing status */
struct NAsnapshot_struct {
    float VULevelLeft;		/* Current VU levels */
    float VULevelRight;
    unsigned int32 sampleNumber;/* Current sample number at input or output */
    unsigned int32 buffered;	/* Number of samples of buffered data */
    /* Number of bytes transferred to/from server on data channel */
    unsigned int32 bytesTransferred;
};
typedef struct NAsnapshot_struct NAsnapshot;

struct NAsnapshots_struct {
    NAsnapshot pb;
    NAsnapshot rec;
};
typedef struct NAsnapshots_struct NAsnapshots;

/* Events */
enum NAevents_enum { NA_SNAPSHOT, NA_CONFIGURENOTIFY, NA_CONFIGUREREQUEST,
		     NA_REMOTEDONE };
typedef enum NAevents_enum NAevents;

#if defined(RPC_XDR)||defined(RPC_HDR)
union NAevent switch (NAevents event) {
  case NA_SNAPSHOT:
    NAsnapshots snap;
  case NA_CONFIGURENOTIFY:
    void;
  case NA_CONFIGUREREQUEST:
    NAinfo crinfo;
  case NA_REMOTEDONE:
    int32 ecode;
};
#else
struct NAevent {
    NAevents event;
    union {
	NAsnapshots snap;
	NAinfo crinfo;
	int32 ecode;
    } NAevent_u;
};
typedef struct NAevent NAevent;
#endif

/* Defines for encoding field */
#define NA_ENCODING_LINEAR 0
#define NA_ENCODING_IEEE 1	/* IEEE 32bit floating point */
#define NA_ENCODING_ULAW 2
#define NA_ENCODING_ALAW 3
#define NA_ENCODING_CONTROL 4	/* Include subcode info with linear data */

/* Defines for channels field */
#define NA_CHANNELS_MONO 0	/* 1 channel sent to both L and R outputs */
#define NA_CHANNELS_LEFT 1
#define NA_CHANNELS_RIGHT 2
#define NA_CHANNELS_STEREO 3
#define NA_CHANNELS_CONTROL 4	/* Control info also */

/* Sample-rate conversion filter */
struct NAfilter_struct {
    float atten;
#if defined(RPC_XDR)||defined(RPC_HDR)
    float frequency<>;
    float level<>;
#else
    struct {
	unsigned int32 frequency_len;
	float *frequency_val;
    } frequency;
    struct {
	unsigned int32 level_len;
	float *level_val;
    } level;
#endif
};

typedef struct NAfilter_struct NAfilter;

/* Server control */
enum NAserverOps_enum { NA_KILLSERVER, NA_PAUSESERVER, NA_RESUMESERVER };
typedef enum NAserverOps_enum NAserverOps;

#ifndef RPC_XDR
#ifndef RPC_HDR

/* Bits for 'playrec' arguments below */
#define NA_PLAY 1
#define NA_RECORD 2

typedef struct NAportstruct NAport;
extern int _NAquiet;	/* Non-zero to suppress internal error messages */
struct NAerror_struct;
/* Error handler */
extern int (*NAerrorFunction) P((NAport*,struct NAerror_struct*));

/* Functions accessible to clients */
/* Opening and closing a connection */
NAport *NAOpen P((const char *s));
	/* Open a control connection to the given device - return null for failure*/
int NAOpenData P((NAport *port, int playrec));
	/* Add a data connection to an already open control port */
int NAClose P((NAport *port));
	/* Close all connections for a port, flushing data */
int NACloseData P((NAport *port, int force));
	/* Close the data connections for a port */
	/* Let data drain before closing unless force=1 */

/* Control functions */
int NAGetInfo P((NAport *port, NAinfo *info));
				/* Retrieve the current info from the audio dev */
int NAGetDefaultInfo P((NAinfo *info));
				/* Fill in an info structure with std defaults */
int NASetInfo P((NAport *port, const NAinfo *info));
				/* Set the info - may flush pending data */
int NAGetSnapshot P((NAport *port, NAsnapshots *snap));
				/* Get the fast changing data */
int NAPause P((NAport *port, int playrec, int pause));
				/* Pause control */
int NABegin P((NAport *port, int playrec));
				/* Force transfers to begin */
int NADrain P((NAport *port));
				/* Wait for data to drain */
int NAFlush P((NAport *port, int playrec));
				/* Immediately flush all buffered data */
int NASetFilter P((NAport *port, int playrec, const NAfilter *filter));
				/* Set sample-rate conversion filter */
int NAGetFilterImpulse P((NAport *port, int playrec,
		       float *impulseRate, float *response, int *length));
				/* Get impulse response of conversion filter */

/* Event handling */
int NASelectInput P((NAport *port, int eventmask));
			/* Select the event types to be received */
int NANextEvent P((NAport *port, NAevent *event));
			/* Retrieve the next event from the server */
int NACheckMaskEvent P((NAport *port,int eventmask,NAevent *event));
			/* Check if an event is in the event queue */
int NAMaskEvent P((NAport *port, int eventmask, NAevent *event));
		       /* Return the next event matching the mask (selects first) */
int NAPending P((NAport *port));
			/* Returns the number of events on the queue */
int NASetPollInterval P((NAport *port, int32 usec));
			/* Set the time between SNAPSHOT events (if enabled) */

/* Sample I/O */
int32 NAWrite P((NAport *port, const char *buffer, int32 buflen));
			/* Write samples - same as write(2) */
			/* Short count return indicates underrun occurred */
int32 NARead P((NAport *port, char *buffer, int32 buflen));
			/* Read samples - same as read(2) */
			/* Short count return indicates overrun occurred */
			/* NABegin() MUST be called before using NARead() */

/* Remote control */
int NARemote P((NAport *port, const char *device, const char *operation));
			/* Execute 'operation' on 'device' */
char **NAListDevices P((NAport *port, int *ndevices));
			/* Return list of devices */
char **NAListOperations P((NAport *port, const char *device, int *noperations));
			/* Return list of operations */
void NAFreeList P((char **list));
			/* Free a list returned by above routines */

/* Serial port I/O */
int NASerialRead P((NAport *port,int unit,char *buf,int nbytes));
int NASerialWrite P((NAport *port,int unit,const char *buf,int nbytes));

/* DSP Program Control */
struct Program;
int NASetDSPProgram P((NAport *port,struct Program *pgm));
struct Program *NAGetDSPProgram P((NAport *port));

int NADSPRead P((NAport *port,unsigned int32 addr, int nbytes,unsigned char *buf));
int NADSPWrite P((NAport *port,unsigned int32 addr, int nbytes,
		  const unsigned char *buf));

/* Server control */
int NAServer P((NAport *port, NAserverOps op));
			/* Kill, pause, or resume server */
int NAPauseServer P((int unit));
int NAResumeServer P((int unit));
			/* Convenience routine - open and pause the server at
			   given unit; no other NetAudio calls needed */
int NAGetServerVersion P((NAport *port));
       /* Get version of NetAudio running on server (i.e. 2.14 -> 2014) */

/* Some labels for various enums */
extern const char *_NAstateNames[];
extern const char *_NAxfrErrorNames[];
extern const char *_NAeventNames[];
extern const char *_NAencodingNames[];

#endif /* RPC_XDR */
#endif /* RPC_HDR */
#endif /* !NETAUDIO_H */
