/* $Id: host_if.h,v 1.27 1993/10/02 04:49:11 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Fri Aug 23 09:51:53 EDT 1991
 *
 * Revision History: $Log: host_if.h,v $
 * Revision 1.27  1993/10/02  04:49:11  bst
 * Added TxModelNames[], RXModelNames[].
 *
 * Revision 1.26  1993/08/10  03:00:29  bst
 * Made DL_MAXREPLYLEN long.
 *
 * Revision 1.25  1993/06/28  20:06:35  bst
 * Reduced DL_MAXREPLYLEN by DL_HEADER_LEN
 * Don't let DL_MAXREPLYLEN exceed OPTIMUM_TRANSFER_LENGTH.
 *
 * Revision 1.24  1993/06/25  14:36:06  bst
 * Modified comment.
 *
 * Revision 1.23  1993/05/21  17:44:05  bst
 * Added SetModeCodes, modeCodeNames[].
 *
 * Revision 1.22  1993/04/22  18:46:04  bst
 * Use P() macro.
 *
 * Revision 1.21  1993/04/12  02:16:10  bst
 * Use 'unsigned int' for 'nrecv' in dat_sendmsg().
 *
 * Revision 1.20  1993/03/10  03:46:03  bst
 * Added DL_BEGINIO.
 *
 * Revision 1.19  1993/02/23  16:57:11  bst
 * Added comment about constants.c
 *
 * Revision 1.18  1992/11/21  03:12:25  bst
 * Added DL_GET_ERRLOG.
 *
 * Revision 1.17  1992/11/08  23:08:03  bst
 * Added DL_DSPMESSAGE opcode.
 *
 * Revision 1.16  1992/08/20  00:20:25  bst
 * Use 512 instead of BLOCK_LENGTH in calculation of DL_MAXMSGLENGTH.
 *
 * Revision 1.15  1992/07/15  23:57:54  bst
 * Added declaration of msgnames[] and DSPIOErrNames[].
 *
 * Revision 1.14  1992/07/12  15:53:19  bst
 * Added DL_DIAGNOSTICS.
 *
 * Revision 1.13  1992/07/09  22:03:10  bst
 * Added DL_MAXREPLYLEN (from lun_dsp.h)
 *
 * Revision 1.12  1992/07/05  03:47:25  bst
 * Remove DL_GETMODE.
 * Added DL_SETSIOMODE.
 *
 * Revision 1.11  1992/06/27  22:24:37  bst
 * Chenage DL_CHECKSUM to DL_PARAMETERS.
 *
 * Revision 1.10  1992/05/20  01:49:35  bst
 * Added DL_COLDBOOT
 *
 * Revision 1.9  1992/05/01  17:08:39  bst
 * Added DL_SERIALREAD, DL_SERIALWRITE messages.
 *
 * Revision 1.8  1991/12/12  04:26:07  bst
 * Added DL_SETDSPPGM
 *
 * Revision 1.7  1991/12/05  02:44:02  bst
 * Added DL_SETDSPADDRS
 * Remove DL_SETBUFSIZE (it wasn't being used)
 *
 * Revision 1.6  1991/11/04  02:23:36  bst
 * Added explicit numbering of DAT-Link commands.
 *
 * Revision 1.5  1991/10/20  19:51:52  bst
 * Change DL_DSPPIO to DL_DSPHALT
 *
 * Revision 1.4  1991/10/20  18:08:24  bst
 * Added DL_EXECUTE.
 * Made nrecv argument to dat_sendmsg an 'int' instead of 'u_int'
 *
 * Revision 1.3  1991/10/09  21:06:47  bst
 * Added DL_SETBUFSIZE
 *
 * Revision 1.2  1991/08/27  02:03:30  bst
 * Added DL_INPUTSRC
 *
 * Revision 1.1  1991/08/24  00:00:44  bst
 * Initial revision
 *
 *
 */
#ifndef HOST_IF_H
#define HOST_IF_H

#include "datlink.h"

/* Communications protocol definitions */
/* Protocol for communication with DAT-Link */
typedef enum  { DL_NOP=0, DL_BEGINWRITE=1, DL_BEGINREAD=2, DL_CLEARTRANSFERS=3,
		/* DL_GETMODE=4, */ DL_SETMODE=5, DL_GETU=6, DL_SETU=7, DL_GETC=8,
		DL_SETC=9, DL_SETCLOCK=10, DL_GETSTATUS=11, DL_GETRMTBEGIN=12,
		DL_GETRMTEND=13, DL_PUTRMTSEQ=14, DL_ENDRMTSEQ=15, DL_DSPWRITE=16,
		DL_DSPREAD=17, DL_DSPHALT=18, DL_RESET=19, DL_PARAMETERS=20,
		DL_ERROR=21, DL_INPUTSRC=22, /* DL_SETBUFSIZE=23, */ DL_EXECUTE=24,
		DL_SETDSPADDRS=25, DL_SETDSPPGM=26,
		/* Added to version 30 or later */
		DL_SERIALWRITE=27, DL_SERIALREAD=28, DL_COLDBOOT=29,
		DL_SETSIOMODE=30, DL_DIAGNOSTICS=31, DL_DSPMESSAGE=32,
		DL_GET_ERRLOG=33, DL_BEGINIO=34
		    /* Don't forget to modify 'constants.c' if something is
		       changed here! */
		} Opcodes;

typedef enum { MODE_FROMDAT=0, MODE_TODAT=1, MODE_AUTOSTATUS=2 } SetModeCodes;

#define DL_MAGIC_LEN 7
/* Header consists of 7 bytes magic number, 1 byte opcode, 4 byte length */
#define DL_HEADER_LEN (DL_MAGIC_LEN+1+4)
/* The maximum command length is a little shorter so the DAT-Link can quickly
   identify non-command writes using the optimum transfer length */
#define DL_MAXMSGLENGTH (OPTIMUM_TRANSFER_LENGTH-512)
/* Maximum length of a reply to a command */
#define DL_MAXREPLYLEN (((OPTIMUM_TRANSFER_LENGTH>8192L)?8192L:OPTIMUM_TRANSFER_LENGTH)-DL_HEADER_LEN)

/* These are the magic numbers which make up the first 7 bytes of each command */
extern unsigned char cmd_magic[DL_MAGIC_LEN];

/* Labels for various enums */
extern const char *msgnames[];	/* Opcodes */
extern const char *DSPIOErrNames[];
extern const char *modeCodeNames[];
extern const char *TXModelNames[], *RXModelNames[];

int dat_sendmsg P((dat_fd dt, Opcodes opcode, unsigned int nsend,
		   const byte *sdata, unsigned int nrecv, byte *rdata));
#endif /* !HOST_IF_H */

