/* $Id: dspmem.h,v 1.4 1992/11/08 23:05:25 bst Exp $
 *
 * Copyright 1992 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Fri Jul 3 15:59:15 EDT 1992
 *
 * Revision History: $Log: dspmem.h,v $
 * Revision 1.4  1992/11/08  23:05:25  bst
 * Added DSPPOUT_* bit values for parallel output.
 * Added HWRevision 16 support.
 *
 * Revision 1.3  1992/07/13  05:28:49  bst
 * Added some comments.
 *
 * Revision 1.2  1992/07/09  22:02:34  bst
 * Access CS8401 and CS8411 at 0xb00000 instead of 0x300000 for wait states.
 *
 * Revision 1.1  1992/07/05  04:03:20  bst
 * Initial revision
 *
 */
/* DSP32C Memory Map */

#if HWRevision >= 15
/* For all addresses, upper 2 address bits are ignored */

/* External RAM0  16kx32:  0x000000-0x00ffff
                  64kx32:  0x000000-0x03ffff
		  256kx32: 0x000000-0x0fffff */
#define EXTRAM0_ADDR    0x000000

#if HWRevision >= 16
/* External RAM1 immediately follows RAM0 regardless of RAM0 size */
#else
/* External RAM1  16kx32:  0x100000-0x10ffff
                  64kx32:  0x100000-0x13ffff
		  256kx32: 0x100000-0x1fffff */
#define EXTRAM1_ADDR    0x100000
#endif

/* DMA From 68k to DSP - Any address in range 0x200000-0x2fffff
   Low 16 bits are from host CPU
   Bit23 is 1 if there was data from the host \(cleared by reading\) */
#define DMAFROM68K_ADDR 0x200000

/* Crystal CS8411
      - AB23=1 to place it in External Memory Block B \(2 wait states\)
      - the lower order 2 address bits must be 0 to access the regs.
      - Address bits 9-19 are ignored   
      - Use 0xb00000 - 0xb0007c */
#define CS8411_ADDR     0xb00000

/* Crystal CS8401
      - AB23=1 to place it in External Memory Block B \(2 wait states\)
      - the lower order 2 address bits must be 0 to access the regs.
      - Address bits 9-19 are ignored   
      - Use 0xb00080 - 0xb000fc */
#define CS8401_ADDR     0xb00080

#if HWRevision >= 16
/* DSP Output Register */
#define DSPPOUT_ADDR 0x300100
#else
#define DSPBIO_ADDR 0x300100
#endif

/* Interrupt control - On read DB15=1 if CS8411 interrupt is active
			       DB14=1 if CS8401 interrupt is active
		       On write DB15=1 sets /DSPIRQ=0 (Interrupt 68k)
*/
#define INTR_ADDR 0x300180
#define INTR_AESRX 0x8000
#define INTR_AESTX 0x4000

#if HWRevision >= 16
#define INTR_DMAOUT 0x2000
#define INTR_DMAIN 0x1000
#else
#define INTR_SET_N_DSPIRQ 0x8000
#endif

#endif /* HWRevision >= 15 */

/* Parallel output port bit definitions */

#if HWRevision >= 16
#define DSPPOUT_N_READY 0x1	/* 0 if DSP is ready, 1 otherwise */
#define DSPPOUT_DSPIRQ 0x2       /* 0 to interrupt 68000 */
#define DSPPOUT_DMAINTEN 0x4	/* 1 to gate DMA interrupts to DSP IREQ2 */
#define DSPPOUT_DSPOUT 0x8	/* General purpose bit output to Sync connector */
#define DSPPOUT_N_LED_RT 0x10	/* Top LED for right channel (Clipping) - Write 0 to light */
#define DSPPOUT_N_LED_RB 0x20	/* Bottom LED for right channel */
#define DSPPOUT_N_LED_LT 0x40	/* Top LED for left channel */
#define DSPPOUT_N_LED_LB 0x80	/* Bottom LED for left channel */
#else

/* The following are used for compatitibility with later revisions */
/* DSPBIO I/O bit  - DB14=1 for output, DB14=0 for input
   - DB15 is data bit */
#define DSPPOUT_N_READY 0x1	/* 0 if DSP is ready, 1 otherwise */
#define DSPPOUT_DSPIRQ 0x2      /* 0 to interrupt 68000 */
#endif

#define DSPPOUT_DEFAULT 0xf3
