/* $Id: dsp_mode.h,v 1.13 1992/12/20 21:59:29 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Jul 31 00:57:25 EDT 1991
 *
 * Revision History: $Log: dsp_mode.h,v $
 * Revision 1.13  1992/12/20  21:59:29  bst
 * Added DSP_CAP_DEFAULT
 *
 * Revision 1.12  1992/11/04  04:41:29  bst
 * Added DSP capabilities macros.
 *
 * Revision 1.11  1992/09/07  18:29:23  bst
 * Added 'MODE_NOT_PAUSED'.
 *
 * Revision 1.10  1992/07/05  03:45:53  bst
 * Removed MODE_DIRECTION, MODE_TODAT, MODE_FROMDAT.
 *
 * Revision 1.9  1992/05/15  15:16:24  bst
 * Added MODE_PAUSED for internal use by DSP programs.
 *
 * Revision 1.8  1992/05/10  19:10:23  bst
 * Added MODE_PRECISION and MODE_ENCODING.
 *
 * Revision 1.7  1992/01/27  04:06:37  bst
 * Removed MODE_CONVERT, MODE_CUSTOMPGM
 *
 * Revision 1.6  1991/12/16  00:29:26  bst
 * Added MODE_UNDEFINED
 *
 * Revision 1.5  1991/09/27  16:40:35  bst
 * Added definitions for MODE_DIRECTION and MODE_TODAT to make code more
 * readable.
 * Made MODE_CONVERT an alias for MODE_CUSTOMPGM.
 *
 * Revision 1.4  1991/07/31  05:04:27  bst
 * Converted to RCS
 *
 *
 */
#ifndef DSP32C
typedef unsigned short TransferMode;
#endif

/* Mode bits */
#define MODE_LEFT 1         /* Left channel enable */
#define MODE_RIGHT 2        /* Right channel enable */
#define MODE_CONTROL 4      /* Send control bits (and aux data) */
#define MODE_DATA 8	    /* Send data */
#define MODE_IR 0x20        /* Infrared sensor mode - All other mode bits ignored */
#define MODE_SKIPSILENCE 0x40   /* Skip leading silence on read from DAT */
#define MODE_DEBUG 0x80     	/* For debug use only */
#define MODE_PRECISION 0x700	/* Precision of data ((# of nibbles - 1)<<8) */
#define MODE_PREC(n) (((n)/4-1)<<8)
#define MODE_ENCODING 0x3800	/* Encoding of data */
#define MODE_LINEAR 0x0000	/* Linear data */
#define MODE_IEEE   0x0800	/* IEEE 32bit floating point data */
#define MODE_ULAW   0x1000	/* u-Law encoded data */
#define MODE_ALAW   0x1800	/* A-Law encoded data (A&u must share a bit) */
#define MODE_PAUSED 0x8000	/* Used internally by DSP programs to track pause */
#define MODE_NOT_PAUSED 0x7fff	/* ~MODE_PAUSED for use by DSP programs */

/* Mode bits that can be changed by user */
#define MODE_SELECTABLE (MODE_LEFT|MODE_RIGHT|MODE_CONTROL|MODE_DATA|MODE_IR|MODE_SKIPSILENCE|MODE_DEBUG|MODE_PRECISION|MODE_ENCODING)

/* Default operating mode */
#define MODE_DEFAULT (MODE_LEFT|MODE_RIGHT|MODE_DATA|MODE_PREC(16)|MODE_LINEAR)

/* Value to indicate undefined mode */
#define MODE_UNDEFINED 0xffff

/* Capabilities of DSP programs */
#define DSP_CAP_TODAT (1<<0)
#define DSP_CAP_FROMDAT (1<<1)
#define DSP_CAP_MONO (1<<2)
#define DSP_CAP_STEREO (1<<3)
#define DSP_CAP_CONVERSION (1<<4)   /* Sample-rate conversion using 'sconvert' */

/* Default capabilities for programs which do not define them */
#define DSP_CAP_DEFAULT (DSP_CAP_TODAT|DSP_CAP_FROMDAT|DSP_CAP_MONO|DSP_CAP_STEREO)
