/* $Id: dsp_cpu.h,v 1.12 1992/12/17 05:31:53 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Jul 31 00:50:44 EDT 1991
 *
 * Revision History: $Log: dsp_cpu.h,v $
 * Revision 1.12  1992/12/17  05:31:53  bst
 * Added mapped PIO addresses.
 *
 * Revision 1.11  1992/11/08  23:05:53  bst
 * Removed unused FLG_* macros.
 * Added DSPMSG_* macros.
 * Added HOUSEKEEPCNT.
 *
 * Revision 1.10  1992/07/13  05:28:57  bst
 * Use HWRevision instead of CRYSTAL_RX for ifdef.
 * Define AES_RIGHT as 0 for non-Yamaha versions.
 *
 * Revision 1.9  1992/07/11  20:32:54  bst
 * Added FLG_NOMESSAGE, delete FLG_BEGIN.
 *
 * Revision 1.8  1991/11/14  01:17:41  bst
 * Added FLG_HOLD to prevent DSP from accessing PDR.
 *
 * Revision 1.7  1991/10/28  23:20:54  bst
 * Added AES_* bit definitions for CRYSTAL transmitter.
 *
 * Revision 1.6  1991/09/27  16:39:43  bst
 * Changed codes for IOVERRUN
 * Added IUNDERRUN error flag.
 *
 * Revision 1.5  1991/07/31  05:04:27  bst
 * Converted to RCS
 *
 *
 */
/* Flags to uP via PIR */
#define FLG_NOMESSAGE 0x0	/* When there is no message for host */
#define FLG_OVERRUN 0x1000    /* DSP internal buffer overrun */
#define FLG_IOVERRUN 0x1001    /* DSP IBF overrun */
#define FLG_UNDERRUN 0x3000   /* DSP internal buffer underrun */
#define FLG_IUNDERRUN 0x3001    /* DSP OBE underrun */
#define FLG_PROTOERR 0x7000   /* Protocol error */

#define FLG_HOLD 0xf000

/* Messages from host to DSP */
#define DSPMSG_SETPAUSE 0x1
#define DSPMSG_RELEASEPAUSE 0x2

#if HWRevision >= 14
#define AES_DATA 0x0ffffff0
#define AES_PARITY 0x1
#define AES_CSB 0x2
#define AES_USB 0x4
#define AES_VFL 0x8     /* 1 if sample is not valid */
#define AES_AUXDATA 0xf0
#define AES_RIGHT 0x0	/* Non-existent */
#else
/* AES input bits */
#define AES_DATA 0xffffff00
#define AES_CSB 0x4
#define AES_USB 0x8
#define AES_VFL 0x10     /* 1 if sample is not valid */
#define AES_BLK 0x20
#define AES_RIGHT 0x40
#define AES_AUXEN 0x80   /* Used only for output to DAT */
#endif

/* Normally, these bits should be zero */
#define AES_ZEROBITS 0xff00


/* Number of samples/execution of house-keeping functions */
#define HOUSEKEEPCNT 100

/* Map of addresses for reading/writing DSP PIO using NADSP*() routines */
#define MAP_ADDR_MASK  0xffffff00
#define MAP_ADDR_PAR   0xffffff00   /* 16 bit PAR */
#define MAP_ADDR_PDR   0xffffff02   /* 16 bit PDR */
#define MAP_ADDR_ESR   0xffffff04   /* 16 bit ESR */
#define MAP_ADDR_PCR   0xffffff06   /* 16 bit PCR */
#define MAP_ADDR_EMR   0xffffff08   /* 16 bit EMR */
#define MAP_ADDR_PIR   0xffffff0a   /* 16 bit PIR */
#define MAP_ADDR_PARE  0xffffff0c  /* 8 bit PARE */
#define MAP_ADDR_PDR2  0xffffff0e  /* 16 bit PDR2 */
#define MAP_ADDR_IREQ1 0xffffff10  /* Non-zero to interrupt DSP */
