/* $Id: defaults.h,v 1.12 1993/08/27 00:44:29 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Thu Dec 5 23:24:17 EST 1991
 *
 * Revision History: $Log: defaults.h,v $
 * Revision 1.12  1993/08/27  00:44:29  bst
 * Removed getopt() declaration.
 *
 * Revision 1.11  1993/08/10  01:58:02  bst
 * int32 for GetFilterDefaults() nf arg.
 *
 * Revision 1.10  1993/07/05  15:09:24  bst
 * Added note about declaration on alpha.
 *
 * Revision 1.9  1993/06/25  14:35:17  bst
 * Added check for DAT_DEFAULTS_H
 *
 * Revision 1.8  1993/06/23  14:59:11  bst
 * Don't declare getopt() on Alpha.
 *
 * Revision 1.7  1993/05/13  01:28:31  bst
 * Made getopt() declaration compatible with g++.
 *
 * Revision 1.6  1993/04/22  03:08:13  bst
 * Moved P() macro to pmacro.h
 *
 * Revision 1.5  1992/01/30  04:03:08  bst
 * Added FindFile()
 *
 * Revision 1.4  1992/01/27  06:18:22  bst
 * Added AddDefaults()
 * Replaced GetOptions() with getopt()
 *
 * Revision 1.3  1991/12/17  04:43:54  bst
 * Use P() for prototypes.
 * Added GetFilterDefaults()
 *
 * Revision 1.2  1991/12/06  18:43:22  bst
 * Add non-ANSI declarations.
 *
 * Revision 1.1  1991/12/06  04:24:26  bst
 * Initial revision
 */

#ifndef DAT_DEFAULTS_H
#define DAT_DEFAULTS_H

#include "pmacro.h"

/* Options processing */
void InitDefaults P((const char *cmdName));

extern int optind;
extern char *optarg;

/* Locate a file or directory relative to the DAT-Link root directory */
/* return the full path */
const char* FindFile P((const char *filename));

/* Get default or defv if not found */
const char *GetDefault P((const char *p,const char *defv));

/* Get default as a double, return defv if not found */
double GetFloatDefault P((const char *p,double defv));

/* Get default as an integer, return defv if not found */
int GetIntDefault P((const char *p,int defv));

/* Get default as a boolean, return defv if not found */
int GetBoolDefault P((const char *p,int defv));

int GetFilterDefaults P((float *atten,unsigned int32 *nf,float **freqs,
			 float **levels,double ir, double or));

/* Set defaults */
void AddDefaults P((const char *name, const char *value));

#endif /* !DAT_DEFAULTS_H */
