/* $Id: debug.h,v 1.16 1993/08/27 00:44:19 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Thu Dec 5 23:42:31 EST 1991
 *
 * Revision History: $Log: debug.h,v $
 * Revision 1.16  1993/08/27  00:44:19  bst
 * Use HAS_* defines.
 *
 * Revision 1.15  1993/08/10  01:57:17  bst
 * Chnaged NAsyserr() prototype.
 *
 * Revision 1.14  1993/06/28  20:04:32  bst
 * Added definition of LOG_PID if its missing.
 *
 * Revision 1.13  1993/06/25  14:35:06  bst
 * Added check for DAT_DEBUG_H
 *
 * Revision 1.12  1993/06/24  03:11:51  bst
 * Check if __GNUC__ >= 2 before using __attribute__
 *
 * Revision 1.11  1993/06/14  16:19:19  bst
 * Define LOG_DAEMON for machines that lack it.
 *
 * Revision 1.10  1993/05/18  19:39:32  bst
 * Added NALog(), NAOpenlog(), logging levels.
 * Use macros for __attribute__ declarations.
 *
 * Revision 1.9  1993/04/22  18:28:57  bst
 * Include prototypes for C++
 *
 * Revision 1.8  1993/02/05  15:39:51  bst
 * Don't require config.h for compilation.
 * Added conditional compilation on NO_DEBUG_PROTOTYPE (Used by debug.c)
 *
 * Revision 1.7  1993/02/04  23:07:24  bst
 * Include 'config.h'
 * Made declaration of Debug() prototype conditional on STDARGS.
 *
 * Revision 1.6  1992/05/12  18:56:33  bst
 * Don't use __attribute__ on NeXT (Old version of gcc)
 *
 * Revision 1.5  1992/04/07  22:52:36  bst
 * Added GCC __attribute__ to Debug() to check format specifications.
 *
 * Revision 1.4  1992/01/27  06:18:16  bst
 * Added SetDebug()
 *
 * Revision 1.3  1991/12/12  04:38:53  bst
 * Remove REAL_DEBUG_PROTOTYPE nonsense.
 *
 * Revision 1.2  1991/12/06  18:43:00  bst
 * Only declare prototype if ANSI-C or C++
 *
 * Revision 1.1  1991/12/06  04:42:43  bst
 * Initial revision
 *
 */
/* Print a debug message:
 *    dstr - identification name for debug message (routine name)
 *    level - debug level  must be >= abs(level) to print message 
 *          - if level<0, don't print debug labels, just given fmt and args.
 *    fmt,... - printf arguments (fmt=0 to just check if msg would print)
 * Returns 1 if message was printed, 0 otherwise
 */

#ifndef DAT_DEBUG_H
#define DAT_DEBUG_H
#include "pmacro.h"
#include "syscap.h"

#if defined(__STDC__) || defined(__cplusplus) || defined(__BORLANDC__)

#if !defined(__GNUC__) || defined(__GNUG__) || defined(NeXT) || (__GNUC__ < 2)
#define __attribute__(x)
#endif

int DebugCheck (const char *dstr,int level);
#ifndef NO_DEBUG_PROTOTYPE
int Debug (const char *dstr,int level,const char *fmt,...)
           __attribute__ ((format (printf,3,4)));
void NALog (int level,const char *fmt,...) __attribute__ ((format (printf,2,3)));
void DebugCont (const char *fmt,...) __attribute__ ((format (printf,1,2)));
#endif /* !NO_DEBUG_PROTOTYPE */

/* Set debug level - string is of form 'dstr:dlev' or just 'dlev' */
void SetDebug (const char *dlev);
/* Start logging */
void NAOpenlog(const char *ident, int logopt, int facility);
#endif /* __STDC__ || __cplusplus || __BORLANDC__ */

char *NAsyserr P((void));

#ifdef HAS_syslog_h
#include <syslog.h>
#else /* HAS_syslog_h */
#define LOG_ERR 3
#define LOG_WARNING 4
#define LOG_NOTICE 5
#define LOG_INFO 6
#define LOG_DEBUG 7
#endif /* !HAS_syslog_h */

/* Define some macros if they are missing */
#ifndef LOG_DAEMON
#define LOG_DAEMON 0
#endif /* !LOG_DAEMON */

#ifndef LOG_PID
#define LOG_PID 0
#endif /* !LOG_PID */

#endif /* !DAT_DEBUG_H */
