/* $Id: datlink.h,v 1.64 1996/03/19 20:56:13 eryk Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 14:59:12 EDT 1991
 *
 * Revision History: $Log: datlink.h,v $
 * Revision 1.64  1996/03/19  20:56:13  eryk
 * Reduced OPTIMUM_TRANSFER_LENGTH to 51200 under WIN32
 *
 * Revision 1.63  1994/07/14  07:16:38  bst
 * Removed reduced transfer length for NEWS - problem was in firmware and was
 * fixed long ago.
 *
 * Revision 1.62  1993/11/01  22:09:10  bst
 * Added statType to DL_Status struct.
 *
 * Revision 1.61  1993/10/05  00:59:13  bst
 * Moved const define to dat_types.h
 *
 * Revision 1.60  1993/10/04  02:05:07  bst
 * Added dat_getMax{Read,Write}Size(), dat_get{T,R}XModel(), dat_getSN().
 *
 * Revision 1.59  1993/08/10  02:59:58  bst
 * Added dat_setAutoStatus()
 * Don't remove const for BORLAND-C
 *
 * Revision 1.58  1993/06/25  14:36:00  bst
 * Modified comment.
 *
 * Revision 1.57  1993/06/23  20:05:06  bst
 * Changed 'long' to 'int32'.
 * Moved typedefs to dat_types.h
 *
 * Revision 1.56  1993/06/13  20:58:25  bst
 * Use 'sony_news' instead of 'sony' for conditional compilation.
 *
 * Revision 1.55  1993/05/21  17:39:21  bst
 * Added 'stat' arg to dat_read().
 * Renamed 2nd arg to dat_setMode() from 'todat' to 'modeCode'.
 * Reduce OPTIMUM_TRANSFER_LENGTH to 8192 on Sony.
 *
 * Revision 1.54  1993/04/22  18:45:45  bst
 * Don't define const as null under C++
 *
 * Revision 1.53  1993/04/22  03:34:01  bst
 * Use P() macro.
 *
 * Revision 1.52  1993/04/12  02:15:45  bst
 * Use long when 32-bit integers required.
 *
 * Revision 1.51  1993/03/15  20:39:02  bst
 * Changed calling format of dat_getErrorLog().
 *
 * Revision 1.50  1993/03/10  03:44:20  bst
 * Replace dat_begin{Read,Write}() with dat_beginIO().
 *
 * Revision 1.49  1993/02/23  21:31:19  bst
 * Added some 'const' qualifiers to 'Program *' args.
 *
 * Revision 1.48  1993/02/23  16:56:16  bst
 * Use PGMSpecs for args to dat_getDSPProgram
 *
 * Revision 1.47  1992/11/21  03:11:40  bst
 * Added DL_DIAG_LEDTEST, get_getErrorLog().
 *
 * Revision 1.46  1992/11/08  23:03:22  bst
 * Renamed 'internalReady' to 'pout_shadow'
 *
 * Revision 1.45  1992/11/08  22:58:48  bst
 * Added dat_dspMessage().
 *
 * Revision 1.44  1992/11/04  04:41:19  bst
 * Added 'pgm' arg to dat_getDSPProgram().
 *
 * Revision 1.43  1992/11/01  22:47:52  bst
 * Added VULevel_scale DSP status variable.
 *
 * Revision 1.42  1992/09/09  04:09:43  bst
 * Removed 'dat_debug'
 * Removed trailing nulls from file.
 *
 * Revision 1.41  1992/09/08  02:30:26  bst
 * Modified DL_Status struct: added internalReady, pause->error.
 *
 * Revision 1.40  1992/08/11  21:00:13  bst
 * Moved defines outside of #ifdef STDC
 *
 * Revision 1.39  1992/07/12  15:51:37  bst
 * Added dat_setDiagnostic().
 *
 * Revision 1.38  1992/07/10  04:25:44  bst
 * Added 'isword' arg dat_dsp[GS]etParameter().
 *
 * Revision 1.37  1992/07/05  03:59:51  bst
 * Added dat_dspSetSIOMode().
 * Added 'todat' argument to dat_getDSPProgram.
 * Removed dat_getMode().
 * Added 'todat' argument to dat_setMode.
 * Added DL_StatusIO to break out identical record and playback fields.
 * Added siomode to DL_Status.
 *
 * Revision 1.36  1992/06/27  22:20:16  bst
 * Added params functions, DSP memory architecture functions.
 * Remove DSP_MEMSIZE macro.
 *
 * Revision 1.35  1992/05/01  17:08:11  bst
 * Added dat_serialRead(), dat_serialWrite()
 *
 * Revision 1.34  1992/01/28  05:57:46  bst
 * Added impulse args to dat_getDSPProgram()
 *
 * Revision 1.33  1992/01/27  04:05:45  bst
 * dat_setMode() no longer sets DSP program.
 *
 * Revision 1.32  1992/01/17  04:24:40  bst
 * Added second arg (devname) to dat_open(), dat_open_nrl()
 *
 * Revision 1.31  1992/01/10  04:23:29  bst
 * dspStatus now includes error info in high bytes.
 *
 * Revision 1.30  1991/12/17  04:48:54  bst
 * Added additional args for filtering to dat_getDSPProgram()
 *
 * Revision 1.29  1991/12/17  02:59:03  bst
 * Added 'gain' to status data.
 * Pass DSP program to dat_dsp{Set,Get}Parameter()
 * Added dat_dsp{Set,Get}Float()
 *
 * Revision 1.28  1991/12/16  00:16:57  bst
 * Added pause, mode DSP variables.
 *
 * Revision 1.27  1991/12/12  04:22:12  bst
 * Added dat_dspLoadProgram()
 *
 * Revision 1.26  1991/12/06  14:26:45  bst
 * Removed old definitions of dat_get*default,dat_getopt(),Debug()
 *
 * Revision 1.25  1991/12/05  05:02:28  bst
 * Always use BLOCK_LENGTH of 512 on UNIX (other sun's may not use variable lenn)
 *
 * Revision 1.24  1991/12/05  02:31:31  bst
 * Bracket defn of byte,word,True,False,etc in #ifndef True
 * Made InputSource an 'int' instead of 'enum'.
 * Added defines of DL_ISRC_* instead of enumerators.
 * Added more fields to DLStatus.
 * Bracketted defaults processing by #ifndef V2
 * Added declaration of dat_getDSPProgram() to non-ANSI declarations.
 * Changed minimum BLOCK_LENGTH (sun & mac) to 2 instead of 1
 *
 * Revision 1.23  1991/11/22  06:31:48  bst
 * Moved definition of DSP_MEMSIZE out of conditional section.
 *
 * Revision 1.22  1991/11/22  04:31:57  bst
 * Increased maximum number of arguments to Debug()
 *
 * Revision 1.21  1991/11/21  23:27:14  bst
 * Separate building a DSP program and setting DAT-Link mode into 2 functions:
 *      dat_getDSPProgram() and dat_setMode()
 *
 * Revision 1.20  1991/11/14  05:42:15  bst
 * Removed DL_DSPParams structure.
 * Added new dat_dsp{Get,Set}Parameter() functions.
 *
 * Revision 1.19  1991/11/14  01:16:15  bst
 * Added DL_DSPParams structure.
 * Moved contents of dat_dsp.h here.
 * Added dat_dspGetParams()
 * Renamed dsp_{write,read} to dat_dsp{Write,Read}
 *
 * Revision 1.18  1991/11/12  06:12:22  bst
 * Added dat_get*Default() routines.
 *
 * Revision 1.17  1991/11/11  05:18:32  bst
 * Added true prototype for Debug() if REAL_DEBUG_PROTOTYPE is defined.
 *
 * Revision 1.16  1991/11/11  04:10:09  bst
 * Added dat_getDefault(), dat_getOptDefault(), and dat_initDefaults()
 * Use prototypes if __cplusplus is defined.
 * Added Debug() procedure.
 *
 * Revision 1.15  1991/11/08  06:16:16  bst
 * Use block length of 1 for SUN. (Faster for messages)
 *
 * Revision 1.14  1991/10/20  20:22:31  bst
 * Added dat_open_nrl()
 *
 * Revision 1.13  1991/10/19  19:03:31  bst
 * Added uptime field to status.
 *
 * Revision 1.12  1991/10/04  02:17:45  bst
 * Don't remove 'const' qualifiers for C++.
 *
 * Revision 1.11  1991/10/03  14:46:46  bst
 * Removed dat_waitForData, added dat_nAvail
 *
 * Revision 1.10  1991/09/27  16:39:15  bst
 * Added sampling rate arguments to dat_setMode().
 * Remove dat_setSamplingRate()
 *
 * Revision 1.9  1991/09/16  05:14:40  bst
 * Changed some function names to make them more consistent.
 *
 * Revision 1.8  1991/09/09  05:15:01  bst
 * Make typedef of InputSource regardless of whether STDC is set.
 *
 * Revision 1.7  1991/08/27  02:27:22  bst
 * Added dat_version()
 *
 * Revision 1.6  1991/08/27  02:03:04  bst
 * Added setinputsrc function.
 *
 * Revision 1.5  1991/08/24  00:00:09  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.4  1991/08/23  16:08:03  bst
 * Broke out low level interface into host_if.h
 * Remove data_setDataFormat()
 *
 * Revision 1.3  1991/08/20  23:26:30  bst
 * Changed interface to getU(),setU(),getC(), and setC().
 *
 * Revision 1.2  1991/08/05  18:59:16  bst
 * Add RCS header.
 *
 *
 */
#ifndef DATLINK_H
#define DATLINK_H

#include "pmacro.h"
#include "dat_types.h"

typedef int dat_fd;

/* Values for dat_setclock() */
#define CLK_RATE 3
#define CLK_32000 0
#define CLK_44100 1
#define CLK_48000 2
#define CLK_Input 3
#define CLK_ExtWOut 4
#define CLK_ExtWIn 8

/* Structure returned by dat_getStatus() */
typedef struct {
    int32 transferStatus; 	/* 0-idle, 1-transferring to DAT, 3-error */
    int32 bufferSize;  		/* Size of buffer in bytes */
    int32 bufferUtilization;  	/* Number of bytes currently occupied */
    unsigned int32 transferMode;/* Transfer mode */
    int32 overrun;		/* Over/Under run */
    /* The next set are DSP variables */
    unsigned int32 sampleNumber;/* Current DAT sample number */
    float VULevel_left;		/* VU level */
    float VULevel_right;	/* VU level */
    float VULevel_scale;	/* Scale factor for VU levels */
    float VUDecay;		/* VU decay constant */
    float gain;			/* Gain */
    word error;			/* Error state */
    word mode;			/* Mode */
    /* mode must be the last DSP variable */
    /* We should end on a 32bit word boundary to guarantee alignment */
} DL_StatusIO;

#define STAT_XFR_SIZE 512	/* Size of transfers of status during autoStatus */
    
typedef struct {
    int32 locked;    		/* True if receiving data from DAT */
    int32 dspStatus;    		/* 0-running, 1-halted + (error code << 8) */
    unsigned int32 uptime;	/* Uptime in seconds */
    byte swrev;			/* SW revision */
    byte hwrev;			/* HW revision */
    byte AESstat1;		/* AES RX status register 1 */
    byte AESstat2;		/* AES RX status register 2 */
    byte lcstat[24];		/* Left channel status (incoming) */
    byte rcstat[24];		/* Right channel status (incoming) */
    byte ubits[4];		/* User bits (incoming) */
    byte siomode;		/* DSP SIO Mode */
    byte statType;		/* 1 for partial, 0 for full */
    byte filler[2];		/* Keep things 32-bit word aligned */
    DL_StatusIO pb;
    DL_StatusIO rec;
    word pout_shadow;		/* See dspmem.h for bit definitions */
} DL_Status;

/* Input source */
#define DL_ISRC_ALL 0
#define DL_ISRC_RCA 1
#define DL_ISRC_AES 2
#define DL_ISRC_FIBER 3
typedef int InputSource;   /* For backward compatibility */

/* Values for 'diagnostic' */
#define DL_DIAG_CLEAR 0
#define DL_DIAG_RAMTEST 1
#define DL_DIAG_LEDTEST 2

/* DSP Partitions and memory types */
#define MAXDSPPARTITIONS 4
#define DSPMEMTYPE_RAM 0
#define DSPMEMTYPE_ROM 1


#ifdef __cplusplus
extern "C" {
#endif

/* If any of the following returns an error flag, the global varibal dat_errno
   will be set as given in dat_errno.h.  dat_perror() can be used to print a 
   message in the same way as the libc perror().
 */
void dat_perror P((const char *));

/*
 * Open connection to DAT-Link of given unit number
 * Use unit number -1 for default unit.
 * Use devname==0 to use default device name
 * returns descriptor for subsequent operations or -1 for
 * error.
 */
dat_fd dat_open P((int unit, const char *devname));

/*
 * Open without using any soft copies of the firmware.
 */
dat_fd dat_open_nrl P((int unit, const char *devname));

/*
 * Close connection to DAT-Link after flushing all
 * data. Return -1 for error.
 */
int dat_close P((dat_fd dt));

/*
 * Write data to DAT tape
 *	data - data to write
 *	nwords - number of words to write
 * Returns:
 *        number of bytes written, or -1 to indicate error
 */
int32 dat_write P((dat_fd dt, const byte *data, int32 nbytes));

/*
 * Beginning transferring between  DAT-Link internal memory and
 * DAT machine if transfers have not already begun.
 */
int dat_beginIO P((dat_fd dt,int rd, int wr));

/*
 * Wait for write to terminate
 */
int dat_flushWrite P((dat_fd dt));

/*
 * Check how much data is available to read 
 */
int32 dat_nAvail P((dat_fd dt));

/*
 * Read data from DAT machine
 *	data - pointer to buffer for incoming data
 *	nbytes - number of words to transfer
 *	stat - if non-zero, retrieve status at end of data buffer and
 *	       adjust 'stat' to point at it.  'nbytes' and return value
 *             do NOT include status information.
 * Returns:
 *	number of words written, or -1 for error
 */
int32 dat_read P((dat_fd dt, byte *data, int32 nbytes, DL_Status **stat));

/* Seek to given sample number, then read
 */
int dat_seekRead P((dat_fd dt,int32 position));

/* Reset DAT-Link
 */
int dat_reset P((dat_fd dt));

/* Clear inputs buffers and put DAT-Link into idle state 
 */
int dat_clearTransfers P((dat_fd dt));


/* Build a DSP program to satisfy given requirements  - todat or fromdat
   may be null to indicate 1-way transfers */
struct PGMSpecs;

struct Program *dat_getDSPProgram P((dat_fd dt, const struct Program *pgm,
				     struct PGMSpecs *todat,
				     struct PGMSpecs *fromdat));

/* Set mode bits takes effect at beginning of next transfer */
int dat_setMode P((dat_fd dt, int modeCode, int newmode));

/* Get up to nalloc bytes of U data into udat, return actual # of bytes available */
int dat_getU P((dat_fd dt, byte *udat, unsigned int nalloc));

/* Set U data, "udat" is a pointer to "nbytes" bytes of data */
int dat_setU P((dat_fd dt, const byte *udat, unsigned int nbytes));

/* Get or set C data, always 48 bytes (24 left, 24 right) */
int dat_getC P((dat_fd dt, byte cdat[48]));
int dat_setC P((dat_fd dt, const byte cdat[48]));

/* Set clock source for output to DAT.
 * Also, set whether or not unit should generate a word clock output.
 * Note: DAT input is always self-clocking.
 */
int dat_setClock P((dat_fd dt, int clk));

/* Set input source */
int dat_setInputSource P((dat_fd dt, int source));

/* Get status of DAT-Link */
int dat_getStatus P((dat_fd dt,DL_Status *stat));

/* Set autostatus on each read (uneeded if dat_read() used */
int dat_setAutoStatus P((dat_fd dt, int enable));

/* Serial I/O */
int dat_serialRead P((dat_fd dt,int port,char *buf,int nbytes));
int dat_serialWrite P((dat_fd dt,int port,const char *buf,int nbytes));

/* Get ROM checksum */
int dat_checksum P((dat_fd dt));
/* Get revision numbers */
int dat_version P((dat_fd dt));
/* Various other parameters */
int dat_RAMExecution P((dat_fd dt));
int dat_Emulation P((dat_fd dt));
int dat_SCSISwitchSetting P((dat_fd dt));
int dat_DIPSwitchSetting P((dat_fd dt));
int32 dat_getMaxReadSize P((dat_fd dt));
int32 dat_getMaxWriteSize P((dat_fd dt));
int dat_getTXModel P((dat_fd dt));
int dat_getRXModel P((dat_fd dt));
int dat_getSN P((dat_fd dt));

/* Clear cached values of parameters */
void dat_clearParameters P((dat_fd dt));

/* Enable a diagnostic mode */
int dat_setDiagnostic P((dat_fd dt, int diagnostic, int value));

/* Retrieve firmware error log from DAT-Link */
int dat_getErrorLog P((dat_fd dt, char *buf, unsigned int buflen));

/*
 * Routines to access DSP32C
 */
/* Get the size or start address of DSP memory blocks */
int32 dat_getDSPMemSize P((dat_fd dt,int block));
int32 dat_getDSPStartAddr P((dat_fd dt,int block));

/* Get the type of a DSP memory block */
int dat_getDSPMemType P((dat_fd dt,int block));

/* Load the DSP32 with a program */
int dat_dspLoadProgram P((dat_fd dt, const struct Program *pgm));

/* Read DSP32 memory (byte order will be the DSP32C order, byte 0=LSB,1,2,3=MSB) */
/* nbytes must be even */
int dat_dspRead P((dat_fd dt, unsigned int32 dspAddr, byte *buffer,
		   unsigned int nbytes));

/* Write DSP32 memory (byte order will be the DSP32C order, byte 0=LSB,1,2,3=MSB) */
/* nbytes must be even */
int dat_dspWrite P((dat_fd dt, unsigned int32 dspAddr, const byte *buffer,
		    unsigned int nbytes));

/* Set/Get DSP32 program parameter by name (isword==1 for words, 0 for ints) */
int dat_dspGetParameter P((dat_fd dt, const struct Program *pgm,
			   const char *parameter, int32 *value, int isword));
int dat_dspSetParameter P((dat_fd dt, const struct Program *pgm,
			   const char *parameter, int32 value, int isword));

/* Set/Get DSP32 float variables by name */
int dat_dspGetFloat P((dat_fd dt, const struct Program *pgm,
		       const char *parameter, float *value));
int dat_dspSetFloat P((dat_fd dt, const struct Program *pgm,
		       const char *parameter, double value));

/* Send a message to the DSP32C (nwords is number of 16-bit words to send) */
int dat_dspMessage P((dat_fd dt, unsigned int nwords, const word *msg));

/* Set DSP32 SIO Mode */
int dat_dspSetSIOMode P((dat_fd, int siomode));

#ifdef __cplusplus
}
#endif

/* Block length definitions */
#ifdef macintosh
#define BLOCK_LENGTH 2
#else
#define BLOCK_LENGTH 512
#endif

/* Optimum length for read/write transfers */
#ifdef __WIN32__
/* it seems that aspi32 doesn't support transfers larger than that */
#define OPTIMUM_TRANSFER_LENGTH 51200L
#else
#define OPTIMUM_TRANSFER_LENGTH 64512L
#endif /* __WIN32__ */

#endif /* !DATLINK_H */
