/* $Id: dat_types.h,v 1.4 1996/03/19 20:54:26 eryk Exp $
 *
 * Copyright 1993 Brent Townshend (bst@tc.com)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Wed Jun 23 15:39:23 EDT 1993
 *
 * Revision History: $Log: dat_types.h,v $
 * Revision 1.4  1996/03/19  20:54:26  eryk
 * Changed SIZEOF_INT to 4 under WIN32
 *
 * Revision 1.3  1993/11/16  01:57:46  bst
 * Added ifdef for mac to avoid compiler complaint.
 *
 * Revision 1.2  1993/10/05  01:02:14  bst
 * Added define of const
 *
 * Revision 1.1  1993/10/05  00:09:30  bst
 * Initial revision
 *
 */
#ifndef DAT_TYPES_H
#define DAT_TYPES_H

typedef unsigned char byte;
typedef unsigned short word;
typedef byte boolean;
#define True 1
#define False 0

/* Remove const qualifier for non-ANSI, non-C++ */
#ifndef macintosh
/* Mac doesn't like 'defined(const)' for some reason */
#if !defined(__STDC__) && !defined(__cplusplus) && !defined(const) && !defined(__BORLANDC__)
#define const
#endif /* !__STDC__ && !__cplusplus && !const && !__BORLANDC */
#endif /* !macintosh */

#ifndef SIZEOF_INT
#ifdef MSDOS
#ifdef __WIN32__
#define SIZEOF_INT 4
#else
#define SIZEOF_INT 2
#endif /* __WIN32__ */
#else
#define SIZEOF_INT 4
#endif /* MSDOS */
#endif /* !SIZEOF_INT */

/* NOTE:
 *    Use 'int' for small integers (less than 16 bits)	       (16-64 bits)
 *    Use 'int32' for numbers that need to be up to 32 bits.   (always 32 bits)
 *    Use 'long' only for compatibility with system libraries. (may be 64 bits)
 */
#if SIZEOF_INT == 2
#define int32 long
#else
#define int32 int
#endif

typedef unsigned int32 uint32;
#endif /* !DAT_TYPES_H */
