/* $Id: dat_remote.h,v 1.10 1993/08/10 01:56:44 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 15:35:27 EDT 1991
 *
 * Revision History: $Log: dat_remote.h,v $
 * Revision 1.10  1993/08/10  01:56:44  bst
 * Change dat_list*() args to int32.
 * ,
 *
 * Revision 1.9  1993/06/25  14:34:19  bst
 * Added check for DAT_REMOTE_H
 *
 * Revision 1.8  1993/04/22  18:28:40  bst
 * Use P() macro.
 *
 * Revision 1.7  1991/12/08  20:29:01  bst
 * Added dat_listDevices()
 *
 * Revision 1.6  1991/12/06  18:42:37  bst
 * Added declaratoin of dat_listCommands() for non-ANSI compilers.
 *
 * Revision 1.5  1991/12/06  06:04:01  bst
 * New syntax for dat_listCommands()
 *
 * Revision 1.4  1991/10/25  03:45:26  bst
 * *** empty log message ***
 *
 * Revision 1.3  1991/10/20  18:31:05  bst
 * Made RMTCommand data field dynamic allocated.
 *
 * Revision 1.2  1991/08/23  23:54:28  bst
 * Modified function declarations to work with non-ANSI compilers
 *
 * Revision 1.1  1991/08/05  19:35:54  bst
 * Initial revision
 *
 *
 */

#ifndef DAT_REMOTE_H
#define DAT_REMOTE_H

/* Low level remote access */
/* Must be composed only of shorts */
typedef struct {
    word ndata,carrierOn,carrierOff;
    word data[1];
} RMTCommand;

/* Low level remote access */
void dat_sendIR P((dat_fd dt, const RMTCommand *ircmd));
/* Stop IR generation if any is going on */
void dat_stopIR P((dat_fd dt));

/* Set remote descriptor for DAT unit to given devname.
   If devname==0, use environment variable DAT_RC, but if its not set return
       -2 if no device specified,
   Return -1 if other failure
 */
int dat_setDevice P((dat_fd dt, char *devname));

/* Save remote descriptor for DAT unit */
int dat_saveDevice P((dat_fd dt, char *devname));

/* Lookup a remote command and get index in descriptor (-1 if failure) */
int dat_lookupCommand P((char *cmdName));

/* Get list of valid commands */
char **dat_listCommands P((unsigned int32 *len));

/* Get list of valid devices */
char **dat_listDevices P((unsigned int32 *len));

/* Execute a remote command (-1 if failure) */
int dat_remote P((dat_fd dt, char *cmd));

/* Learn a new device operation
 */
void dat_remoteLearn P((dat_fd dt, char *cmd, int seqLen, word data[]));

/* Commands to switch between IR training mode */
void dat_trainBegin P((dat_fd dt));
void dat_trainEnd P((dat_fd dt));

#endif /* !DAT_REMOTE_H */
