/* $Id: dat_errno.h,v 1.6 1993/06/25 14:34:03 bst Exp $
 *
 * Copyright 1991 Brent Townshend (bst%tt@cam.org)
 * Townshend Computer Tools
 * Montreal, Quebec
 *
 * Mon Aug 5 15:35:25 EDT 1991
 *
 * Revision History: $Log: dat_errno.h,v $
 * Revision 1.6  1993/06/25  14:34:03  bst
 * Added comment to endif.
 *
 * Revision 1.5  1992/11/04  04:32:23  bst
 * Added EDLBADPGM error.
 *
 * Revision 1.4  1991/11/11  04:34:17  bst
 * Added EDLLOSTLOCK error
 *
 * Revision 1.3  1991/09/27  17:57:32  bst
 * Added new error codes: EDLNOTIDLE
 *
 * Revision 1.2  1991/09/27  14:52:59  bst
 * Added new error codes.
 *
 * Revision 1.1  1991/08/05  19:35:54  bst
 * Initial revision
 *
 *
 */
/*
 * Error codes set by DAT-Link library routines
 *
 * Note: some error routines leave dat_errno as 0 but set the system errno
 */

#ifndef DAT_ERRNO_H
#define DAT_ERRNO_H

#define EDLOVERRUN	1	/* DAT-Link internal buffer overrun */
#define EDLUNDERRUN	2	/* DAT-Link internal buffer underrun */
#define EDLDSP		3	/* DSP error */
#define EDLSNDMSG	4	/* Error sending message to DAT-Link */
#define EDLRCVMSG	5	/* Error receiving message from DAT-Link */
#define EDLBADMSG	6	/* Bad message from DAT-Link */
#define EDLMSGREJECT	7	/* Message rejected by DAT-Link */
#define EDLFLUSH	8	/* DAT-Link buffer is not draining */
#define EDLBADMODE	9	/* Bad mode bit setting */
#define EDLNOTIMPL	10	/* Unimplemented feature */
#define EDLBADARG	11	/* Bad argument(s) to a command */
#define EDLSCONV	12	/* Unable to implement requested sample-rate conv */
#define EDLDIRECTION	13	/* Attempt to transfer data in wrong direction */
#define EDLNOTIDLE	14	/* Attempt to change mode while transfers pending */
#define EDLLOSTLOCK	15	/* Dropped signal from DAT */
#define EDLBADPGM	16	/* Incompatible or bad DSP program */
extern int dat_errno;		/* Error number */
#endif /* !DAT_ERRNO_H */
