// file: /u1/picone/jeida/excise_signal/get_params.cc
//
// a simple command line parser
//

// system include files
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "excise_signal.h"

// function: get_parameters_C
//
// arguments:
//
//  int argc: argc from the main program
//  char** argv: argv from the main program
//  float_4& sample_freq: sample frequency in hz
//  float_4& start_time: start time in seconds
//  float_4& end_time: end time in seconds
//  int_4& num_bytes: number of bytes per sample
//  int_4& num_chan: number of channels per sample
//  int_4& out_mode: output mode (channel 0 [0], channel 1 [1], stereo [2])
//  float_4& pad_time: time to pad on either side of the excised data
//  logical_1& feather_mode: sets the feathering mode
//  logical_1& swap_bytes: sets the byte ordering - necessary for feathering
//  float_4& scale_value: scale factor for the data points
//  char_1* file_in: source file
//  char_1* file_out: output file
//
// return value: a logical_1 indicating status
//
// this function parses command line arguments
//
logical_1 get_parameters_C(int argc, char** argv, float_4& sample_freq,
			   float_4& start_time, float_4& end_time,
			   int_4& num_bytes,int_4& num_chan,
			   int_4& out_mode, float_4& pad_time,
			   logical_1& feather_mode, logical_1& swap_bytes,
			   float_4& scale_value,  char_1* file_in,
			   char_1* file_out){

  // main decoding loop
  //
  for (int_4 index=1; index<argc; index++) {

    // pick off input filename
    //
    if (strcmp(ISIP_OPT_SCALE, argv[index]) == (int)0) {
      scale_value = (float_4)atof(argv[index+(int)1]);
    }

    // pick off input filename
    //
    if (strcmp(ISIP_OPT_INFILE, argv[index]) == (int)0) {
      strcpy((char*)file_in, argv[index+(int)1]);
    }

    // pick off output filename
    //
    else if (strcmp(ISIP_OPT_OUTFILE, argv[index]) == (int)0) {
      strcpy((char*)file_out, argv[index+(int)1]);
    }

    // pick off sample frequency
    //
    else if (strcmp(ISIP_OPT_SF, argv[index]) == (int)0) {
      sample_freq = atof(argv[index+(int)1]);
    }

    // pick off the output mode
    //
    else if (strcmp(ISIP_OPT_OMODE, argv[index]) == (int)0) {
      out_mode = atoi(argv[index+(int)1]);
    }

    // pick off the pad time
    //
    else if (strcmp(ISIP_OPT_PAD, argv[index]) == (int)0) {
      pad_time = atof(argv[index+(int)1]);
    }

    // pick off the feather mode
    //
    else if (strcmp(ISIP_OPT_FEATHER, argv[index]) == (int)0) {
      feather_mode = ISIP_TRUE;
    }

    // pick off the feather mode
    //
    else if (strcmp(ISIP_OPT_SWAP, argv[index]) == (int)0) {
      swap_bytes = ISIP_TRUE;
    }

    // pick off start time
    //
    else if (strcmp(ISIP_OPT_START, argv[index]) == (int)0) {
      start_time = atof(argv[index+(int)1]);
    }

    // pick off end time
    //
    else if (strcmp(ISIP_OPT_END, argv[index]) == (int)0) {
      end_time = atof(argv[index+(int)1]);
    }

    // pick off number of bytes
    //
    else if (strcmp(ISIP_OPT_NBYTES, argv[index]) == (int)0) {
      num_bytes = atoi(argv[index+(int)1]);
    }

    // pick off number of channels
    //
    else if (strcmp(ISIP_OPT_NCHAN, argv[index]) == (int)0) {
      num_chan = atoi(argv[index+(int)1]);
    }
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}


