// file: es_swap.cc
//
// a routine to swap bytes for the given buffer
//

// system include files
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "excise_signal.h"

// function: buffer_swap_bytes_cc
//
// arguments:
//
//  char_1* buffer: buffer of byte data where every two bytes represents a
//                  sample
//  int_4 num_samples: number samples to swap bytes for
//
// return value: a logical_1 indicating status
//
// this function swaps the most significant byte and the least significant
// byte for each sample
//
logical_1 buffer_swap_bytes_cc(char_1* buffer_a, int_4 num_samples_a) {

  // set a pointer to the beginning of the buffer
  //
  char_1* temp = buffer_a;
  char_1 samp;
  for (int_4 i = 0; i < num_samples_a; i++) {
    samp = temp[0];
    temp[0] = temp[1];
    temp[1] = samp;
    temp = temp + 2;
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}


