// file: es_scale_0.cc
//
// 

// system include files
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "excise_signal.h"

// function: buffer_scale_cc
//
// arguments:
//
//  char_1* buffer: (input/output) buffer to feather
//  int_4 num_samples: (input) number of samples
//  int_4 num_chan: number of channels per sample
//  float_4 scale_value: scale_value
//
// return value: a logical_1 indicating status
//
// this function parses command line arguments
//
logical_1 buffer_scale_cc(char_1* buffer_a, int_4 num_samples_a,
			  int_4 num_chan_a, float_4 scale_value_a) {

  // declare a temp var
  //
  float_4 temp = 0;

  for (int_4 chan = 0; chan < num_chan_a; chan++) {

    // set the location of the samples buffer
    // declare a pointer to a buffer of 16-bit integers
    //
    int_2* samples = (int_2*)buffer_a;
    samples = samples + chan;
    
    // loop over all samples
    //
    for (int_4 samp = 0; samp < num_samples_a; samp++) {

      // multiply the sample by a scaling factor
      //
      temp = ((float_4)(samples[0]) * scale_value_a);

      // check the ranges on the value
      //
      if (temp > (float_4)SHRT_MAX) {
	temp = (float_4)SHRT_MAX;
      }
      else if (temp < (float_4)SHRT_MIN) {
	temp = (float_4)SHRT_MIN;
      }

      // set the current sample
      //
      samples[0] = (int_2)temp;
      
      // increment the pointer to the current sample
      //
      samples = samples + num_chan_a;
    }
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}


