// file: es_feath_0.cc
//
// 

// system include files
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// isip include files
//
#include <integral.h>
#include <integral_constants.h>

// local include files
//
#include "excise_signal.h"

// function: buffer_feather_cc
//
// arguments:
//
//  char_1* buffer: (input/output) buffer to feather
//  int_4 num_samples: (input) number of samples
//  int_4 num_chan: number of channels per sample
//
// return value: a logical_1 indicating status
//
// this function parses command line arguments
//
logical_1 buffer_feather_cc(char_1* buffer_a, int_4 num_samples_a,
			    int_4 num_chan_a, int_4 direction_a) {


  for (int_4 chan = 0; chan < num_chan_a; chan++) {

    // set the location of the samples buffer
    // declare a pointer to a buffer of 16-bit integers
    //
    int_2* samples = (int_2*)buffer_a;
    samples = samples + chan;
    
    // loop over all samples
    //
    for (int_4 samp = 0; samp < num_samples_a; samp++) {

      // multiply the sample by a quarter cosine wave in the appropriate
      // direction
      //
      if (direction_a == FEATHER_BEGINNING) {
	samples[0] = (int_2) ((float_4)samples[0] *
			      cos((M_PI/(float_4)2.0) *
				  (((float_4)samp / (float_4)num_samples_a) -
				  (float_4)1.0)));
      }
      else {

	samples[0] = (int_2) ((float_4)samples[0] *
			      cos((M_PI/(float_4)2.0) *
				  ((float_4)samp / (float_4)num_samples_a)));
      }
      
      // increment the pointer to the current sample
      //
      samples = samples + num_chan_a;
    }
  }

  // exit gracefully
  //
  return ISIP_TRUE;
}


