// file: spec_plot.h
//

// make sure definitions are made only once
//
#ifndef __ISIP_SPEC_PLOT
#define __ISIP_SPEC_PLOT

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

#ifndef __ISIP_SPEC_PLOT_CONSTANTS
#include "spectrogram_plot_constants.h"
#endif

// system include files
//
#include <tk.h>
//#include <tkInt.h>
//#include <tkPort.h>

// item: Spec_plot_item
//
// this file defines a structure for the Tk widget Spec_plot. this widget
// will show the amplitude vs time plot of a audio signal
//
typedef struct Spec_plot_item {
  
  // required for all canvas sub-items
  //
  Tk_Item header;				// MUST BE FIRST THING IN
  // STRUCTURE
  // interpreter for this widget
  //
  Tcl_Interp* interpreter;
  
  // required data
  //
  Tk_Canvas canvas;				// canvas containing item
  
  // geometry data
  //
  double x;					// defines the x and y coords
  double y;					//    of the insertion point
  //    in canvas units
  int x_loc;					// defines the x and y coords
  int y_loc;					//    of the insertion points
  //    in pixels
  int width;					// desired width of window
  int height;					// desired height of window
  int depth;					// desired depth of window
  //    don't count on these to
  //    be true
  double* coord_ptr;				// coordinates of widget bounds
  
  // graphics settings
  //
  int border_width;				// size of 3-D border
  int relief;					// style of 3-D border
  Tk_3DBorder background;			// color for border, background
  XColor* foreground;				// color for the text
  XColor* highlight;				// color for the highlight
  XColor* highlight_bg;				// color for the highlight bg
  GC highlight_gc;				// window graphics contexts
  GC text_gc;					// text graphics contexts
  int highlight_width;				// thickness of the highlight
  int padX;					// horizontal padding
  int padY;					// vertical padding
  int flags;					// status flags
  char* font;					// font string
  
  // widget specific data
  //
  XImage* Gimage;                               // image map
  char* file_name_d;				// name of file to read from
  int_4 num_chans_d;				// number of channels in file
  int_4 num_bytes_d;				// number of bytes per sample
  int_4 display_channel_d;			// channel to display
  double sf_d;					// sample rate
  int swap_byte_flag_d;				// type of byte swapping
  double start_time_d;				// start time of window
  double end_time_d;				// end time of window
  double gain_factor_d;				// end time of window  
  int_4 debug_level_d;				// debug level
  double contrast_d;                            // spectrogram contrast
  double brightness_d;                          // spectrogram brightness
  double win_length_d;                          // window length
  double frame_length_d;                        // frame length
  double pre_emph_coeff_d;                      // preemph coefficient
  double amp_scale_d;                           // amplitude scale factor
  int pre_emph_flag_d;                          // preemph flag
  char* window_option_d;                        // window option
  int_4 fft_len_d;                              // fft length
  int_4 clear_d;                                // clear flag
  int_4 num_fft_d;                              // number of ffts computed 
  double fft_max_d;                             // maximum fft limit
  double fft_min_d;                             // minimum fft limit
  double max_freq_d;                            // maximum rate
  int_4 num_colors_d;                           // maximum number of colors
  double* fft_data_d;                           // fft data points
  XColor** colormap_d;                          // color map
  
} Spec_plot_item;

// declare function prototypes which operate on this widget
//
int spec_plot_bbox_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		      Spec_plot_item* spec_plot);
int spec_plot_config_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			Tk_Item* item_ptr, int argc,
			Tcl_Obj* const* argv, int flags);
int spec_plot_cmd_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		     Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv);
int spec_plot_coords_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv);
void spec_plot_destroy_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			  Display* display);
void spec_plot_display_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			  Display* display, Drawable drawable,
			  int x, int y, int width, int height);
void spec_plot_event_cc(ClientData client_data, XEvent* event_ptr);
int spec_plot_instance_cc(ClientData client_data, Tcl_Interp* interpreter,
			  int argc, Tcl_Obj* const* argv);
logical_1 spec_plot_redraw_cc(Spec_plot_item* spec_plot);
void spec_plot_scale_cc(Tk_Canvas canvas, Tk_Item* item_ptr, double origin_x,
			double origin_y, double scale_x, double scale_y);
double spec_plot_to_point_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			     double* point_ptr);
int spec_plot_compute_spectrogram_cc(Spec_plot_item* spec_plot, int_4 width);
int spec_plot_draw_spectrogram_cc(Spec_plot_item* spec_plot, Display* display,
				  Drawable drawable, int_4 width, int_4 height,
				  int_4 x_offset, int_4 y_offset, int_4 xcoord,
				  int_4 plot_width);


// declare prototypes for auxiliary functions
//
logical_1 spec_pre_emphasize_data_cc(double* data, double coeff,
				     long num_samples);
logical_1 spec_window_function_cc(double* data, int_4 num_samples,
			     Spec_plot_item* spec_plot);
logical compute_fft_cc(double* output, double* input, long fft_order,
		       double amplitude_scale_factor);
  
// declare a static array to hold the configuration specifications used
// to automatically process arguments to the command that creates a
// Spec_plot and to the configure operation that changes a widget.
// they define the command line flag, its type, its resource name, its
// class name, and its default value. Tk_Offset is a macro that gets the
// address of the structure member so the Spec_plot struct can be
// modified directly
//
static Tk_ConfigSpec spec_plot_config_specs[] = {
  
  // widget parameter configurations
  //
  {TK_CONFIG_STRING, (char*)SPEC_AUDIO_FILE_PARAM, "file", "File",
   (char*)NULL, Tk_Offset(Spec_plot_item, file_name_d), 0},  
  {TK_CONFIG_INT, (char*)SPEC_NUM_CHANS_PARAM, "num_chans", "Num_chans",
   (char*)SPEC_DEFAULT_NUM_CHANS, Tk_Offset(Spec_plot_item, num_chans_d),
   0},
  {TK_CONFIG_INT, (char*)SPEC_NUM_BYTES_PARAM, "num_bytes", "Num_bytes",
   (char*)SPEC_DEFAULT_NUM_BYTES, Tk_Offset(Spec_plot_item, num_bytes_d),
   0},
  {TK_CONFIG_INT, (char*)SPEC_DISPLAY_CHAN_PARAM, "display_chan",
   "Display_chan", (char*)SPEC_DEFAULT_DISPLAY_CHAN,
   Tk_Offset(Spec_plot_item, display_channel_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_SAMPLE_FREQ_PARAM, "sample_freq",
   "Sample_freq", (char*)SPEC_DEFAULT_SAMPLE_FREQ,
   Tk_Offset(Spec_plot_item, sf_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_START_TIME_PARAM, "start_time",
   "Start_time", (char*)SPEC_DEFAULT_START_TIME,
   Tk_Offset(Spec_plot_item, start_time_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_END_TIME_PARAM, "end_time", "End_time",
   (char*)SPEC_DEFAULT_END_TIME, Tk_Offset(Spec_plot_item, end_time_d), 0},
  {TK_CONFIG_INT, (char*)SPEC_FFT_LEN, "fft_len", "Fft_len",
   (char*)SPEC_DEFAULT_FFT_ORDER, Tk_Offset(Spec_plot_item, fft_len_d), 0},
  {TK_CONFIG_INT, (char*)SPEC_CLEAR, "clear", "Clear",
   (char*)SPEC_DEFAULT_CLEAR, Tk_Offset(Spec_plot_item, clear_d), 0},  
  {TK_CONFIG_DOUBLE, (char*)SPEC_BRIGHTNESS, "brightness", "Brightness",
   (char*)SPEC_DEFAULT_BRIGHTNESS, Tk_Offset(Spec_plot_item, brightness_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_CONTRAST, "contrast", "Contrast",
   (char*)SPEC_DEFAULT_CONTRAST, Tk_Offset(Spec_plot_item, contrast_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_AMP_SCALE_FACTOR, "amp_scale",
   "Amp_scale", (char*)SPEC_DEFAULT_AMP_SCALE,
   Tk_Offset(Spec_plot_item, amp_scale_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_MAX_RATE, "max_freq", "Max_freq",
   (char*)SPEC_DEFAULT_MAX_RATE, Tk_Offset(Spec_plot_item, max_freq_d), 0},
  {TK_CONFIG_INT, (char*)SPEC_SWAP_BYTES_PARAM, "swap_bytes", "Swap_bytes",
   (char*)SPEC_DEFAULT_SWAP_BYTES, Tk_Offset(Spec_plot_item,
					     swap_byte_flag_d), 0},
  {TK_CONFIG_INT, "-debug", "debug", "Debug",
   (char*)SPEC_DEFAULT_DEBUG, Tk_Offset(Spec_plot_item, debug_level_d),
   0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_WINLEN, "winlen", "Winlen",
   (char*)SPEC_DEFAULT_WIN_LEN,
   Tk_Offset(Spec_plot_item, win_length_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_FRAMELEN, "framelen", "Framelen",
   (char*)SPEC_DEFAULT_FRAME_LEN,
   Tk_Offset(Spec_plot_item, frame_length_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SPEC_PREEMPH, "preemph_coeff", "Preemph_coeff",
   (char*)SPEC_DEFAULT_PREEMPH,
   Tk_Offset(Spec_plot_item, pre_emph_coeff_d), 0},
  {TK_CONFIG_INT, (char*)SPEC_PREFLAG, "use_preemph", "Use_preemph",
   (char*)SPEC_DEFAULT_PREFLAG,
   Tk_Offset(Spec_plot_item, pre_emph_flag_d), 0},
  {TK_CONFIG_STRING, (char*)SPEC_WIN_OPTION, "filter", "Filter",
   (char*)SPEC_DEFAULT_WINDOW,
   Tk_Offset(Spec_plot_item, window_option_d), 0},
  
  // widget parameter configurations
  //
  {TK_CONFIG_INT, (char*)SPEC_X_LOC_PARAM, "x_loc", "X_loc",
   (char*)"0", Tk_Offset(Spec_plot_item, x_loc), 0},
  {TK_CONFIG_INT, (char*)SPEC_Y_LOC_PARAM, "y_loc", "Y_loc",
   (char*)"0", Tk_Offset(Spec_plot_item, y_loc), 0},  
  {TK_CONFIG_INT, (char*)SPEC_HEIGHT_PARAM, "height", "Height",
   (char*)SPEC_DEFAULT_HEIGHT_STR, Tk_Offset(Spec_plot_item, height), 0},
  {TK_CONFIG_INT, (char*)SPEC_WIDTH_PARAM, "width", "width",
   (char*)SPEC_DEFAULT_WIDTH_STR, Tk_Offset(Spec_plot_item, width), 0},
  {TK_CONFIG_INT, (char*)SPEC_DEPTH_PARAM, "depth", "depth",
   (char*)SPEC_DEFAULT_DEPTH_STR, Tk_Offset(Spec_plot_item, depth), 0},  
  
  // foreground color configuration
  //
  {TK_CONFIG_COLOR, "-foreground", "foreground", "Foreground",
   (char*)SPEC_DEFAULT_FOREGROUND_COLOR,
   Tk_Offset(Spec_plot_item, foreground), 0},
  {TK_CONFIG_SYNONYM, "-fg", "foreground", (char *) NULL,
   (char *) NULL, 0, 0},
  
  // background color configuration
  //
  {TK_CONFIG_BORDER, "-background", "background", "Background",
   (char*)SPEC_DEFAULT_BACKGROUND_COLOR,
   Tk_Offset(Spec_plot_item, background), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_BORDER, "-background", "background", "Background",
   (char*)SPEC_DEFAULT_BACKGROUND_COLOR,
   Tk_Offset(Spec_plot_item, background), TK_CONFIG_MONO_ONLY},
  {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
   (char *) NULL, 0, 0},
  
  // highlight color configuration
  //
  {TK_CONFIG_COLOR, "-highlightcolor", "highlightColor", "HighlightColor",
   (char*)SPEC_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Spec_plot_item, highlight), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_COLOR, "-highlightcolor", "highlightColor", "HighlightColor",
   (char*)SPEC_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Spec_plot_item, highlight), TK_CONFIG_MONO_ONLY},
  {TK_CONFIG_COLOR, "-highlightbackground", "highlightBackground",
   "HighlightBackground", (char*)SPEC_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Spec_plot_item, highlight_bg), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_COLOR, "-highlightbackground", "highlightBackground",
   "HighlightBackground", (char*)SPEC_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Spec_plot_item, highlight_bg), TK_CONFIG_MONO_ONLY},
  
  // border width configuration
  //
  {TK_CONFIG_PIXELS, "-borderwidth", "border_width", "Border_Width",
   (char*)SPEC_DEFAULT_BORDERWIDTH,
   Tk_Offset(Spec_plot_item, border_width),0},
  {TK_CONFIG_SYNONYM, "-bd", "border_width", (char *) NULL, (char *) NULL, 0,
   0},
  
  // relief type configuration
  //
  {TK_CONFIG_RELIEF, "-relief", "relief", "Relief",
   (char*)SPEC_DEFAULT_RELIEF_NAME, Tk_Offset(Spec_plot_item, relief), 0},
  
  // horizontal and vertical padding configuration
  //
  {TK_CONFIG_PIXELS, "-padx", "padX", "Pad",
   (char*)SPEC_DEFAULT_HORIZONTAL_PADDING,
   Tk_Offset(Spec_plot_item, padX), 0},
  {TK_CONFIG_PIXELS, "-pady", "padY", "Pad",
   (char*)SPEC_DEFAULT_VERTICAL_PADDING, Tk_Offset(Spec_plot_item, padY),
   0},
  
  // marks the end of the table - this must be the last entry in the table
  //
  {TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
   (char *) NULL, 0, 0}
};

// the structure below defines the spec plot item by means of procedures
// that can be invoked by generic item code implemented in tk
//
static Tk_ItemType Spec_plot_type = {
  
  (char*)SPEC_WIDGET_NAME, 			// name of widget
  sizeof(Spec_plot_item),			// item size
  spec_plot_cmd_cc,				// creation process
  spec_plot_config_specs,			// configuration specs
  spec_plot_config_cc, 			        // configuration process
  spec_plot_coords_cc,			        // coords canvas process
  spec_plot_destroy_cc,			        // deletion of the widget
  spec_plot_display_cc,			        // display process
  TK_CONFIG_OBJS,				// always redraw
  spec_plot_to_point_cc,			// tk point process
  (Tk_ItemAreaProc*) NULL,			// tk area process
  (Tk_ItemPostscriptProc*) NULL,		// tk postscript process
  spec_plot_scale_cc,				// tk scale process
  (Tk_ItemTranslateProc*) NULL,			// tk translate process
  (Tk_ItemIndexProc*) NULL,			// tk index process
  (Tk_ItemCursorProc*) NULL,			// tk cursor process
  (Tk_ItemSelectionProc*) NULL,			// tk selection process
  (Tk_ItemInsertProc*) NULL,			// tk insertion process
  (Tk_ItemDCharsProc*) NULL,			// tk dchars process?
  (Tk_ItemType*) NULL				// next pointer - init by tk
};

// end of include file
//
#endif
