// file: signal_plot_constants.h
//

// make sure definitions are made only once
//

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#define __ISIP_SIGNAL_PLOT_CONSTANTS
 
// isip include files
//
#ifndef __ISIP_INTEGRAL_CONSTANTS
#include <integral_constants.h>
#endif
 
// define the class name
//
#define SIGPLOT_WIDGET_NAME (char_1*)"signal_plot"

// define the configuration string
//
#define SIGPLOT_CONFIG_STRING (char_1*)"configure"

// define the error string returned from Tk_NameOfRelief
//
#define SIGPLOT_RELIEF_ERROR_NAME (char_1*)"unknown relief"

// define parameter strings
//
#define SIGPLOT_AUDIO_FILE_PARAM (char_1*)"-file"
#define SIGPLOT_NUM_CHANS_PARAM (char_1*)"-num_chans"
#define SIGPLOT_NUM_BYTES_PARAM (char_1*)"-num_bytes"
#define SIGPLOT_DISPLAY_CHAN_PARAM (char_1*)"-display_chan"
#define SIGPLOT_SAMPLE_FREQ_PARAM (char_1*)"-sample_freq"
#define SIGPLOT_START_TIME_PARAM (char_1*)"-start_time"
#define SIGPLOT_END_TIME_PARAM (char_1*)"-end_time"
#define SIGPLOT_GAIN_FACTOR_PARAM (char_1*)"-gain_factor"
#define SIGPLOT_SWAP_BYTES_PARAM (char_1*)"-swap_bytes"
#define SIGPLOT_HEIGHT_PARAM (char_1*)"-height"
#define SIGPLOT_WIDTH_PARAM (char_1*)"-width"
#define SIGPLOT_X_LOC_PARAM (char_1*)"-x_loc"
#define SIGPLOT_Y_LOC_PARAM (char_1*)"-y_loc"

// define the default widget characteristics
//
#define SIGPLOT_DEFAULT_FOREGROUND_COLOR (char_1*)"black"
#define SIGPLOT_DEFAULT_BACKGROUND_COLOR (char_1*)"white"
#define SIGPLOT_DEFAULT_HIGHLIGHT_COLOR (char_1*)"red"
#define SIGPLOT_DEFAULT_BORDERWIDTH (char_1*)"2"
#define SIGPLOT_DEFAULT_RELIEF_NAME (char_1*)"ridge"
#define SIGPLOT_DEFAULT_RELIEF TK_RELIEF_RIDGE
#define SIGPLOT_DEFAULT_HIGHLIGHT_THICKNESS (char_1*)"2"
#define SIGPLOT_DEFAULT_HORIZONTAL_PADDING (char_1*)"2"
#define SIGPLOT_DEFAULT_VERTICAL_PADDING (char_1*)"2"
#define SIGPLOT_DEFAULT_FONT (char_1*)"*courier-medium-r-normal-*-8-*"

// define some boolean flags for use with this widget
//
#define SIGPLOT_TRUE 1
#define SIGPLOT_TRUE_STRING (char_1*)"1"
#define SIGPLOT_FALSE 0
#define SIGPLOT_FALSE_STRING (char_1*)"0"

// define default structure members
//
#define SIGPLOT_DEFAULT_NUM_CHANS (char_1*)"2"
#define SIGPLOT_DEFAULT_NUM_BYTES (char_1*)"2"
#define SIGPLOT_DEFAULT_DISPLAY_CHAN (char_1*)"0"
#define SIGPLOT_DEFAULT_SAMPLE_FREQ (char_1*)"8000.0"
#define SIGPLOT_DEFAULT_GAIN_FACTOR (char_1*)"1.0"
#define SIGPLOT_DEFAULT_START_TIME (char_1*)"0.0"
#define SIGPLOT_DEFAULT_END_TIME (char_1*)"0.0"
#define SIGPLOT_DEFAULT_DEBUG (char_1*)"0"
#define SIGPLOT_DEFAULT_SWAP_BYTES SIGPLOT_FALSE_STRING

// define the default height and width of this widget
//
#define SIGPLOT_DEFAULT_HEIGHT_STR (char_1*)"200"
#define SIGPLOT_DEFAULT_HEIGHT_VAL 200
#define SIGPLOT_DEFAULT_WIDTH_STR (char_1*)"400"
#define SIGPLOT_DEFAULT_WIDTH_VAL 400

// define the length and separation of the ticks in pixels
//
#define SIGPLOT_DEFAULT_TICK_RES 5
#define SIGPLOT_DEFAULT_MAJOR_TICK 6
#define SIGPLOT_DEFAULT_MINOR_TICK 3

// define the default resolution scaling of the widget plotting
//
#define SIGPLOT_DEFAULT_RES_SCALE (int_4) 2
#define SIGPLOT_INITIAL_MAX_AMP (float_4) 0.0

// set the minimum number of args to the widget
//
#define SIGPLOT_MINIMUM_NUM_ARGS 2

// set the default buffer size
//
#define SIGPLOT_DEFAULT_BUFFER_SIZE 32000

// set the number of vertices in a polygon which describes this item
// in this case it is a rectangle
//
#define SIGPLOT_POLY_VERTICES 4

// set flag constants
//
#define SIGPLOT_REDRAW_NEEDED 0x1

// end of file
//
#endif



