// file: signal_plot.h
//

// make sure definitions are made only once
//
#ifndef __ISIP_SIGNAL_PLOT
#define __ISIP_SIGNAL_PLOT

// isip include files
//
#ifndef __ISIP_INTEGRAL
#include <integral.h>
#endif

#ifndef __ISIP_SIGNAL_PLOT_CONSTANTS
#include "signal_plot_constants.h"
#endif

// system include files
//
#include <tk.h>
//#include <tkInt.h>
//#include <tkPort.h>

// item: Signal_plot_item
//
// this file defines a structure for the Tk widget Signal_plot. this widget
// will show the amplitude vs time plot of a audio signal
//
typedef struct Signal_plot_item {

  // required for all canvas sub-items
  //
  Tk_Item header;				// MUST BE FIRST THING IN
						// STRUCTURE
  // interpreter for this widget
  //
  Tcl_Interp* interpreter;
  
  // required data
  //
  Tk_Canvas canvas;				// canvas containing item
  
  // geometry data
  //
  double x;					// defines the x and y coords
  double y;					//    of the insertion point
						//    in canvas units
  int x_loc;					// defines the x and y coords
  int y_loc;					//    of the insertion points
						//    in pixels
  int width;					// desired width of window
  int height;					// desired height of window
						//    don't count on these to
						//    be true
  double* coord_ptr;				// coordinates of widget bounds
  XPoint* plotted_points;			// line endpoints plotted to
						//    the canvas
  int_4 num_points;				// number of points plotted
  Pixmap pixmap;				// number of points plotted  
  
  // graphics settings
  //
  int border_width;				// size of 3-D border
  int relief;					// style of 3-D border
  Tk_3DBorder background;			// color for border, background
  XColor* foreground;				// color for the text
  XColor* highlight;				// color for the highlight
  XColor* highlight_bg;				// color for the highlight bg
  GC highlight_gc;				// window graphics contexts
  GC text_gc;					// text graphics contexts
  int highlight_width;				// thickness of the highlight
  int padX;					// horizontal padding
  int padY;					// vertical padding
  int flags;					// status flags
  char* font;					// font string

  // widget specific data
  //
  char* file_name_d;				// name of file to read from
  int_4 num_chans_d;				// number of channels in file
  int_4 num_bytes_d;				// number of bytes per sample
  int_4 display_channel_d;			// channel to display
  double sf_d;					// sample rate
  int swap_byte_flag_d;				// type of byte swapping
  double start_time_d;				// start time of window
  double end_time_d;				// end time of window
  double gain_factor_d;				// end time of window  
  int_4 debug_level_d;				// debug level
  
} Signal_plot_item;

// declare function prototypes which operate on this widget
//
int signal_plot_bbox_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			Signal_plot_item* sig_plot);
int signal_plot_config_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			  Tk_Item* item_ptr, int argc,Tcl_Obj* const* argv,
			  int flags);
int signal_plot_cmd_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
		       Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv);
int signal_plot_coords_cc(Tcl_Interp* interpreter, Tk_Canvas canvas,
			  Tk_Item* item_ptr, int argc, Tcl_Obj* const* argv);
void signal_plot_destroy_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display);
void signal_plot_display_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			    Display* display, Drawable drawable,
			    int x, int y, int width, int height);
void signal_plot_event_cc(ClientData client_data, XEvent* event_ptr);
int signal_plot_instance_cc(ClientData client_data, Tcl_Interp* interpreter,
			    int argc, Tcl_Obj* const* argv);
logical_1 signal_plot_redraw_cc(Signal_plot_item* sig_plot);
void signal_plot_scale_cc(Tk_Canvas canvas, Tk_Item* item_ptr, double origin_x,
			  double origin_y, double scale_x, double scale_y);
double signal_plot_to_point_cc(Tk_Canvas canvas, Tk_Item* item_ptr,
			       double* point_ptr);
int signal_plot_plot_points_cc(Signal_plot_item* sig_plot, int_4& num_pts,
                               XPoint** points, int width, int height,
			       int x_offset, int y_offset, Display* display,
			       Drawable drawable);
int signal_plot_plot_ticks_cc(Signal_plot_item* sig_plot, Display* display,
			      Drawable drawable, int area_width,
			      int area_height, int x_offset, int y_offset);
					 
// declare a static array to hold the configuration specifications used
// to automatically process arguments to the command that creates a
// Signal_plot and to the configure operation that changes a widget.
// they define the command line flag, its type, its resource name, its
// class name, and its default value. Tk_Offset is a macro that gets the
// address of the structure member so the Signal_plot struct can be
// modified directly
//
static Tk_ConfigSpec signal_plot_config_specs[] = {

  // widget parameter configurations
  //
  {TK_CONFIG_STRING, (char*)SIGPLOT_AUDIO_FILE_PARAM, "file", "File",
   (char*)NULL, Tk_Offset(Signal_plot_item, file_name_d), 0},  
  {TK_CONFIG_INT, (char*)SIGPLOT_NUM_CHANS_PARAM, "num_chans", "Num_chans",
   (char*)SIGPLOT_DEFAULT_NUM_CHANS, Tk_Offset(Signal_plot_item, num_chans_d),
   0},
  {TK_CONFIG_INT, (char*)SIGPLOT_NUM_BYTES_PARAM, "num_bytes", "Num_bytes",
   (char*)SIGPLOT_DEFAULT_NUM_BYTES, Tk_Offset(Signal_plot_item, num_bytes_d),
   0},
  {TK_CONFIG_INT, (char*)SIGPLOT_DISPLAY_CHAN_PARAM, "display_chan",
   "Display_chan", (char*)SIGPLOT_DEFAULT_DISPLAY_CHAN,
   Tk_Offset(Signal_plot_item, display_channel_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SIGPLOT_SAMPLE_FREQ_PARAM, "sample_freq",
   "Sample_freq", (char*)SIGPLOT_DEFAULT_SAMPLE_FREQ,
   Tk_Offset(Signal_plot_item, sf_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SIGPLOT_START_TIME_PARAM, "start_time",
   "Start_time", (char*)SIGPLOT_DEFAULT_START_TIME,
   Tk_Offset(Signal_plot_item, start_time_d), 0},
  {TK_CONFIG_DOUBLE, (char*)SIGPLOT_END_TIME_PARAM, "end_time", "End_time",
   (char*)SIGPLOT_DEFAULT_END_TIME, Tk_Offset(Signal_plot_item, end_time_d),
   0},
  {TK_CONFIG_DOUBLE, (char*)SIGPLOT_GAIN_FACTOR_PARAM, "gain_factor",
   "Gain_factor", (char*)SIGPLOT_DEFAULT_GAIN_FACTOR,
   Tk_Offset(Signal_plot_item, gain_factor_d), 0},
  {TK_CONFIG_INT, (char*)SIGPLOT_SWAP_BYTES_PARAM, "swap_bytes", "Swap_bytes",
   (char*)SIGPLOT_DEFAULT_SWAP_BYTES, Tk_Offset(Signal_plot_item,
						swap_byte_flag_d), 0},
  {TK_CONFIG_INT, "-debug", "debug", "Debug",
   (char*)SIGPLOT_DEFAULT_DEBUG, Tk_Offset(Signal_plot_item, debug_level_d),
   0},
  

  // widget parameter configurations
  //
  {TK_CONFIG_INT, (char*)SIGPLOT_X_LOC_PARAM, "x_loc", "X_loc",
   (char*)"0", Tk_Offset(Signal_plot_item, x_loc), 0},
  {TK_CONFIG_INT, (char*)SIGPLOT_Y_LOC_PARAM, "y_loc", "Y_loc",
   (char*)"0", Tk_Offset(Signal_plot_item, y_loc), 0},  
  {TK_CONFIG_INT, (char*)SIGPLOT_HEIGHT_PARAM, "height", "Height",
   (char*)SIGPLOT_DEFAULT_HEIGHT_STR, Tk_Offset(Signal_plot_item, height), 0},
  {TK_CONFIG_INT, (char*)SIGPLOT_WIDTH_PARAM, "width", "width",
   (char*)SIGPLOT_DEFAULT_WIDTH_STR, Tk_Offset(Signal_plot_item, width), 0},  

  // foreground color configuration
  //
  {TK_CONFIG_COLOR, "-foreground", "foreground", "Foreground",
   (char*)SIGPLOT_DEFAULT_FOREGROUND_COLOR,
   Tk_Offset(Signal_plot_item, foreground), 0},
  {TK_CONFIG_SYNONYM, "-fg", "foreground", (char *) NULL,
   (char *) NULL, 0, 0},
  
  // background color configuration
  //
  {TK_CONFIG_BORDER, "-background", "background", "Background",
   (char*)SIGPLOT_DEFAULT_BACKGROUND_COLOR,
   Tk_Offset(Signal_plot_item, background), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_BORDER, "-background", "background", "Background",
   (char*)SIGPLOT_DEFAULT_BACKGROUND_COLOR,
   Tk_Offset(Signal_plot_item, background), TK_CONFIG_MONO_ONLY},
  {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
   (char *) NULL, 0, 0},

  // highlight color configuration
  //
  {TK_CONFIG_COLOR, "-highlightcolor", "highlightColor", "HighlightColor",
   (char*)SIGPLOT_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Signal_plot_item, highlight), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_COLOR, "-highlightcolor", "highlightColor", "HighlightColor",
   (char*)SIGPLOT_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Signal_plot_item, highlight), TK_CONFIG_MONO_ONLY},
  {TK_CONFIG_COLOR, "-highlightbackground", "highlightBackground",
   "HighlightBackground", (char*)SIGPLOT_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Signal_plot_item, highlight_bg), TK_CONFIG_COLOR_ONLY},
  {TK_CONFIG_COLOR, "-highlightbackground", "highlightBackground",
   "HighlightBackground", (char*)SIGPLOT_DEFAULT_HIGHLIGHT_COLOR,
   Tk_Offset(Signal_plot_item, highlight_bg), TK_CONFIG_MONO_ONLY},

  // border width configuration
  //
  {TK_CONFIG_PIXELS, "-borderwidth", "border_width", "Border_Width",
   (char*)SIGPLOT_DEFAULT_BORDERWIDTH,
   Tk_Offset(Signal_plot_item, border_width),0},
  {TK_CONFIG_SYNONYM, "-bd", "border_width", (char *) NULL, (char *) NULL, 0,
   0},

  // relief type configuration
  //
  {TK_CONFIG_RELIEF, "-relief", "relief", "Relief",
   (char*)SIGPLOT_DEFAULT_RELIEF_NAME, Tk_Offset(Signal_plot_item, relief), 0},

  // horizontal and vertical padding configuration
  //
  {TK_CONFIG_PIXELS, "-padx", "padX", "Pad",
   (char*)SIGPLOT_DEFAULT_HORIZONTAL_PADDING,
   Tk_Offset(Signal_plot_item, padX), 0},
  {TK_CONFIG_PIXELS, "-pady", "padY", "Pad",
   (char*)SIGPLOT_DEFAULT_VERTICAL_PADDING, Tk_Offset(Signal_plot_item, padY),
   0},

  // marks the end of the table - this must be the last entry in the table
  //
  {TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
   (char *) NULL, 0, 0}
};

// the structure below defines the signal plot item by means of procedures
// that can be invoked by generic item code implemented in tk
//
static Tk_ItemType Signal_plot_type = {

  (char*)SIGPLOT_WIDGET_NAME, 			// name of widget
  sizeof(Signal_plot_item),			// item size
  signal_plot_cmd_cc,				// creation process
  signal_plot_config_specs,			// configuration specs
  signal_plot_config_cc, 			// configuration process
  signal_plot_coords_cc,			// coords canvas process
  signal_plot_destroy_cc,			// deletion of the widget
  signal_plot_display_cc,			// display process
  TK_CONFIG_OBJS, 				// always redraw
  signal_plot_to_point_cc,			// tk point process
  (Tk_ItemAreaProc*) NULL,			// tk area process
  (Tk_ItemPostscriptProc*) NULL,		// tk postscript process
  signal_plot_scale_cc,				// tk scale process
  (Tk_ItemTranslateProc*) NULL,			// tk translate process
  (Tk_ItemIndexProc*) NULL,			// tk index process
  (Tk_ItemCursorProc*) NULL,			// tk cursor process
  (Tk_ItemSelectionProc*) NULL,			// tk selection process
  (Tk_ItemInsertProc*) NULL,			// tk insertion process
  (Tk_ItemDCharsProc*) NULL,			// tk dchars process?
  (Tk_ItemType*) NULL				// next pointer - init by tk
};

// end of include file
//
#endif

