// file: $isip/class/math/integral/integral_old.h
//
// this is the basic isip environment include file. all integral types
// are defined in this file. these are also implemented as C++ classes.
// all software must be built upon these basic types.
//
// these definitions follow a format in which the data type is related
// to particular machine defined formats. the syntax is type_x, where
// type refers to a standard C data type, and x refers to the number
// of bytes required by a machine-specific implementation.

// make sure definitions are only made once
// follow the standard isip convention in defining the symbol to be
// used to signal the preprocessor
//
#ifndef __ISIP_INTEGRAL_OLD
#define __ISIP_INTEGRAL_OLD

// system include files - since all classes include a debug method that
//  requires a definition of FILE*, we will include this file here,
//  in order that every class need not replicate this. For convenience,
//  we also include stdlib.h, since this contains many useful C functions.
//
#include <stdio.h>
#include <stdlib.h>

// integral type #0: void pointer
//
typedef void* void_p;

// integral type #1: logical or boolean variables
//
typedef signed char logical_1;

// integral type #2: a character
//
// this is mainly for convenience. a character object is actually a
// multi-byte sequence that supports multiple encoding sequences.
// this definition is mainly to support/interface to C.
//
typedef unsigned char char_1;

// integral type #3: a signed integer
//
typedef char int_1;
typedef short int int_2;
typedef long int int_4;

// integral type #4: an unsigned integer
//
typedef unsigned char uint_1;
typedef unsigned short int uint_2;
typedef unsigned long int uint_4;

// integral type #5: a floating point number
//
typedef float float_4;
typedef double float_8;

// end of include file
//
#endif
