// file: $isip/class/math/integral/integral.h
//
// this is the basic isip environment include file. all integral types
// are defined in this file. these are also implemented as C++ classes.
// all software must be built upon these basic types.
//
// these definitions follow a format in which the data type is related
// to particular machine defined formats. 

// make sure definitions are only made once
// follow the standard isip convention in defining the symbol to be
// used to signal the preprocessor
//
#ifndef __ISIP_INTEGRAL
#define __ISIP_INTEGRAL

// include the old integral.h types.
//
#ifndef __ISIP_INTEGRAL_OLD
#include <integral_old.h>
#endif

// system include files - since all classes include a debug method that
//  requires a definition of FILE*, we will include this file here,
//  in order that every class need not replicate this. For convenience,
//  we also include stdlib.h, since this contains many useful C functions.
//
#include <stdio.h>
#include <stdlib.h>

// integral type #0: void pointer
//
typedef void* voidp;

// integral type #1: logical or boolean variables
//
typedef signed char boolean;
typedef signed char logical;

// integral type #2: a single byte of data
//
typedef unsigned char byte;

// integral type #3: a character
//
// this is mainly for convenience. a character object is actually a
// multi-byte sequence that supports multiple encoding sequences.
// this definition is mainly to support/interface to C. the unichar
// scalar type is unique in that sizeof(unichar) != sizeof(Unichar),
// but for standard C and efficiency issues this is unavoidable.
//
typedef unsigned char unichar;

// integral type #4: a signed integer
//
typedef unsigned short int ushort;
typedef unsigned long int ulong;
typedef unsigned long long int ullong;

// integral type #5: an unsigned integer
//
// since our namespace conflicts with standard C, we do not actually
// make a typedef. these lines are included in this file as a
// reference for the programmer of the base classes.
//
//typedef short int short;
//typedef long int long;
typedef long long int llong;

// integral type #6: a floating point number
//
// since our namespace conflicts with standard C, we do not actually
// make a typedef. these lines are included in this file as a
// reference for the programmer of the base classes.
//
//typedef float float;
//typedef double double;

// end of include file
//
#endif
